-- d47
-- Bayn TSF3
-- Big thanks to guimchevalier for his script "Pince.lua"
-- 03-09-09
-- Automated Load/Unload added by Nibmeister
-- LS2011 Script: Burner
-- EDIT: Nikko95
-- 28/02/2011


d47 = {};

function d47.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function d47:load(xmlFile)	
		
	self.numAttachers = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Attachers#count"), 0);
	self.Attacher = {};
	self.attacherLevel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Attachers#index"));
	self.ulMode = 1;
	self.ulRef = {{"prawa",false,{0,0,-5}},{"lewa",false,{0,0,5}},{"tyl",false,{-5,0,0}}};	
	for i=1, self.numAttachers do
	 self.Attacher[i] = {};
	 local partnamei = string.format("vehicle.Attachers.objectAttacher".."%d",i);
	 self.Attacher[i].object = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partnamei .. "#index"));
	 setRigidBodyType(self.Attacher[i].coll,"none")
	 self.Attacher[i].attachedObject = nil;
	 self.Attacher[i].objectInRange = nil;
	end;

end;

function d47:getSaveAttributesAndNodes(nodeIdent)
    for i=1, self.numAttachers do
        ObjectDetachd47(self,i)
    end;
    
   return nil, nil;
end;


function d47:delete()
	for i=1, self.numAttachers do
		ObjectDetachd47(self,i)
	end;
end;

function d47:mouseEvent(posX, posY, isDown, isUp, button)
end;

function d47:keyEvent(unicode, sym, modifier, isDown)
	
end;

function d47:update(dt)
		

	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.d47DETACH) then
			-- dcrochage
			for i=1, self.numAttachers do
			ObjectDetachd47(self,i)
			end;
		end;

		if InputBinding.isPressed(InputBinding.d47ATTACH) then
			-- dtection ballot
			for i=1, self.numAttachers do
				nearest, index = ObjectInRanged47(self,i);
				self.Attacher[i].objectInRange = nearest;
				-- accrochage
				ObjectAttachd47(self,i)
			end;
		end;
	end;
end;

function d47:draw()
	g_currentMission:addExtraPrintText(string.format("Klawisz NUM /: Zaladuj snopki"));
	g_currentMission:addExtraPrintText(string.format("Klawisz NUM *: Rozladuj snopki"));

	--g_currentMission:addHelpButtonText("Zbierz snopki", InputBinding.d47ATTACH);
	--g_currentMission:addHelpButtonText("Rozladuj snopki", InputBinding.d47ATTACH);

end;

function ObjectInRanged47(self,k)
	--renderText(0.632, 0.225, 0.05, string.format("in range"));
	local nearestObject
	local itemNode
	local index 
	local nearestDistance = 8;
	local objectCopy = self.Attacher[k].object;	
	local px, py, pz = getWorldTranslation(objectCopy);
	for index, item in pairs(g_currentMission.itemsToSave) do
	    itemNode = item.item.nodeId;
	    if getParent(item.item.nodeId) == getRootNode() then
			if getUserAttribute(itemNode, "isStrawbale") or getUserAttribute(itemNode, "isHaybale") then
				local vx, vy, vz = getWorldTranslation(itemNode);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then
					index = index;
					nearestObject = itemNode
					nearestDistance = distance
				end;
			end;
		end;
	end;
	return nearestObject, index
end;

function ObjectAttachd47(self,k)
	if self.Attacher[k].objectInRange ~= nil then
		if self.Attacher[k].attachedObject == nil then
			setRigidBodyType(self.Attacher[k].objectInRange,"none");
			local x,y,z = getWorldRotation(self.Attacher[k].objectInRange);		
			link(self.Attacher[k].object,self.Attacher[k].objectInRange);
			setRotation(self.Attacher[k].objectInRange, 0,0,0);
			setTranslation(self.Attacher[k].objectInRange, 0,0,0)
			self.Attacher[k].attachedObject = self.Attacher[k].objectInRange;
			self.Attacher[k].objectInRange = nil;
		end;
	end;
end;

function ObjectDetachd47(self,k)
	if self.Attacher[k].attachedObject ~= nil then			
		if not self.ulRef[self.ulMode][2] then
			local x,y,z = getWorldTranslation(self.Attacher[k].attachedObject)
			local rx,ry,rz = getWorldRotation(self.Attacher[k].attachedObject)
			local nx,ny,nz = getWorldTranslation(self.attacherLevel);
			local tx,ty,tz = unpack(self.ulRef[self.ulMode][3]);
			local x = x + tx
			local y = y + ty
			local z = z + tz
			local tH = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local relHeight = ny - tH
			local root = getRootNode()
			setRigidBodyType(self.Attacher[k].attachedObject,"Dynamic")
			setTranslation(self.Attacher[k].attachedObject,x,(y - relHeight),z)
			setRotation(self.Attacher[k].attachedObject,rx,ry,rz)
			link(root,self.Attacher[k].attachedObject)
			self.Attacher[k].attachedObject = nil;
		else
			---[[ --Custom unloading chunk.  If you break the game with this and can't fix it, remove a dash from this line to deactivate it.
			--print(self.ulRef[self.ulMode][3]);
			-- End of custom unloading chunk. Just leave this line alone.]]
		end;
	end;
end;