Setblends6Event = {};
Setblends6Event_mt = Class(Setblends6Event, Event);
InitEventClass(Setblends6Event, "Setblends6Event");
function Setblends6Event:emptyNew()
      local self = Event:new(Setblends6Event_mt);
      self.className="Setblends6Event";
      return self;
end;
function Setblends6Event:new(object, active)
      local self = Setblends6Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends6Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends6Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends6Event:run(connection)
      self.object:setblends6Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends6Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;