Setblends4Event = {};
Setblends4Event_mt = Class(Setblends4Event, Event);
InitEventClass(Setblends4Event, "Setblends4Event");
function Setblends4Event:emptyNew()
      local self = Event:new(Setblends4Event_mt);
      self.className="Setblends4Event";
      return self;
end;
function Setblends4Event:new(object, active)
      local self = Setblends4Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends4Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends4Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends4Event:run(connection)
      self.object:setblends4Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends4Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;