--
-- Specialization for farmer car mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- Specialization for Blinker mod
--
-- @autor Sebastian B. (Blancker, www.landwirtschaftssimualtor-2009.de)
-- @update 15/08/09
--

wheels = {};

function wheels.prerequisitesPresent(specializations)
    return true;
end;

function wheels:load(xmlFile)

    self.twinVL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVL#index"));
    self.twinVR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVR#index"));
    self.twinHL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHL#index"));
    self.twinHR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHR#index"));

end;

function wheels:delete()
end;

function wheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheels:keyEvent(unicode, sym, modifier, isDown)

     if isDown and sym == Input.KEY_u then
		self.dualwheels = not self.dualwheels;
		setVisibility(self.twinVL, self.dualwheels);
		setVisibility(self.twinVR, self.dualwheels);
        setVisibility(self.twinHL, self.dualwheels);
		setVisibility(self.twinHR, self.dualwheels);			
	end;
    

	-- Anfang Info Panel 
	if isDown and sym == Input.KEY_0 then
        self.helpPanel = not self.helpPanel;
    end;
	-- Ende Info Panel
end;

function wheels:update(dt)
end;

function wheels:draw()

		if not self.helpPanel then
            renderText(0.8335, 0.22, 0.021, "Taste 0: Info ein");
        else
            renderText(0.8335, 0.22, 0.021, "Taste 0: Info aus");
        end;
        
        if self.helpPanel then
            renderText(0.80, 0.54, 0.02, "- Info -");
			renderText(0.78, 0.52, 0.02, "Taste KP_period: Moteur on/off");
			renderText(0.78, 0.50, 0.02, "Taste U: Jumelage");
			renderText(0.78, 0.48, 0.02, "Taste KP 1: Porte gauche");
			renderText(0.78, 0.46, 0.02, "Taste KP 2: Fenetre arriere");
			renderText(0.78, 0.44, 0.02, "Taste 5: Feu travail arriere");
			renderText(0.78, 0.42, 0.02, "Taste 6: Feu travail avant");
			renderText(0.78, 0.40, 0.02, "Taste F: Feux de route");
			
		end;
	
end;

function wheels:onLeave()
end;