smykove_brany = {};

function smykove_brany.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function smykove_brany:load(xmlFile)

	local rotationNodePartGauche = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartGauche#index"));
    if rotationNodePartGauche ~= nil then
        self.rotationPartGauche = {};
        self.rotationPartGauche.node = rotationNodePartGauche;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartGauche#minRot"));
        self.rotationPartGauche.minRot = {};
        self.rotationPartGauche.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartGauche.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartGauche.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartGauche#maxRot"));
        self.rotationPartGauche.maxRot = {};
        self.rotationPartGauche.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartGauche.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartGauche.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartGauche.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartGauche#rotTime"), 2)*1000;
        self.rotationPartGauche.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartGauche#touchRotLimit"), 10));
    end; 
	self.rotationMaxGauche = false;
	
	local rotationNodePartDroit = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDroit#index"));
    if rotationNodePartDroit ~= nil then
        self.rotationPartDroit = {};
        self.rotationPartDroit.node = rotationNodePartDroit;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDroit#minRot"));
        self.rotationPartDroit.minRot = {};
        self.rotationPartDroit.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDroit.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDroit.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDroit#maxRot"));
        self.rotationPartDroit.maxRot = {};
        self.rotationPartDroit.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDroit.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDroit.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDroit.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDroit#rotTime"), 2)*1000;
        self.rotationPartDroit.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDroit#touchRotLimit"), 10));
    end; 
	self.rotationMaxDroit = false; 	
    self.groundContactReport = SpecializationUtil.callSpecializationsFunction("groundContactReport");
    self.contactReportNodes = {};
    local contactReportNodeFound = false;
    local i=0;
    while true do
        local baseName = string.format("vehicle.contactReportNodes.contactReportNode(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            local entry = {};
            entry.node = node;
            entry.hasGroundContact = false;

            self.contactReportNodes[node] = entry;
            contactReportNodeFound = true;
        end;
        i = i+1;
    end;
    if not contactReportNodeFound then
        local entry = {};
        entry.node = self.components[1].node;
        entry.hasGroundContact = false;
        self.contactReportNodes[entry.node] = entry;
    end;

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));

end;
function smykove_brany:delete()
end;
function smykove_brany:mouseEvent(posX, posY, isDown, isUp, button)
end;

function smykove_brany:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_x then
		self.rotationMaxDroit = not self.rotationMaxDroit; 	
		self.rotationMaxGauche = not self.rotationMaxGauche;		
	end;
end;

function smykove_brany:update(dt)

	if self.rotationPartGauche ~= nil then
        local x, y, z = getRotation(self.rotationPartGauche.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartGauche.maxRot, self.rotationPartGauche.minRot, 3, self.rotationPartGauche.rotTime, dt, not self.rotationMaxGauche);
        setRotation(self.rotationPartGauche.node, unpack(newRot));
    end;  
	if self.rotationPartDroit ~= nil then
        local x, y, z = getRotation(self.rotationPartDroit.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartDroit.maxRot, self.rotationPartDroit.minRot, 3, self.rotationPartDroit.rotTime, dt, not self.rotationMaxDroit);
        setRotation(self.rotationPartDroit.node, unpack(newRot));
    end;  
	
    if self:getIsActive() then
        local hasGroundContact = false;
        for k, v in pairs(self.contactReportNodes) do
            if v.hasGroundContact then
                hasGroundContact = true;
                break;
            end;
        end;

        if not hasGroundContact then
            if self.groundReferenceNode ~= nil then
                local x,y,z = getWorldTranslation(self.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+self.groundReferenceThreshold >= y then
                    hasGroundContact = true;
                end;
            end;
        end;
	end;
end;


function smykove_brany:draw()
	if self.rotationMaxDroit then
		g_currentMission:addExtraPrintText(string.format("X : Slozit brany"));		
	else
		g_currentMission:addExtraPrintText(string.format("X : Rozlozit brany"));		
	end;
end;
function smykove_brany:addContactReports()
    if not self.cultiplowContactReportsActive then
        for k, v in pairs(self.contactReportNodes) do
            addContactReport(v.node, 0.0001, "groundContactReport", self);
        end;

        self.cultivatorContactReportsActive = true;
    end;
end;

function smykove_brany:removeContactReports()
    if self.cultiplowContactReportsActive then
        for k, v in pairs(self.contactReportNodes) do
            removeContactReport(v.node);
            v.hasGroundContact = false;
        end;
        self.cultiplowContactReportsActive = false;
    end;
end;

function smykove_brany:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)

    if otherObjectId == g_currentMission.terrainRootNode then
        local entry = self.contactReportNodes[objectId];
        if entry ~= nil then
            entry.hasGroundContact = isStart or normalForce > 0 or tangentialForce > 0;
        end;
    end;

end;