-- 
-- by PeterJ (28/01/2011)
-- 

ROPS = {};

function ROPS.prerequisitesPresent(specializations)

    return true;
end;

function ROPS:load(xmlFile)
     self.setRotationMaxArco = SpecializationUtil.callSpecializationsFunction("setRotationMaxArco");	 
	
	local rotationPartNodeArco = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartArco#index"));
    if rotationPartNodeArco ~= nil then
        self.rotationPartArco = {};
        self.rotationPartArco.node = rotationPartNodeArco;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartArco#minRot"));
        self.rotationPartArco.minRot = {};
        self.rotationPartArco.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartArco.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartArco.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartArco#maxRot"));
        self.rotationPartArco.maxRot = {};
        self.rotationPartArco.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartArco.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartArco.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartArco.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartArco#rotTime"), 2)*1000;
        self.rotationPartArco.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartArco#touchRotLimit"), 10));
    end;

		self.rotationMaxArco = false;
end;

function ROPS:readStream(streamId, connection)
     self.rotateMax = streamReadBool(streamId);
     if self.rotationPartArco ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
         setRotation(self.rotationPartArco.node, x, y, z);
      end;
end;
  
function ROPS:writeStream(streamId, connection)
      streamWriteBool(streamId, self.rotateMax);
		if self.rotationPartArco ~= nil then
          local x, y, z = getRotation(self.rotationPartArco.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function ROPS:delete()

end;

function ROPS:keyEvent(unicode, sym, modifier, isDown)


end;

function ROPS:update(dt)
      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.ROPS) then
				self:setRotationMaxArco(not self.rotationMaxArco);
          end;	  
     end;
end;

function ROPS:updateTick(dt)
	if self:getIsActive() and self.isClient then
			if self.rotationPartArco ~= nil then
				local x, y, z = getRotation(self.rotationPartArco.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartArco.maxRot, self.rotationPartArco.minRot, 3, self.rotationPartArco.rotTime, dt, not self.rotationMaxArco);
				setRotation(self.rotationPartArco.node, unpack(newRot));
			end;

	end;		
end;

function ROPS:draw()

  
end;


function ROPS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ROPS:setRotationMaxArco(rotationMaxArco, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetArcoRotationEvent:new(self, rotationMaxArco), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetArcoRotationEvent:new(self, rotationMaxArco));
          end;
      end;
      self.rotationMaxArco = rotationMaxArco;
end;


SetArcoRotationEvent = {};
SetArcoRotationEvent_mt = Class(SetArcoRotationEvent, Event);
  
InitEventClass(SetArcoRotationEvent, "SetArcoRotationEvent");
  
function SetArcoRotationEvent:emptyNew()
      local self = Event:new(SetArcoRotationEvent_mt);
      self.className="SetArcoRotationEvent";
      return self;
 end;

function SetArcoRotationEvent:new(object, rotationMaxArco)
      local self = SetArcoRotationEvent:emptyNew()
      self.object = object;
      self.rotationMaxArco = rotationMaxArco;
      return self;
end;
 
function SetArcoRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMaxArco = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetArcoRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMaxArco);
end;
 
function SetArcoRotationEvent:run(connection)
      self.object:setRotationMaxArco(self.rotationMaxArco, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetArcoRotationEvent:new(self.object, self.rotationMaxArco), nil, connection, self.object);
      end;
end;