-- 
-- by PeterJ (28/01/2011)
--  


MF240 = {};

function MF240.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MF240:load(xmlFile)

	self.drivingShaft = {};
	self.drivingShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#index"));

	self.barra = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.barra#index"));

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
	self.setHydraulicTime = 30;

	setVisibility(self.barra, true);

end;

function MF240:keyEvent(unicode, sym, modifier, isDown)

end;

function MF240:update(dt)
	
	if self.drivingShaft ~= nil then
			local x,y,z = getRotation(self.wheels[1].driveNode);
			setRotation(self.drivingShaft.node, 0 ,0, x*2);	
	end;

		if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;	
	
end;

function MF240:attachImplement(implement)
	
	local implementType = implement.object.attacherJoint.jointType;
	
	if implementType == Vehicle.JOINTTYPE_IMPLEMENT then
		setVisibility(self.barra, false);
	end;
	
	
end;

function MF240:detachImplement(implementIndex)

	setVisibility(self.barra, true);

end;

function MF240:draw()
end;

function MF240:setHydraulicDirection(index)

	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function MF240:onEnter()
end;

function MF240:onLeave()
end;

function MF240:delete()
end;

function MF240:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MF240:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;





