--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.25, 0.02, "      Numpad 0: Info Einschalten");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.25, 0.02, "      Numpad 0: Pomoc/Help");
		renderText(0.72, 0.86, 0.025, "Rakovica 135 Turbo");			
		renderText(0.72, 0.83, 0.02, "Taste Home: Rotaciona Lampa");
		renderText(0.72, 0.81, 0.02, "Taste Numpad1: Migavac Levo");
		renderText(0.72, 0.79, 0.02, "Taste Numpad2: Sva 4 Migavca");			
		renderText(0.72, 0.77, 0.02, "Taste Numpad3: Migavac Desno");
		renderText(0.72, 0.75, 0.02, "Taste Numpad5: Radna Svetla Napred");
		renderText(0.72, 0.73, 0.02, "Taste Numpad6: Radna Svetla Nazad");
		renderText(0.72, 0.71, 0.02, "Taste 6: Zadnji Tegovi");
		renderText(0.72, 0.69, 0.02, "Taste 8: Prednja Vuca 4x4");
		renderText(0.72, 0.65, 0.02, "By: Macko");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




