RM6014 = {};

function RM6014.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function RM6014:load(xmlFile)
  print("RM6014:load");
  --self.setIsTurnedOn = Utils.prependedFunction(self.setIsTurnedOn, Sprayer.setIsTurnedOn);
  self.lastIsTurnedOn = self.isTurnedOn;
  self.turnOnAnimCharSet = 0;
  local turnOnAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnOnAnimation#rootNode"));
  self.turnOnAnimCharSet = 0;
  if turnOnAnimRootNode ~= nil and turnOnAnimRootNode ~= 0 then
    self.turnOnAnimCharSet = getAnimCharacterSet(turnOnAnimRootNode);
    if self.turnOnAnimCharSet ~= 0 then
      local clip = getAnimClipIndex(self.turnOnAnimCharSet, getXMLString(xmlFile, "vehicle.turnOnAnimation#clip"));

      assignAnimTrackClip(self.turnOnAnimCharSet, 0, clip);
      setAnimTrackLoopState(self.turnOnAnimCharSet, 0, false);
      self.turnOnAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turnOnAnimation#speedScale"), 1);
      self.turnOnAnimDuration = getAnimClipDuration(self.turnOnAnimCharSet, clip);
    end;
  end;
end;

function RM6014:delete()
end;

function RM6014:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RM6014:keyEvent(unicode, sym, modifier, isDown)
end;

function RM6014:update(dt)
  if self.lastIsTurnedOn ~= self.isTurnedOn then
    self.lastIsTurnedOn = self.isTurnedOn;
    if self.turnOnAnimCharSet ~= 0 then
      if self.isTurnedOn then
        if getAnimTrackTime(self.turnOnAnimCharSet, 0) < 0.0 then
            setAnimTrackTime(self.turnOnAnimCharSet, 0, 0.0);
        end;
        setAnimTrackSpeedScale(self.turnOnAnimCharSet, 0, self.turnOnAnimSpeedScale);
      else
        if getAnimTrackTime(self.turnOnAnimCharSet, 0) > self.turnOnAnimDuration then
            setAnimTrackTime(self.turnOnAnimCharSet, 0, self.turnOnAnimDuration);
        end;
        setAnimTrackSpeedScale(self.turnOnAnimCharSet, 0, -self.turnOnAnimSpeedScale);
      end;
      enableAnimTrack(self.turnOnAnimCharSet, 0);
    end;
  end;
end;

function RM6014:draw()
end;

function RM6014:setIsTurnedOn(isTurnedOn, noEventSend)
  print("RM6014:setIsTurnedOn");
  if self.isClient and (isTurnedOn ~= self.isTurnedOn) then
    if self:getIsTurnedOnAllowed(isTurnedOn) then
      if self.turnOnAnimCharSet ~= 0 then
        if isTurnedOn then
          if getAnimTrackTime(self.turnOnAnimCharSet, 0) < 0.0 then
            setAnimTrackTime(self.turnOnAnimCharSet, 0, 0.0);
          end;
          setAnimTrackSpeedScale(self.turnOnAnimCharSet, 0, self.turnOnAnimSpeedScale);
        else
          if getAnimTrackTime(self.turnOnAnimCharSet, 0) > self.turnOnAnimDuration then
            setAnimTrackTime(self.turnOnAnimCharSet, 0, self.turnOnAnimDuration);
          end;
          setAnimTrackSpeedScale(self.turnOnAnimCharSet, 0, -self.turnOnAnimSpeedScale);
        end;
        enableAnimTrack(self.turnOnAnimCharSet, 0);
      end;
    end;
  end;
end;