-- HaweOverloadWagon
--
-- Old LS 08 Script
-- @author  Manuel L. (1.LS-Modschmiede) 
-- @date  25/09/08
--
-- New Script
-- @Author Tobias F. (John Deere 6930)
-- @Date 11/02/10
-- 
-- Edit
-- @Author Mr. F
-- @Date 12/05/10

HaweOverloadWagon = {};

HaweOverloadWagon.UNLOADING_CLOSED = 0;
HaweOverloadWagon.UNLOADING_OPENING = 1;
HaweOverloadWagon.UNLOADING_OPEN = 2;
HaweOverloadWagon.UNLOADING_CLOSING = 3;

function HaweOverloadWagon.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function HaweOverloadWagon:load(xmlFile)
	self.findTrailerRaycastCallback = HaweOverloadWagon.findTrailerRaycastCallback;
    self.toggleUnloadingState = SpecializationUtil.callSpecializationsFunction("toggleUnloadingState");
    self.onStartUnloading = SpecializationUtil.callSpecializationsFunction("onStartUnloading");
    self.onEndUnloading = SpecializationUtil.callSpecializationsFunction("onEndUnloading");

	self.unloadingDischargeEndTime = getXMLFloat(xmlFile, "vehicle.unloadingAnimation#endTime");
	
    local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
    if pipeSound ~= nil and pipeSound ~= "" then
        pipeSound = Utils.getFilename(pipeSound, self.baseDirectory); 
        self.pipeSound = createSample("pipeSound");
        loadSample(self.pipeSound, pipeSound, false);
        self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
        self.pipeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchScale"), 0);
        self.pipeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchMax"), 2.0);
	  self.pipeSoundEnabled = false;
    end;

    local fillSound = getXMLString(xmlFile, "vehicle.fillSound#file");
    if fillSound ~= nil and fillSound ~= "" then
        fillSound = Utils.getFilename(fillSound, self.baseDirectory); 
		self.fillSound = createSample("fillSound");
        loadSample(self.fillSound, fillSound, false);
        self.fillSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSound#pitchOffset"), 1);
        self.fillSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillSound#pitchMax"), 2.0);
        
    end;
	local unloadingAnimRootNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.unloadingAnimation#rootNode"));
    self.unloadingAnimCharSet = 0;
    if unloadingAnimRootNode ~= nil and unloadingAnimRootNode ~= 0 then
        self.unloadingAnimCharSet = getAnimCharacterSet(unloadingAnimRootNode);
        if self.unloadingAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.unloadingAnimCharSet, getXMLString(xmlFile, "vehicle.unloadingAnimation#clip"));
            assignAnimTrackClip(self.unloadingAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.unloadingAnimCharSet, 0, false);
            self.unloadingAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.unloadingAnimation#speedScale"), 1);
            self.unloadingAnimDuration = getAnimClipDuration(self.unloadingAnimCharSet, clip);
            if self.unloadingDischargeEndTime == nil then
                self.unloadingDischargeEndTime = self.unloadingAnimDuration*2.0;
            end;
        end;
    end;
	
	self.hudHawepath = Utils.getFilename("haweControl.png", self.baseDirectory);
	self.hudHawePoxX = 0.501;
    self.hudHawePoxY = 1-0.204;
    self.hudHaweWidth = 0.256;
    self.hudHaweHeight = 0.256;
	self.hudBasePoxX = 0.531;
    self.hudBasePoxY = 0.9069;
    self.hudHaweOverlay = Overlay:new("hudHaweControl", self.hudHawepath, self.hudHawePoxX, self.hudHawePoxY, self.hudHaweWidth, self.hudHaweHeight);
	
	self.unloadingState = HaweOverloadWagon.UNLOADING_CLOSED;
	self.activeUnloading = false;
	self.trailerPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerPosition#index"));
	self.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.unloadingSpeed"), 10);
	self.bcActive = false;
end;

function HaweOverloadWagon:delete()
end;

function HaweOverloadWagon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HaweOverloadWagon:keyEvent(unicode, sym, modifier, isDown)
end;

function HaweOverloadWagon:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.activeUnloading = not self.activeUnloading;
		end;		
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:toggleUnloadingState();
		end;	
		if InputBinding.hasEvent(InputBinding.HAWE_OLW_BC) then
			self.bcActive = not self.bcActive;
		end;		
    end;
	
		if self.unloadingState == HaweOverloadWagon.UNLOADING_OPENING then 
         	if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered then      
			   if self.pipeSound ~= nil and not self.pipeSoundEnabled then
                    setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
                    playSample(self.pipeSound, 0, 1, 0);
                    self.pipeSoundEnabled = true;
                end;
   		    end;
		end;

		if self.unloadingState == HaweOverloadWagon.UNLOADING_OPEN then 
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                    stopSample(self.pipeSound);
                    self.pipeSoundEnabled = false;
            end;
   		end;

		if self.unloadingState == HaweOverloadWagon.UNLOADING_CLOSING then 
            if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered then    
				if self.pipeSound ~= nil and not self.pipeSoundEnabled then
                    setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
                    playSample(self.pipeSound, 0, 1, 0);
                    self.pipeSoundEnabled = true;
                end;
   		    end;
		end;

		if self.unloadingState == HaweOverloadWagon.UNLOADING_CLOSED then 
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                    stopSample(self.pipeSound);
                    self.pipeSoundEnabled = false;
     	        if self.activeUnloading and self.pipeParticleActivated then
                    if not self.fillSoundEnabled and self.fillLevel > 0 and self.fillSound ~= nil then
                        playSample(self.fillSound, 0, self.fillSoundVolume, 0);
                        self.fillSoundEnabled = true;   
                    end;
                else
                    if self.fillSoundEnabled then
                        stopSample(self.fillSound);
                        self.fillSoundEnabled = false;   
                    end;
                end;         
			end;
   		end;




	if self.unloadingState == HaweOverloadWagon.UNLOADING_OPENING or self.unloadingState == HaweOverloadWagon.UNLOADING_OPEN then
        if self.unloadingState == HaweOverloadWagon.UNLOADING_OPENING then
            if getAnimTrackTime(self.unloadingAnimCharSet, 0) > self.unloadingAnimDuration then
                self.unloadingState = HaweOverloadWagon.UNLOADING_OPEN;
            end;
        end;
    elseif self.unloadingState == HaweOverloadWagon.UNLOADING_CLOSING then
        if getAnimTrackTime(self.unloadingAnimCharSet, 0) < 0.0 then
            self.unloadingState = HaweOverloadWagon.UNLOADING_CLOSED;
        end;
    end;

	if self:getIsActive() then	
		self.trailerFound = 0;
		
		local x,y,z = getWorldTranslation(self.trailerPosition);
		raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
		
		if self.attacherVehicle ~= nil then
			if self.trailerFound ~= 0 and self.attacherVehicle.isAutoActivated and self.unloadingState == 0 then
			    self:toggleUnloadingState();			
			end;
			if self.trailerFound ~= 0 and self.attacherVehicle.isAutoActivated then
				self.activeUnloading = true
			end;
			if self.trailerFound == 0 and self.attacherVehicle.isAutoActivated and self.unloadingState ~= 0 then
				self:onEndUnloading();
			end;
			if self.attacherVehicle.isAutoActivated and self.fillLevel == self.capacity and self.unloadingState == 0 then
			    self:toggleUnloadingState();	
			end;
		end
		
		self.currentTipTrigger = nil;			
		self.lastUnloadingTrailer = nil;
		self.pipeParticleActivated = false;
		
		if self.activeUnloading then
			if self.unloadingState == HaweOverloadWagon.UNLOADING_OPEN and self.fillLevel > 0 then
				self.pipeParticleActivated = true;


				local trailer = g_currentMission.objectToTrailer[self.trailerFound];
				self.lastUnloadingTrailer = trailer;
				if self.trailerFound == 0 or trailer == nil or not trailer:allowFillType(self.currentFillType, true) or not trailer.allowFillFromAir then
					self.pipeParticleActivated = false;
					self.activeUnloading = false;
			        if self.fillSoundEnabled then
				        stopSample(self.fillSound);
				        self.fillSoundEnabled = false;
                    end;						
				else
					local deltaLevel = self.unloadingSpeed*dt/10.0;
					deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);

					self.fillLevel = self.fillLevel-deltaLevel;
					if self.fillLevel <= 0.0 then
						deltaLevel = deltaLevel+self.fillLevel;
						self.fillLevel = 0.0;
						self.pipeParticleActivated = false;
						self.activeUnloading = false;
					end;
					if deltaLevel == 0 then
						self.pipeParticleActivated = false;
						self.activeUnloading = false;
						if self.fillSoundEnabled then
				            stopSample(self.fillSound);
				            self.fillSoundEnabled = false;
                        end;	
					end;
					self:setFillLevel(self.fillLevel, self.currentFillType);
					trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
				end;
			end;
		end;		
		Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.pipeParticleActivated);
		if self.pipeParticleActivated then
			if not self.fillSoundEnabled and self.fillLevel > 0 and self.fillSound ~= nil then
				if self.attacherVehicle ~= nil and self.attacherVehicle.isEntered then
				    playSample(self.fillSound, 0, self.fillSoundVolume, 0);
				    self.fillSoundEnabled = true;
				end;
			end;
		else
			if self.fillSoundEnabled and self.fillLevel == 0 then
				stopSample(self.fillSound);
				self.fillSoundEnabled = false;   
			end;
		end;
	end;
end;

function HaweOverloadWagon:draw()
	if self.unloadingState == HaweOverloadWagon.UNLOADING_OPEN or self.unloadingState == HaweOverloadWagon.UNLOADING_OPENING then
		g_currentMission:addHelpButtonText(g_i18n:getText("HAWE_OLW_PIPE_CLOSE"), InputBinding.IMPLEMENT_EXTRA);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("HAWE_OLW_PIPE_OPEN"), InputBinding.IMPLEMENT_EXTRA);
	end;
	
	if self.unloadingState == HaweOverloadWagon.UNLOADING_OPEN and self.trailerFound ~= 0  then
		if self.activeUnloading and self.pipeParticleActivated then
			g_currentMission:addHelpButtonText(g_i18n:getText("HAWE_OLW_STOP_FILL"), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("HAWE_OLW_START_FILL"), InputBinding.IMPLEMENT_EXTRA2);
		end;
	end;

	if self.bcActive then	
		g_currentMission:addHelpButtonText(g_i18n:getText("HAWE_OLW_BC_OFF"), InputBinding.HAWE_OLW_BC);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("HAWE_OLW_BC_ON"), InputBinding.HAWE_OLW_BC);
	end;

	if self.bcActive and self.hudHaweOverlay ~= nil then
		self.hudHaweOverlay:render();
		setTextBold(true);
		setTextColor(0.8, 0.2, 0.2, 1.0);
		local text = "";
		local massPerLiter = 730/1000; -- 730 kg per 1000 liter wheat (wheat-density)
		local mass = self.fillLevel*massPerLiter;
		local fillLevelString = "asd";
		if mass >= 0 and mass < 10 then
			fillLevelString = "0000" .. string.format("%d", mass);
		elseif mass >= 10 and mass < 100 then
			fillLevelString = "000" .. string.format("%d", mass);
		elseif mass >= 100 and mass < 1000 then
			fillLevelString = "00" .. string.format("%d", mass);
		elseif mass >= 1000 and mass < 10000 then
			fillLevelString = "0" .. string.format("%d", mass);
		elseif mass >= 10000 and mass < 50000 then
			fillLevelString = string.format("%d", mass);
		else
			fillLevelString = "ERROR";
		end;
		renderText(self.hudBasePoxX, self.hudBasePoxY, 0.070, fillLevelString);
		renderText(self.hudBasePoxX+0.145, self.hudBasePoxY+0.007, 0.06, "kg");
	end;
end;

function HaweOverloadWagon:findTrailerRaycastCallback(transformId, x, y, z, distance)
    if getUserAttribute(transformId, "vehicleType") == 2 and transformId ~= self.rootNode then
        self.trailerFound = transformId;
    end;
    return false;
end;

function HaweOverloadWagon:toggleUnloadingState()
    if self.unloadingState == 0 then
        self:onStartUnloading();
    else
        self:onEndUnloading();
    end;
end;

function HaweOverloadWagon:onStartUnloading()

    if self.unloadingAnimCharSet ~= 0 then
        if getAnimTrackTime(self.unloadingAnimCharSet, 0) < 0.0 then
            setAnimTrackTime(self.unloadingAnimCharSet, 0, 0.0);
        end;
        setAnimTrackSpeedScale(self.unloadingAnimCharSet, 0, self.unloadingAnimSpeedScale);
        enableAnimTrack(self.unloadingAnimCharSet, 0);
    end;
    self.unloadingState = HaweOverloadWagon.UNLOADING_OPENING;
end;

function HaweOverloadWagon:onEndUnloading()
    if self.unloadingAnimCharSet ~= 0 then
        if getAnimTrackTime(self.unloadingAnimCharSet, 0) > self.unloadingAnimDuration then
            setAnimTrackTime(self.unloadingAnimCharSet, 0, self.unloadingAnimDuration);
        end;
        setAnimTrackSpeedScale(self.unloadingAnimCharSet, 0, -self.unloadingAnimSpeedScale);
        enableAnimTrack(self.unloadingAnimCharSet, 0);
    end;
    self.unloadingState = HaweOverloadWagon.UNLOADING_CLOSING;
	self.activeUnloading = false;
end;

function HaweOverloadWagon:toggleTipState()
end;