
chiefbowser = {};

function chiefbowser.prerequisitesPresent(specializations)
    return true;
end;

function chiefbowser:load(xmlFile)

	self.trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trigger#index"));
	table.insert(g_currentMission, GasStation:new(self.trigger));

	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

	self.brakelightsActive = false;
    self.braking = false;
	
	local supportstandTranslationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.supportstandTranslation#index"));
	if supportstandTranslationNode ~= nil then
        self.supportstandTranslation = {};
        self.supportstandTranslation.node = supportstandTranslationNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportstandTranslation#minTrans"));
        self.supportstandTranslation.minRot = {};
        self.supportstandTranslation.minRot[1] = x;
        self.supportstandTranslation.minRot[2] = y;
        self.supportstandTranslation.minRot[3] = z;

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.supportstandTranslation#maxTrans"));
        self.supportstandTranslation.maxRot = {};
        self.supportstandTranslation.maxRot[1] = x;
        self.supportstandTranslation.maxRot[2] = y;
        self.supportstandTranslation.maxRot[3] = z;

        self.supportstandTranslation.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.supportstandTranslation#transTime"), 2)*1000;
    end;

	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
	if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;
	self.supportstandActive = true;
	self.rotationMax1Active = true;
end;

function chiefbowser:delete()



end;

function chiefbowser:mouseEvent(posX, posY, isDown, isUp, button)
end;

function chiefbowser:keyEvent(unicode, sym, modifier, isDown)

end;

function chiefbowser:update(dt)


		
		inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;

		
		if self.attacherVehicle ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
  
		end;	
	if self.supportstandTranslation ~= nil then
		local x, y, z = getTranslation(self.supportstandTranslation.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.supportstandTranslation.maxRot, self.supportstandTranslation.minRot, 3, self.supportstandTranslation.rotTime, dt, self.supportstandActive);
		setTranslation(self.supportstandTranslation.node, unpack(newTrans));
	end;
end;

function chiefbowser:draw()

end;

function chiefbowser:onDetach()

	self.supportstandActive = true;
	self.rotationMax1Active = true;
end;

function chiefbowser:onAttach(attacherVehicle)

	self.supportstandActive = false;
	self.rotationMax1Active = false;
end;

