--
-- Script for Stoll Greifschaufel
--
--
-- @author:		mx270 (wwww.modding-society.de)
-- @version:	v0.1
-- @date:		08/12/10
--
-- Copyright mx270, wwww.modding-society.de   
--

Stoll = {};

function Stoll.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Siloschaufel, specializations);
end;

function Stoll:load(xmlFile)
	self.implementFallOut = true;
		self.Greifer = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Greifer#index"));

self.capacitymin = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity#min"), 1000.0);
self.capacitymax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity#max"), 2000.0);

  self.capacity = self.capacitymax;
end;	
	

function Stoll:delete()
end;

function Stoll:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Stoll:keyEvent(unicode, sym, modifier, isDown)
end;

function Stoll:update(dt)

    if self.currentFillType == Fillable.FILLTYPE_SILO or self.currentFillType == Fillable.FILLTYPE_MANURE  then
	
	local X, Y, Z = getRotation(self.Greifer);
	if Utils.degToRad(-40) < X then
	     self.implementFallOut = false;
	else
		self.implementFallOut = true;
	end;
	
	end;
		    if self:getIsActive() then
	        if self.currentFillType == Fillable.FILLTYPE_SILO or self.currentFillType == Fillable.FILLTYPE_MANURE  then
          self.capacity = self.capacitymax;
		  elseif  self.currentFillType ~= Fillable.FILLTYPE_SILO or self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		  self.capacity = self.capacitymin;
         end;
end;
end;

function Stoll:updateTick(dt)
end;

function Stoll:draw()
end;

function Stoll:onAttach()
end;

function Stoll:onDetach()
	
end;

function Stoll:onLeave()
end;



