--
-- umschaltbare Bereifung
-- 
--
-- @author Schnulla-817
-- @date  21/06/09
--
-- 

Zinkenabdeckung = {};

function Zinkenabdeckung.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Zinkenabdeckung:load(xmlFile)

    self.numTwinTires = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twintires#count"), 0);
    self.twintires = {};
    for i=1, self.numTwinTires do
        local twintirenamei = string.format("vehicle.twintires.twintire%d", i);
        self.twintires[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, twintirenamei .. "#index"));
        setVisibility(self.twintires[i], false);
    end;

	self.twintiresActive = false;

end;

function Zinkenabdeckung:keyEvent(unicode, sym, modifier, isDown)

end;

function Zinkenabdeckung:update(dt)

    if self:getIsActiveForInput() then
	    if InputBinding.hasEvent(InputBinding.Zinkenabdeckung) then
		    self.twintiresActive = not self.twintiresActive;
        end;
	end;

	if self.isEntered then
		
    	    if self.twintiresActive then
			   	for i=1, self.numTwinTires do
		   			local twintire = self.twintires[i];
			   		setVisibility(twintire, self.twintiresActive);
				end;
		else 
		    if not self.twintiresActive then
				for i=1, self.numTwinTires do
					local twintire = self.twintires[i];
					setVisibility(twintire, self.twintiresActive, false);
				end;
		 	end;
		end;

	end;
end;



function Zinkenabdeckung:draw()
	if self.isMotorStarted then
		g_currentMission:addExtraPrintText(g_i18n:getText("Zinkenabdeckung_2"),InputBinding.Zinkenabdeckung);
	else
		g_currentMission:addExtraPrintText(g_i18n:getText("Zinkenabdeckung_1"),InputBinding.Zinkenabdeckung);
	end;
end;

function Zinkenabdeckung:onEnter()
end;

function Zinkenabdeckung:onLeave()
end;

function Zinkenabdeckung:delete()
end;


function Zinkenabdeckung:mouseEvent(posX, posY, isDown, isUp, button)
end;


