--
-- PoettingerSynkro5000K
-- Specialization for PoettingerSynkro5000K
--
-- @author  	fruktor 
-- @version 	v0.1
-- @date  		22/02/11
-- @history:	v0.1 - Initial version
--

 
PoettingerSynkro5000K = {};

function PoettingerSynkro5000K.prerequisitesPresent(specializations)
	return true;
end;

function PoettingerSynkro5000K:load(xmlFile)

	--
	self.rotatingParts = {};
	i=0;
	while true do 
		local node = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.rotatingParts.part(%d)#index",i)) );
		if node == nil then 
			break; 
		end;
		local radius = getXMLFloat(xmlFile, string.format("vehicle.rotatingParts.part(%d)#radius", i ) );
		local axis = getXMLInt(xmlFile, string.format("vehicle.rotatingParts.part(%d)#axis", i ) );
		local dir = getXMLFloat(xmlFile, string.format("vehicle.rotatingParts.part(%d)#dir", i ) );
		local entry = {};
		entry.node = node;
		entry.radius = radius;
		entry.rotationSpeedScale = 1.0 / radius;
		entry.axis = axis;		
		entry.dir = dir;	
		table.insert(self.rotatingParts, entry);
		i=i+1;
	end;

	--
	local cylinderedHydraulicSound = getXMLString(xmlFile, "vehicle.cylinderedHydraulicSound#file");
	if cylinderedHydraulicSound ~= nil and cylinderedHydraulicSound ~= "" then
		cylinderedHydraulicSound = Utils.getFilename(cylinderedHydraulicSound, self.baseDirectory);
		self.cylinderedHydraulicSound = createSample("cylinderedHydraulicSound");
		self.cylinderedHydraulicSoundEnabled = false;
		loadSample(self.cylinderedHydraulicSound, cylinderedHydraulicSound, false);
		self.cylinderedHydraulicSoundPitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cylinderedHydraulicSound#pitchOffset"), 1);
		self.cylinderedHydraulicSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cylinderedHydraulicSound#volume"), 1);
		setSamplePitch(self.cylinderedHydraulicSound, self.cylinderedHydraulicSoundPitch);
	else
		self.cylinderedHydraulicSoundPitch = 1;
		self.cylinderedHydraulicSoundVolume = 1;
	end;	
	
end

function PoettingerSynkro5000K:delete()
	if self.cylinderedHydraulicSound ~= nil then
		delete(self.cylinderedHydraulicSound);
	end;
end;

function PoettingerSynkro5000K:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PoettingerSynkro5000K:keyEvent(unicode, sym, modifier, isDown)
end;

function PoettingerSynkro5000K:update(dt)

end;

function PoettingerSynkro5000K:updateTick(dt)

	if self:getIsActive() then
		--rotatingParts -------------------------------------------------------
		local x,y,z = getWorldTranslation(self.groundReferenceNode);
		local height = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
		if (height + self.groundReferenceThreshold) >= y  then
			if self.lastSpeedReal > 0.0001 then
				for i, part in pairs(self.rotatingParts) do
					local x,y,z = getRotation(part.node);
					if part.axis == 0 then
						x = x + self.movingDirection*(part.rotationSpeedScale * ((0.5*math.random()+0.5)*self.lastSpeedReal) * part.dir * dt);
					elseif part.axis == 1 then
						y = y + self.movingDirection*(part.rotationSpeedScale * ((0.5*math.random()+0.5)*self.lastSpeedReal) * part.dir * dt);
					elseif part.axis == 2 then
						z = z + self.movingDirection*(part.rotationSpeedScale * ((0.5*math.random()+0.5)*self.lastSpeedReal) * part.dir * dt);
					end;
					setRotation(part.node, x, y, z);
				end;
			end;
		end;
	end;
	
	if self.isClient and self:getIsActiveForSound() and self.foldMoveDirection ~= nil then
		 if math.abs(self.foldMoveDirection) > 0.1 and (self.foldAnimTime > 0 and self.foldAnimTime < 1) then
			if self.cylinderedHydraulicSoundEnabled == false then
				playSample(self.cylinderedHydraulicSound, 0, self.cylinderedHydraulicSoundVolume, 0);
				self.cylinderedHydraulicSoundEnabled = true;
			end;
		else
			if self.cylinderedHydraulicSoundEnabled == true then
				stopSample(self.cylinderedHydraulicSound);
				self.cylinderedHydraulicSoundEnabled = false;
			end;
		end;
	else
		if self.cylinderedHydraulicSoundEnabled == true then
			stopSample(self.cylinderedHydraulicSound);
			self.cylinderedHydraulicSoundEnabled = false;
		end;
	end;
		
end;

function PoettingerSynkro5000K:onAttach(attacherVehicle)

end;

function PoettingerSynkro5000K:onDetach()

end;

function PoettingerSynkro5000K:draw()

end;
