--
--
-- @inspired by: 	- forage wagon, by Heady [www.planet-ls.de]
--					- forage wagon, by GIANTS 
--				
-- @version 		v1.1
-- @date  			26/12/10
-- @author  		fruktor
--
-- modified for Poettinger CombiLine 10010L: 
--		no rolls @ PU, hose on attach/detach, 
--

PoettingerJumbo7210 = {};




function PoettingerJumbo7210.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Drawbar, specializations);
end;

function PoettingerJumbo7210:load(xmlFile)

	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.setCollectPSActive = SpecializationUtil.callSpecializationsFunction("setCollectPSActive");
	
	self.setForcedSteering = SpecializationUtil.callSpecializationsFunction("setForcedSteering");
	self.isForcedSteering = true;
	
	--self.setFillLevel = Utils.overwrittenFunction( self.setFillLevel, PoettingerJumbo7210.setFillLevel );
	--self.setFillLevel = Utils.appendedFunction( self.setFillLevel, PoettingerJumbo7210.setFillLevel );

	self.maxSpeedLevel = 1;

	self.rightSteering = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#leftSteering"));
	self.leftSteering = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#rightSteering"));
	-- find correct moving parts
	for k,part in pairs(self.movingParts) do
		if self.rightSteering == part.referencePoint then
			self.rightSteering = part;
		elseif self.leftSteering == part.referencePoint then
			self.leftSteering = part;
		end;
	end;	
	self.rightFixPointBackup = self.rightSteering.referencePoint;
	self.leftFixPointBackup = self.leftSteering.referencePoint;
	
	
	self.leftGuideRoller = {};
	self.leftGuideRoller.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#leftGuideRoller"));
	local ax, ay, az = getWorldTranslation(self.leftGuideRoller.node);
	local bx, by, bz = getWorldTranslation(self.leftSteering.node);
	local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	self.leftGuideRoller.size = distance;
	local fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#fixPoint"));
	local cx,cy,cz = getWorldTranslation(fixPoint);
	self.leftGuideRoller.distance = Utils.vector3Length(cx-bx, cy-by, cz-bz);
	self.rightGuideRoller = {};
	self.rightGuideRoller.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTools#rightGuideRoller"));
	ax, ay, az = getWorldTranslation(self.rightGuideRoller.node);
	bx, by, bz = getWorldTranslation(self.rightSteering.node);
	self.leftGuideRoller.size = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.doTractorFixPointSearch = true;
	
	--
	self.rollsDis = {};
	self.rollsDis.object = {};
	self.rollsDis.speed = {};
	local i=1;
	while true do 
		local tmp = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.bergmann#rollDis%d",i)));
		if tmp == nil then
			break;
		end;
		self.rollsDis.object[i] = tmp;
		self.rollsDis.speed[i] = 0;
		i=i+1;
	end;
	
    local forageWgnSound = getXMLString(xmlFile, "vehicle.forageWgnSound#file");
    if forageWgnSound ~= nil and forageWgnSound ~= "" then
        forageWgnSound = Utils.getFilename(forageWgnSound, self.baseDirectory);
        self.forageWgnSound = createSample("forageWgnSound");
        self.forageWgnSoundEnabled = false;
        loadSample(self.forageWgnSound, forageWgnSound, false);
        self.forageWgnSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.forageWgnSound#pitchOffset"), 1);
        self.forageWgnSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.forageWgnSound#volume"), 1.0);
    end;

    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);

    self.isTurnedOn = false;	
	self.speedViolationMaxTime = 3000;
	self.speedViolationTimer = self.speedViolationMaxTime;
	
	local psPath = string.format("vehicle.bergmann.collectPS");
	local collectPS = {};
	local particleNode = Utils.loadParticleSystem(xmlFile, collectPS, psPath, self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
	self.collectPS = collectPS;
	self.activateCollectPS = false;

	local psDryPath = string.format("vehicle.bergmann.collectPSdry");
	local collectPSdry = {};
	local particleNode = Utils.loadParticleSystem(xmlFile, collectPSdry, psDryPath, self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
	self.collectPSdry = collectPSdry;
	
	self.hayBase = {};
	self.hayBase.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hayBase#index"));
	self.hayBase.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#unloadingSpeed"), 0.001);
	self.hayBase.loadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#loadingSpeed"), 0.0005);
	self.hayBase.speed = self.hayBase.loadingSpeed;
	self.hayBase.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hayBase#unloadingDirection"), 1);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
	
	
	--[[self.realLoading = {};
	self.realLoading.trailerEnd = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.realLoading#trailerEnd"));
	local x,y,z = getTranslation(self.realLoading.trailerEnd);
	self.realLoading.maxDistance = math.abs(z);
	self.realLoading.unloadingTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realLoading#unloadingTime"), 10)*1000;
	self.oldFillLevel = 0;
	self.allowDis = false;]]--
	
	self.lastFillType = Fillable.FILLTYPE_UNKNOWN;
end;

function PoettingerJumbo7210:delete()
    if self.forageWgnSound ~= nil then
        delete(self.forageWgnSound);
    end;
end;

function PoettingerJumbo7210:readStream(streamId, connection)
	self.isTurnedOn = streamReadBool(streamId);
	self.activateCollectPS = streamReadBool(streamId);
end;

function PoettingerJumbo7210:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isTurnedOn);
	streamWriteBool(streamId, self.activateCollectPS);
end;

function PoettingerJumbo7210:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PoettingerJumbo7210:keyEvent(unicode, sym, modifier, isDown)
end;

function PoettingerJumbo7210:update(dt)

    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:setIsTurnedOn(not self.isTurnedOn);
        end;
		
	end;
	
	if self:getIsActive() then		
		if self.doTractorFixPointSearch and self.leftFixPoint ~= nil and self.rightFixPoint ~= nil then
			self.rightSteering.referencePoint = self.rightFixPoint;
			self.leftSteering.referencePoint = self.leftFixPoint;			
			self.doTractorFixPointSearch  = false;
		end;
	end;	
	
	
	local steeringAxleAngle = 0;
	if self.attacherVehicle ~= nil and self.isForcedSteering == true then
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
		local dot = z;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x > 0 then
			angle = -angle;
		end;
		steeringAxleAngle = -angle*0.6;
	end;
	self.steeringAxleAngle = steeringAxleAngle;
	
	if self:getIsActive() then	
		if self.lastSteeringAxleAngle ~= steeringAxleAngle then
			self.lastSteeringAxleAngle = steeringAxleAngle;
			for k, part in pairs(self.movingParts) do
				part.isDirty = true;
			end;			
		end;
	end;
	
end;


function PoettingerJumbo7210:updateTick(dt)	
	self.lastdt = dt;
	
	-- ###
	if self:getIsActive() and self.isForcedSteering == true then
		local x,y,z = worldDirectionToLocal(self.rootNode, localDirectionToWorld(self.attacherVehicle.rootNode, 0, 0, 1));
		local dot = z;
		dot = dot / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x < 0 then
			angle = -angle;
		end;
		backAngle  = 24 * (angle / 50);
		setRotation(self.leftGuideRoller.node, backAngle, 0,0);
		setRotation(self.rightGuideRoller.node, -backAngle, 0,0);
	end;

	-- ###
	if self.fillLevel >= self.capacity and self.isTurnedOn then
		self:setIsTurnedOn(false);
	end;
	

	-- #### entladewalzen
	if	self.tipState == Trailer.TIPSTATE_OPEN then
		for i, j in pairs(self.rollsDis.object) do
			local rX, rY, rZ = getRotation(j);
			self.rollsDis.speed[i] = self.rollsDis.speed[i] + 0.005 + math.random()/200;
			self.rollsDis.speed[i] = math.min(self.rollsDis.speed[i], 0.4);
			if i==2 then
				rX = rX - self.rollsDis.speed[i];
			else
				rX = rX + self.rollsDis.speed[i];
			end;
			setRotation(j, rX, rY, rZ);
		end;
	end;
	if self.tipState == Trailer.TIPSTATE_CLOSING then
		for i, j in pairs(self.rollsDis.object) do
			local rX, rY, rZ = getRotation(j);
			self.rollsDis.speed[i] = self.rollsDis.speed[i] - 0.005 - math.random()/200;
			self.rollsDis.speed[i] = math.max(self.rollsDis.speed[i], 0.0);
			if i==2 then
				rX = rX + self.rollsDis.speed[i];
			else
				rX = rX - self.rollsDis.speed[i];
			end;
			setRotation(j, rX, rY, rZ);
		end;
	end;

	-- ### speed control
	self.wasToFast = false;
	if self.isTurnedOn and self.pickup.isDown then
		local speedLimit = 20;
		if self.maxSpeedLevel == 2 then
			speedLimit = 30;
		elseif self.maxSpeedLevel == 3 then
			speedLimit = 100;
		end;
		if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
			self.speedViolationTimer = self.speedViolationTimer - dt;
			if self.isServer then
				if self.speedViolationTimer < 0 then
					if self.attacherVehicle ~= nil then
						--self.attacherVehicle:detachImplementByObject(self);
						self.wasToFast = true;
					end;
				end;
		   end;
		else
		   self.speedViolationTimer = self.speedViolationMaxTime;
	   end;
	end;
	
	-- #### forage wagon  ...
	
    if self:getIsActive() then	
	
		local activateCollectPS = false;	
	
		if self.fillLevel >= self.capacity then
			self.isTurnedOn = false;
		end;
		
        if self.isTurnedOn and self.wasToFast == false then

            if self.isServer and self.pickup.isDown and self.capacity > self.fillLevel then
				local cuttingAreasSend = {};
				for k, cuttingArea in pairs(self.cuttingAreas) do
					if self:getIsAreaActive(cuttingArea) then
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

						table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
					end;
				end;
				if (table.getn(cuttingAreasSend) > 0) then				
					local area = 0;
					local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
					for fillType,v in pairs(self.fillTypes) do						
						if fillType ~= FruitUtil.FRUITTYPE_UNKNOWN then							
							if self.currentFillType == fillType or self.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then	
								fruitType = FruitUtil.fillTypeToFruitType[fillType];
								area = BergmannAreaEvent.runLocally(cuttingAreasSend, fruitType);

								if area > 0 then
									self.currentFillType = fillType;
								end;
							end;
						end;
					end;
				
					if area > 0 then
						local pixelToSqm = g_currentMission:getFruitPixelsToSqm(); -- 4096px are mapped to 2048m
						local literPerSqm = g_strawLitersPerSqm * 2;
						local sqm = area*pixelToSqm;

						local deltaLevel = sqm*literPerSqm * self.fillScale;
						if fruitType == FruitUtil.FRUITTYPE_WHEAT or fruitType == FruitUtil.FRUITTYPE_BARLEY then
							deltaLevel = deltaLevel/2;
						end;

						self:setFillLevel(self.fillLevel+deltaLevel, self.currentFillType);
						g_server:broadcastEvent(BergmannAreaEvent:new(cuttingAreasSend, fruitType));
						activateCollectPS = true;
					end;

					
				end;
            end;
			
            if self.isClient then
                if not self.forageWgnSoundEnabled and self:getIsActiveForSound() then
                    playSample(self.forageWgnSound, 0, self.forageWgnSoundVolume, 0);
                    setSamplePitch(self.forageWgnSound, self.forageWgnSoundPitchOffset);
                    self.forageWgnSoundEnabled = true;
                end;
            end;
        end;


		if self.isClient then
            if self.forageWgnSoundEnabled and not self.isTurnedOn then
                stopSample(self.forageWgnSound);
                self.forageWgnSoundEnabled = false;
            end;
        end;
		
		if self.isServer then
			if self.activateCollectPS ~= activateCollectPS then
				self:setCollectPSActive(activateCollectPS);
			end;
		end;			
		
    end;		
	
	--### 
	if self.isClient then
        --if (self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN) and self.fillLevel > 0 then
		if (self.tipState == Trailer.TIPSTATE_OPEN) and self.fillLevel > 0 then
            --Utils.setEmittingState(self.dischargeParticleSystems[self.lastFillType], true);
        else
            Utils.setEmittingState(self.dischargeParticleSystems[self.lastFillType], false);
        end;
    end;	

end;

function PoettingerJumbo7210:draw()	
    if self.isTurnedOn then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    end;

	if self.isTurnedOn then
		if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
			local buttonName = InputBinding.SPEED_LEVEL1;
			if self.maxSpeedLevel == 2 then
				buttonName = InputBinding.SPEED_LEVEL2;
			elseif self.maxSpeedLevel == 3 then
				buttonName = InputBinding.SPEED_LEVEL3;
			end;
			g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), tostring(self.maxSpeedLevel), InputBinding.getKeyNamesOfDigitalAction(buttonName)), 0.07+0.022, 0.019+0.029);
		end;
		
	end;

end;

function PoettingerJumbo7210:onAttach(attacherVehicle)
	self.doJointSearch = true;
	self.doJointSearchCylindered = true;
end;

function PoettingerJumbo7210:onDetach()
	self.vehicleJoint = nil;
	self.doJointSearch = false;
	self.doJointSearchCylindered = false;
	
	self.doTractorFixPointSearch = true;
	self.leftSteering.referencePoint = self.leftFixPointBackup;
	self.rightSteering.referencePoint = self.rightFixPointBackup;
	
	PoettingerJumbo7210.onDeactivate(self);
end;

function PoettingerJumbo7210:onLeave()
    if self.deactivateOnLeave then
        PoettingerJumbo7210.onDeactivate(self);
    else
        PoettingerJumbo7210.onDeactivateSounds(self);
    end;
end;

function PoettingerJumbo7210:onDeactivate()
    self.isTurnedOn = false;
	self:setCollectPSActive(false);
    PoettingerJumbo7210.onDeactivateSounds(self);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
end;


function PoettingerJumbo7210:onDeactivateSounds()
    if self.forageWgnSoundEnabled then
        stopSample(self.forageWgnSound);
        self.forageWgnSoundEnabled = false;
    end;
end;

function PoettingerJumbo7210:onStartTip(currentTipTrigger, noEventSend)
	setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.unloadingSpeed,0,0,0,false);
	self.allowDis = false;
end;

function PoettingerJumbo7210:onEndTip(noEventSend)
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
	self.allowDis = false;
end;

function PoettingerJumbo7210:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
	self.isTurnedOn = turnedOn;
	if turnedOn then			
		setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.loadingSpeed,0,0,0,false);
	else
		setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
	end;	
end;

function PoettingerJumbo7210:setCollectPSActive(activatePS, noEventSend)
	SetPSActiveEvent.sendEvent(self, activatePS, false);
	self.activateCollectPS = activatePS;
	
	if self.activateCollectPS == true then
		if self.currentFillType == Fillable.FILLTYPE_GRASS then
			Utils.setEmittingState(self.collectPS, true);
			Utils.setEmittingState(self.collectPSdry, false);
		elseif self.currentFillType == Fillable.FILLTYPE_DRYGRASS then
			Utils.setEmittingState(self.collectPS, false);
			Utils.setEmittingState(self.collectPSdry, true);
		else
			Utils.setEmittingState(self.collectPS, false);
			Utils.setEmittingState(self.collectPSdry, false);			
		end;
	else
		Utils.setEmittingState(self.collectPS, false);
		Utils.setEmittingState(self.collectPSdry, false);	
	end;	
			
end;

function PoettingerJumbo7210:setForcedSteering(state, noEventSend)
	SetForcedSteeringEvent.sendEvent(self, state, noEventSend);
	
	self.isForcedSteering = state;
end;

