--
-- InteractiveControlPanel
-- Specialization for InteractiveControlPanel
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - Converted to LS2011
--

InteractiveControlPanel = {};

function InteractiveControlPanel.prerequisitesPresent(specializations)
	--return SpecializationUtil.hasSpecialization(BogballeM2W_Base, specializations);
	return true;
end;

function InteractiveControlPanel:load(xmlFile)
	
	source(Utils.getFilename("InteractiveComponentInterface.lua", self.baseDirectory));
	
	self.detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#detachPosition"));
	self.controlPanel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#index"));
	self.mark = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanel#highlight"));
	self.highlight = getChildAt(self.mark,0);

	local overlays = {};
	local buttons = {};	
		
	local bgX = 0.73;
	local bgY = 0.35;
	
	local bgH = 0.25;
	local bgV = 0.5;
	
	local elSx = 0.742;
	local elSy = 0.62;	
	
	local elH  = 0.055;
	local elHd = 0.056;	-- delta = space between
	local elV  = 0.055;
	local elVd = 0.056;
	
    self.panelSound = createSample("panelSample");
    loadSample(self.panelSound, Utils.getFilename("peeptone.wav", self.baseDirectory), false);		

	-- add main background overlay	
	table.insert(overlays, Overlay:new("controlPanelBG", 		Utils.getFilename("controlPanel/cp_bgMain.png", 			self.baseDirectory), bgX, 		bgY,		bgH,		bgV));
	--table.insert(overlays, Overlay:new("controlPanelDisplay", Utils.getFilename("controlPanel/controlPanel_display_diffuse.dds", self.baseDirectory), 			bgX-0.0007, bgY+0.2171,0.1952,0.25667));
	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_turnOn.png", 		self.baseDirectory), 	elSx, 			elSy, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_coverClose.png", 	self.baseDirectory), 	elSx+elHd, 		elSy, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_drawbarDown.png", 	self.baseDirectory), 	elSx+2*elHd, 	elSy, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_pickupUp.png", 		self.baseDirectory), 	elSx+3*elHd, 	elSy, elH, 		elV));	
	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_floorBack.png", 		self.baseDirectory), 	elSx, 			elSy - elVd, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_coverOpen.png", 		self.baseDirectory), 	elSx+elHd, 		elSy - elVd, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_drawbarUp.png", 		self.baseDirectory), 	elSx+2*elHd,	elSy - elVd, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_pickupDown.png", 	self.baseDirectory), 	elSx+3*elHd, 	elSy - elVd, elH, 		elV));	
	
	local voffset = elSy - 2*elVd - 0.02;
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_turnOff.png", 		self.baseDirectory), 	elSx, 			voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_disRolls.png", 		self.baseDirectory), 	elSx+elHd, 		voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_floorFront.png", 	self.baseDirectory), 	elSx+2*elHd, 	voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_disOpen.png",	 	self.baseDirectory), 	elSx+3*elHd, 	voffset, elH, 		elV));	

	voffset = elSy - 3*elVd - 0.02;
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_floorSpeed.png", 	self.baseDirectory), 	elSx, 			voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_disExtra.png", 		self.baseDirectory), 	elSx+elHd, 		voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_steering.png", 		self.baseDirectory), 	elSx+2*elHd, 	voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_disClose.png",	 	self.baseDirectory), 	elSx+3*elHd, 	voffset, elH, 		elV));	
	
	voffset = elSy - 4*elVd - 0.02;
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_stop.png", 		self.baseDirectory), 	elSx, 			voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_minus.png", 		self.baseDirectory), 	elSx+elHd, 		voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_plus.png", 		self.baseDirectory), 	elSx+2*elHd, 	voffset, elH, 		elV));	
	table.insert(buttons, Overlay:new("controlButtonStart",    	Utils.getFilename("ControlPanel/cp_onOff.png",	 	self.baseDirectory), 	elSx+3*elHd, 	voffset, elH, 		elV));	

	-- create new control panel instance
	self.interactiveControlPanel = BogballeControlPanel:new(self.controlPanel, self.highlight, self.mark, "Control Panel", 0.1, overlays, buttons, self.panelSound, self);
	self.attacherVehicleCopy = nil;
	
end;

function InteractiveControlPanel:delete()
end;

function InteractiveControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveControlPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveControlPanel:update(dt)	
end;

function InteractiveControlPanel:draw()
end;

function InteractiveControlPanel:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
	self.interactiveControlPanel:setVisible(Utils.getNoNil(attacherVehicle.isMouseActive,false));
	if attacherVehicle.addControlPanel ~= nil then
		local wasSuccessful = attacherVehicle:addControlPanel(self);
	end;	
end;

function InteractiveControlPanel:onDetach()
	if self.attacherVehicleCopy.removeControlPanel ~= nil then
		local wasSuccessful = self.attacherVehicleCopy:removeControlPanel(self);
		self.interactiveControlPanel.isOpen = false;
	end;

	self.attacherVehicleCopy = nil;
end;


--
-- BogballeControlPanel Class
-- Specialization for BogballeControlPanel
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

BogballeControlPanel = {};
function BogballeControlPanel:new(node, highlight, mark, name, size, overlays, buttons, sound, controlledAttachable)

	local BogballeControlPanel_mt = Class(BogballeControlPanel, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, nil, nil, BogballeControlPanel_mt);
	
	instance.onMessage = g_i18n:getText("ic_component_open");
	instance.offMessage = g_i18n:getText("ic_component_close");	
	instance.controlledAttachable = controlledAttachable;
	instance.sound = sound;
	instance.overlays = overlays;
	if instance.overlays == nil then
		instance.overlays = {};
	end;
	
	self.currentDisplay = 1;
	
	-- add buttons
	local actionEvent = instance.onPanelAction;
	for k,v in pairs(buttons) do		
		table.insert(instance.overlays, OverlayNumberedButton:new(v, k, actionEvent, instance, {1, 1, 1, 0.8}));		
	end;	
	instance.mainBackground = instance.overlays[1];
	
	instance.bgX = instance.mainBackground.x;
	instance.bgY = instance.mainBackground.y;
	
	self.mouseIsEnabled = false;
	self.buttonsCopy = buttons;
	
	return instance;	
end;


function BogballeControlPanel:delete()
	for k,v in pairs(self.overlays) do
		v:delete();
	end;
	InteractiveComponentInterface.delete(self);
end;

function BogballeControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
	if self.isOpen then
		local machine = self.controlledAttachable;
		for k,v in pairs(self.overlays) do
			v:mouseEvent(posX, posY, isDown, isUp, button);
		end;
	end;
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);

	if isDown == true then 
		self.mouseIsEnabled = true;
	end;
	if self.mouseIsEnabled then
		self.mousePosX = posX;
		self.mousePosY = posY;
		if isUp then
			self.mouseIsEnabled = false;
		end;
	end;
end;

function BogballeControlPanel:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function BogballeControlPanel:update(dt)
	--[[ if self.hydraulic ~= nil then
		local x,y,z = getRotation(self.node);
		local a,b,c = unpack(self.lastRotation);
		if math.abs(math.abs(x) - a) > 0.001 or math.abs(math.abs(y) - b) > 0.001 or math.abs(math.abs(z) - c) > 0.001 then
			for k,hydraulic in pairs(self.hydraulic) do	
				local ax, ay, az = getWorldTranslation(hydraulic.node);
				local bx, by, bz = getWorldTranslation(hydraulic.InteractiveControlPanelFixPoint);
				local dx, dy, dz = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);												
				setDirection(hydraulic.node, dx, dy, dz, 0, 1, 1);
				if hydraulic.punch ~= nil then
					local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
					setTranslation(hydraulic.punch, 0, 0, (distance-hydraulic.punchDistance));
				end;					
			end;
			self.lastRotation = {math.abs(x), math.abs(y), math.abs(z)};
		end;
	end; ]]--
	InteractiveComponentInterface.update(self, dt);
	
	-- continous controlling
	if self.mouseIsEnabled then
		local machine = self.controlledAttachable;		
		
		-- chaff cover
		if (self.mousePosX > self.buttonsCopy[2].x and self.mousePosX < self.buttonsCopy[2].x + self.buttonsCopy[2].width) and 
			(self.mousePosY > self.buttonsCopy[2].y and self.mousePosY < self.buttonsCopy[2].y + self.buttonsCopy[2].height) then
			local targetTime = Utils.getMovedLimitedValues({machine.chaffCover.curTime}, {0}, {machine.chaffCover.duration}, 1, machine.chaffCover.duration, dt, false);
			machine:updateTargetTimeCover(targetTime[1]);	
		elseif (self.mousePosX > self.buttonsCopy[6].x and self.mousePosX < self.buttonsCopy[6].x + self.buttonsCopy[6].width) and 
			(self.mousePosY > self.buttonsCopy[6].y and self.mousePosY < self.buttonsCopy[6].y + self.buttonsCopy[6].height) then
			local targetTime = Utils.getMovedLimitedValues({machine.chaffCover.curTime}, {0}, {machine.chaffCover.duration}, 1, machine.chaffCover.duration, dt, true);
			machine:updateTargetTimeCover(targetTime[1]);		
			
		-- drawbar
		elseif (self.mousePosX > self.buttonsCopy[3].x and self.mousePosX < self.buttonsCopy[3].x + self.buttonsCopy[3].width) and 
			(self.mousePosY > self.buttonsCopy[3].y and self.mousePosY < self.buttonsCopy[3].y + self.buttonsCopy[3].height) then
			local targetTime = Utils.getMovedLimitedValues({machine.drawbar.curTime}, {0}, {machine.drawbar.duration}, 1, machine.drawbar.duration, dt, true);
			machine:updateTargetTime(targetTime[1]);		
		elseif (self.mousePosX > self.buttonsCopy[7].x and self.mousePosX < self.buttonsCopy[7].x + self.buttonsCopy[7].width) and 
			(self.mousePosY > self.buttonsCopy[7].y and self.mousePosY < self.buttonsCopy[7].y + self.buttonsCopy[7].height) then
			local targetTime = Utils.getMovedLimitedValues({machine.drawbar.curTime}, {0}, {machine.drawbar.duration}, 1, machine.drawbar.duration, dt, false);
			machine:updateTargetTime(targetTime[1]);		
		end;
		
	end;
end;

function BogballeControlPanel:draw()
	local machine = self.controlledAttachable;
	if machine == nil then
		self.currentDisplay = 0;
	end;
	if self.isOpen then
		for k,v in pairs(self.overlays) do
			if k == 2 then
				if self.currentDisplay ~= 0 then
					v:render();
				end;
			else
				v:render();
			end;
		end;
		
		setTextColor(0.2078, 0.22, 0.1921, 1);
		setTextBold(false);
		renderText(0.77, 0.70, 0.017, string.format("%s: %5.2f", g_i18n:getText("COMBILINE_FILLLEVEL"), 100*machine.fillLevel/machine.capacity));
		
		--[[
		setTextColor(0.2078, 0.22, 0.1921, 1);
		setTextBold(false);
		if self.currentDisplay ~= 0 then
			
			if self.currentDisplay ~= 0 then
				local offset = 0;
				if machine.fillLevel < 1000 then
					offset = 1;
					if machine.fillLevel < 100 then
						offset = 2;
						if machine.fillLevel < 10 then
							offset = 3;
						end;
					end;
				end;
				renderText(self.bgX+0.035, self.bgY+0.452, 0.015, g_i18n:getText("bogballe_fillLevel"));
				renderText(self.bgX+0.035 + offset*0.0115, self.bgY+0.423, 0.03, string.format("%d", machine.fillLevel));
				renderText(self.bgX+0.083, self.bgY+0.4272, 0.015, "Kg");
				
				renderText(self.bgX+0.11,  self.bgY+0.4272-0.055, 0.015, string.format("(Step: %s)", machine.currentStep)); 
				renderText(self.bgX+0.035, self.bgY+0.452 - 0.055, 0.015, g_i18n:getText("bogballe_maxCapacity"));
				renderText(self.bgX+0.035, self.bgY+0.423 - 0.055, 0.03,  string.format("%d", machine.capacity));
				renderText(self.bgX+0.083, self.bgY+0.4272- 0.055, 0.015, "Kg");
 
				
 				renderText(self.bgX+0.0405, self.bgY+0.423 - 0.143, 0.03,  string.format("%d", machine.settings.literPerHa.current));
				renderText(self.bgX+0.077, self.bgY+0.4272- 0.143, 0.015, "Kg/Ha");
				renderText(self.bgX+0.12, self.bgY+0.4255 - 0.143, 0.022,  string.format("%d", machine.currentAreaWidth));
				renderText(self.bgX+0.14, self.bgY+0.4272- 0.143, 0.015, "m");
				
				
				local lastSpeed =  math.floor((Utils.getNoNil(machine.attacherVehicle.lastSpeed, 0) * 3600)*10)/10;
				local speed = tostring(lastSpeed);
				local maxLen = 1;
				if lastSpeed > 10 then
					maxLen = 2;
				end;
				if string.len(speed) <= maxLen then
					speed = speed .. ".0";
				end;
				offset = 0;
				if string.len(speed) < 4 then
					offset = 1;
				end;
				renderText(self.bgX+0.035 + offset*0.0115, self.bgY+0.423 - 0.179, 0.03,  speed);
				renderText(self.bgX+0.077,  			   self.bgY+0.4272- 0.179, 0.0145, "Km/h");
				local lastRPM = Utils.getNoNil(machine.attacherVehicle.motor.lastMotorRpm, 0);
				offset = 0;
				if lastRPM < 1000 then
					offset = 1;
					if lastRPM < 100 then
						offset = 2;
						if lastRPM < 10 then
							offset = 3;
						end;
					end;
				end;
				renderText(self.bgX+0.101 + offset*0.00843, self.bgY+0.4255 - 0.179, 0.022,  string.format("%d", lastRPM));
				renderText(self.bgX+0.137,  				self.bgY+0.4272 - 0.179, 0.015, "rpm");				
			end;
			
			setTextColor(0.5137, 0.52157, 0.5059, 1);
			if self.currentDisplay == 1 then -- sprayWidth
				renderText(self.bgX+0.035, self.bgY+0.452 - 0.108, 0.015, g_i18n:getText("bogballe_sprayWidth"));
				renderText(self.bgX+0.052,  self.bgY+0.424 - 0.11, 0.03,  string.format("%d", machine.currentAreaWidth));
				renderText(self.bgX+0.077,  self.bgY+0.4272 - 0.1085, 0.015, "m");
			elseif self.currentDisplay == 2 then -- capacity
				renderText(self.bgX+0.035, self.bgY+0.452 - 0.108, 0.015, g_i18n:getText("bogballe_maxCapacity"));
				renderText(self.bgX+0.035,  self.bgY+0.424 - 0.11, 0.03,  string.format("%d", machine.capacity));
				renderText(self.bgX+0.083,  self.bgY+0.4272 - 0.1085, 0.015, "Kg");			
			elseif self.currentDisplay == 3 then -- literPerHa
				renderText(self.bgX+0.035, self.bgY+0.452 - 0.108, 0.015, g_i18n:getText("bogballe_literPerHa"));
				renderText(self.bgX+0.0405,  self.bgY+0.424 - 0.11, 0.03,  string.format("%d", machine.settings.literPerHa.current));
				renderText(self.bgX+0.077,  self.bgY+0.4272 - 0.1085, 0.015, "Kg/Ha");	
			end;
		else
			setTextBold(true);
			renderText(self.bgX+0.035, self.bgY+0.45, 0.016, "Interactive Control" );
			setTextBold(false);
			renderText(self.bgX+0.05, self.bgY+0.436, 0.015, "by SFM-Modding" );
			renderText(self.bgX+0.035, self.bgY+0.404, 0.015, "Idea: " );
			renderText(self.bgX+0.0945, self.bgY+0.404, 0.015, "steyr1" );
			renderText(self.bgX+0.035, self.bgY+0.388, 0.015, "Realization: Face" );
			renderText(self.bgX+0.035, self.bgY+0.372, 0.015, "Bugfixing:" );
			renderText(self.bgX+0.0945, self.bgY+0.372, 0.015, "MadMax" );
			renderText(self.bgX+0.0945, self.bgY+0.356, 0.015, "Morpheus" );
			renderText(self.bgX+0.035, self.bgY+0.335, 0.015, "Content:" );
			renderText(self.bgX+0.04, self.bgY+0.319, 0.015, "IC is a new control-" ); 
			renderText(self.bgX+0.04, self.bgY+0.303, 0.015, "model for LS. Now" );
			renderText(self.bgX+0.04, self.bgY+0.287, 0.015, "you can control your" );
			renderText(self.bgX+0.04, self.bgY+0.271, 0.015, "attached implements" );
			renderText(self.bgX+0.04, self.bgY+0.255, 0.015, "with this control panel!" );
			renderText(self.bgX+0.04, self.bgY+0.235, 0.015, "Have fun !" );
		end;
		]]--
	end;
	InteractiveComponentInterface.draw(self);
end;

function BogballeControlPanel:doAction(dt)
	InteractiveComponentInterface.doAction(self,dt);
	local attacherVehicle = self.controlledAttachable.attacherVehicleCopy;
	if attacherVehicle ~= nil then
		if attacherVehicle.setPanelOverlay ~= nil then
			if self.isOpen then
				attacherVehicle:setPanelOverlay(self);
			else
				attacherVehicle:setPanelOverlay(nil);
			end;
		end;
	end;
end;

function BogballeControlPanel:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function BogballeControlPanel:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function BogballeControlPanel:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function BogballeControlPanel:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;

function BogballeControlPanel:onPanelAction(id)
	playSample(self.sound, 1, 0.1,0);
	local machine = self.controlledAttachable;	
	if id == 1 then
		machine:setIsTurnedOn(true);
	elseif id == 2 then
	elseif id == 3 then
	elseif id == 4 then
		machine:setIsPickupDown(false);
	elseif id == 5 then
	elseif id == 6 then
	elseif id == 7 then
	elseif id == 8 then
		machine:setIsPickupDown(true);
	elseif id == 9 then
		machine:setIsTurnedOn(false);
	elseif id == 10 then
	elseif id == 11 then
	elseif id == 12 then
	elseif id == 13 then
	elseif id == 14 then
	elseif id == 15 then
		machine:setForcedSteering(not machine.isForcedSteering);
	elseif id == 16 then
	end;	
	--[[
	elseif id == 2 then
		if self.currentDisplay == 1 then
			machine:changeSprayWidth(true); -- increase sprayWidth
		elseif self.currentDisplay == 2 then	
			machine:changeCapacity(true);	-- increase capacity
		elseif self.currentDisplay == 3 then
			machine:changeLiterPerHa(true); -- increase literPerHa
		end;		
	elseif id == 3 then
		if self.currentDisplay == 1 then
			machine:changeSprayWidth(false); -- decrease sprayWidth
		elseif self.currentDisplay == 2 then	
			machine:changeCapacity(false);	-- decrease capacity
		elseif self.currentDisplay == 3 then
			machine:changeLiterPerHa(false); -- decrease literPerHa
		end;		
	elseif id == 4 then
		machine:setIsTurnedOn(not machine.isTurnedOn);
	elseif id == 5 then
		self.currentDisplay = 1;
	elseif id == 6 then
		self.currentDisplay = 2;
	elseif id == 7 then
		self.currentDisplay = 3;
	elseif id == 8 then
		self.currentDisplay = 0;
	end; ]]--
end;