-- Register fruits
function RegisterFruits()
	local fruitList = {};

    table.insert(fruitList, {type="none"    ,fruitName="manure"         ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=0.80 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="liquidManure"   ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=0.40 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );

    --
    print(string.format("Registering %d extra fruits...", table.getn(fruitList)));
    for i=1, table.getn(fruitList) do
        local filename = "map01/".. fruitList[i].fruitName .."Hud.png";
        local hudFile = Utils.getFilename(filename, g_currentModDirectory);
        FruitUtil.registerFruitType(
             fruitList[i].fruitName                 -- string fruitName
            ,fruitList[i].needsSeeding              -- bool needsSeeding
            ,fruitList[i].allowsSeeding             -- bool allowsSeeding
            ,fruitList[i].hasStraw                  -- bool hasStraw
            ,fruitList[i].minHarvestingGrowthState  -- int minHarvestingGrowthState
            ,fruitList[i].pricePerLiter             -- float pricePerLiter
            ,fruitList[i].literPerQm                -- float literPerQm
            ,fruitList[i].seedUsagePerQm            -- float seedUsagePerQm
            ,fruitList[i].seedPricePerLiter         -- float seedPricePerLiter
            ,hudFile                                -- file hudFruitOverlayFilename
        );
    end;
end;
RegisterFruits();

--
--
--
local origSowingMachineLoad = SowingMachine.load;
SowingMachine.load = function(self, xmlFile)
    if origSowingMachineLoad ~= nil then
        origSowingMachineLoad(self, xmlFile);
    end;

    --
    local msg = "Info. Added seeds to '".. Utils.getNoNil(self.name, "SowingMachine") .."': ";
    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do

        local terrainId = 0;
        if g_currentMission.fruits[fruitType.index] ~= nil then
            terrainId = g_currentMission.fruits[fruitType.index].id;
        end;

        if fruitType.allowsSeeding and terrainId > 0 then
            table.insert(self.seeds, fruitType.index);
            msg = msg .. FruitUtil.fruitIndexToDesc[ fruitType.index ].name .." ";
        end;
    end;
    print(msg);

    table.sort(self.seeds, function(l,r) return (FruitUtil.fruitIndexToDesc[l].name < FruitUtil.fruitIndexToDesc[r].name); end);
end;
