--
-- platinumMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

platinumMap = {}

local platinumMap_mt = Class(platinumMap, Mission00);

function platinumMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = platinumMap_mt;
    end;
    local self = platinumMap:superClass():new(baseDirectory, mt);
    return self;
end;

function platinumMap:delete()
    platinumMap:superClass().delete(self);
end;

function platinumMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
	--load Bottles
    self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
	--load Glass Containers
    self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
    
    platinumMap:superClass().load(self);
end
function platinumMap:loadFinished()
    platinumMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function platinumMap:mouseEvent(posX, posY, isDown, isUp, button)
    platinumMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function platinumMap:keyEvent(unicode, sym, modifier, isDown)
    platinumMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function platinumMap:update(dt)
    platinumMap:superClass().update(self, dt);
end;

function platinumMap:draw()
    platinumMap:superClass().draw(self);
end;
