transport = {};

function transport.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function transport:load(xmlFile)

-----------------------------------------------------------------------------------
------------------- Appel des touches dans le .xml --------------------------------
-----------------------------------------------------------------------------------
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	
-----------------------------------------------------------------------------------
------------------- Dclaration d'une rotation XXX --------------------------------
-----------------------------------------------------------------------------------
	
    local rotationPartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
    end;
	
	    self.rotationMax = true;
	
end;


function transport:delete()
end;

function transport:mouseEvent(posX, posY, isDown, isUp, button)
end;

function transport:keyEvent(unicode, sym, modifier, isDown)
	
	if isDown and sym==self.keys.low then
		self.rotationMax = not self.rotationMax;
	end; 
end;

function transport:update(dt)



		
-----------------------------------------------------------------------------------
------------------- Fonctionnement de la rotation ---------------------------------
-----------------------------------------------------------------------------------
		
		  if self.rotationPart ~= nil then

            local x, y, z = getRotation(self.rotationPart.node);
            local maxRot = self.rotationPart.maxRot;
            local minRot = self.rotationPart.minRot;
            local eps = self.rotationPart.touchRotLimit;


            local x, y, z = getRotation(self.rotationPart.node);
            local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
            setRotation(self.rotationPart.node, unpack(newRot));

        end;

		
end;

function transport:draw()
end;

