--Perard Innerbanne 25
--hz888



perard = {};

function perard.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function perard:load(xmlFile)

    self.pipeParticles = {};
    local i = 0;
    while true do
	local key = string.format("vehicle.pipeParticles.pipeParticle(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
        	break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
	        local fillType = FruitUtil.fruitTypeToFillType[desc.index];
	        local currentPS = {};
                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
	                self.pipeParticles[fillType] = currentPS;
	                if self.defaultpipeParticles == nil then
	                	self.defaultpipeParticles = currentPS;
	                end;
        end;
        i = i + 1;
    end;

    self.TrailerTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TrailerTrigger#index"));
    self.onTrigger = perard.onTrigger;
    if self.TrailerTrigger ~= nil then
    	addTrigger(self.TrailerTrigger, "onTrigger", self);
    end;
    self.isTrailerInRange = false;
    self.kardan1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kardan1#index"));
    self.kardan2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kardan2#index"));
    self.grainUnloading = 50;

    local pipeNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipe#index"));
    if pipeNode ~= nil then
        self.pipe = {};
        self.pipe.node = pipeNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pipe#minRot"));
        self.pipe.minRot = {};
        self.pipe.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pipe.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pipe.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pipe#maxRot"));
        self.pipe.maxRot = {};
        self.pipe.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pipe.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pipe.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.pipe.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pipe#rotTime"), 2)*1000;
        self.pipe.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pipe#touchRotLimit"), 10));
    end;

    local pipe1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipe1#index"));
    if pipe1Node ~= nil then
        self.pipe1 = {};
        self.pipe1.node = pipe1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pipe1#minRot"));
        self.pipe1.minRot = {};
        self.pipe1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pipe1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pipe1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pipe1#maxRot"));
        self.pipe1.maxRot = {};
        self.pipe1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.pipe1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.pipe1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.pipe1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pipe1#rotTime"), 2)*1000;
        self.pipe1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pipe1#touchRotLimit"), 10));
    end;

end;

function perard:delete()

    for _, particleSystem in pairs(self.pipeParticles) do
        Utils.deleteParticleSystem(particleSystem);
    end;

end;

function perard:readStream(streamId, connection)

end;

function perard:writeStream(streamId, connection)

end;

function perard:mouseEvent(posX, posY, isDown, isUp, button)
end;

function perard:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_x then
		self.pipeMax = not self.pipeMax;
	end;

	if isDown and sym == Input.KEY_b and self.trailerFound ~= nil and self.pipeMax then
		self.ont = not self.ont;
	end;

end;

function perard:update(dt)
	
	
    if self:getIsActive() and self:getIsActiveForInput() then
 	local trailer = g_currentMission.nodeToVehicle[self.trailerFound];
	if self.trailerFound ~= nil and self.pipeMax then
		if self.ont then
	        	local deltaLevel = self.grainUnloading;
			if trailer ~= nil then
				deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
				if trailer.fillLevel >= trailer.capacity then
					self.ont = false;
				end;
				if self.fillLevel <= 0.0 then
					Utils.setEmittingState(self.pipeParticles[trailer.currentFillType], false);
				else
					Utils.setEmittingState(self.pipeParticles[self.currentFillType], true);
	            		end;
			else
				deltaLevel = 0;
				self.ont = false;
			end;
	            	if self.fillLevel <= 0.0 then
	                	deltaLevel = deltaLevel+self.fillLevel;
	               		self.fillLevel = 0.0;
				self.ont = false;
	            	end;
	        	self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
			if trailer ~= nil then
				trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentFillType);
			end;
		else
			Utils.setEmittingState(self.pipeParticles[self.currentFillType], false);
		end;
		if self.ont and self.kardan1 ~= nil then
			rotate(self.kardan1, 0, 0,dt*0.02);
		end;
		if self.ont and self.kardan2 ~= nil then
			rotate(self.kardan2, 0, 0,dt*-0.02);
		end;
	else
		Utils.setEmittingState(self.pipeParticles[self.currentFillType], false);

	end;
	if self.pipe ~= nil then
		local x, y, z = getRotation(self.pipe.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.pipe.maxRot, self.pipe.minRot, 3, self.pipe.rotTime, dt, not self.pipeMax);
		setRotation(self.pipe.node, unpack(newRot));
	end;
	if self.pipe1 ~= nil then
		local x, y, z = getRotation(self.pipe1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.pipe1.maxRot, self.pipe1.minRot, 3, self.pipe1.rotTime, dt, not self.pipeMax);
		setRotation(self.pipe1.node, unpack(newRot));
	end;

    end;

end;

function perard:draw()

    if self.pipeMax then
    	if self.trailerFound ~= nil then
		if self.ont then
       			g_currentMission:addExtraPrintText("B: Cancel unloading");
		else
			if self.fillLevel <= 0.0 then
        			g_currentMission:addExtraPrintText("Empty");
			else
       				g_currentMission:addExtraPrintText("B: Start overloading");
			end;
		end;
    	end;
	g_currentMission:addExtraPrintText("X: Move pipe in");
    else
	g_currentMission:addExtraPrintText("X: Move pipe out");
    end;

end;

function perard:onTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

    if self:getIsActive() then
    	if onStay or onEnter then
        	self.isTrailerInRange = true;
		self.trailerFound = otherId;
	elseif onLeave then
                self.isTrailerInRange = false;
		self.trailerFound = nil;
        end;
    end;

end;

