-- MF1200
-- hz888


MF1200 = {};

function MF1200.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MF1200:load(xmlFile)

    self.twinVL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVL#index"));
    self.twinVR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVR#index"));
    self.twinHL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHL#index"));
    self.twinHR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHR#index"));

    self.Nwheels = {};
    self.Nwheels[1] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Nwheels.Nwheel1#index"));
    self.Nwheels[2] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Nwheels.Nwheel2#index"));
    self.Nwheels[3] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Nwheels.Nwheel3#index"));	
    self.Nwheels[4] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Nwheels.Nwheel4#index"));
    self.drawNwheel = getVisibility(self.Nwheels[1])
  
    local MF1200GetSaveAttributesAndNodes = MF1200.getSaveAttributesAndNodes;
    local MF1200LoadFromAttributesAndNodes = MF1200.loadFromAttributesAndNodes;    
    self.backcamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backcamera#index"));
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

     hornSoundFile = Utils.getFilename("horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("MF1200_horn");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;

    steerHydSoundFile = Utils.getFilename("mf1200_steerHyd.wav", self.baseDirectory);
    self.steerHydSoundId = createSample("MF1200_steerSound");
    loadSample(self.steerHydSoundId, steerHydSoundFile, false);
    self.steerHydPlaying = false;

    self.farLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.farLight#index"));
    self.workLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLight#index"));
    self.brakeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brakeLight#index"));
	
    self.indexeb = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexeb#index"));
    self.indexhb = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexhb#index"));
    self.indexej = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexej#index"));
    self.indexhj = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indexhj#index"));
	
    self.farLightActive = false;
    self.brakeLightActive = false;
    self.workLightActive = false;
	
    self.lighton = false;
	
    self.indexbActive = false;
    self.indexjActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.ablaktActive = false;	
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayWischer1 = 0;
    self.delayWischer2 = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.deltafo = 0;
	
    self.help = false;
    if self.uzemora == nil then
		self.uzemora = 0;
    end;

    self.exhaust = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exhaust#index"));
    self.exhaustParticleSystemextra = {};
    local psName = "vehicle.exhaustParticleSystemextra";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystemextra, psName, self.exhaust, false, nil, self.baseDirectory)

    self.exhaustParticleSystem = {};
    local psName = "vehicle.exhaustParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystem, psName, self.exhaust, false, nil, self.baseDirectory)

    self.exhaustParticleSystemextra1 = {};
    local psName = "vehicle.exhaustParticleSystemextra1";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystemextra1, psName, self.exhaust, false, nil, self.baseDirectory)

    local alsokarNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.alsokar#index"));
    if alsokarNode ~= nil then
        self.alsokar = {};
        self.alsokar.node = alsokarNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.alsokar#minRot"));
        self.alsokar.minRot = {};
        self.alsokar.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.alsokar.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.alsokar.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.alsokar#maxRot"));
        self.alsokar.maxRot = {};
        self.alsokar.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.alsokar.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.alsokar.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.alsokar.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.alsokar#rotTime"), 2)*1000;
        self.alsokar.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.alsokar#touchRotLimit"), 10));
    end;

    local felsokarNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.felsokar#index"));
    if felsokarNode ~= nil then
        self.felsokar = {};
        self.felsokar.node = felsokarNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.felsokar#minRot"));
        self.felsokar.minRot = {};
        self.felsokar.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.felsokar.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.felsokar.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.felsokar#maxRot"));
        self.felsokar.maxRot = {};
        self.felsokar.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.felsokar.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.felsokar.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.felsokar.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.felsokar#rotTime"), 2)*1000;
        self.felsokar.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.felsokar#touchRotLimit"), 10));
    end;

    local orsoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.orso#index"));
    if orsoNode ~= nil then
        self.orso = {};
        self.orso.node = orsoNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.orso#minRot"));
        self.orso.minRot = {};
        self.orso.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.orso.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.orso.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.orso#maxRot"));
        self.orso.maxRot = {};
        self.orso.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.orso.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.orso.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.orso.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.orso#rotTime"), 2)*1000;
        self.orso.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.orso#touchRotLimit"), 10));
    end;

    local attachNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attach#index"));
    if attachNode ~= nil then
        self.attach = {};
        self.attach.node = attachNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attach#minRot"));
        self.attach.minRot = {};
        self.attach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attach#maxRot"));
        self.attach.maxRot = {};
        self.attach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.attach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.attach#rotTime"), 2)*1000;
        self.attach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.attach#touchRotLimit"), 10));
    end;

    local menetNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.menet#index"));
    if menetNode ~= nil then
        self.menet = {};
        self.menet.node = menetNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.menet#minTrans"));
        self.menet.minTrans = {};
        self.menet.minTrans[1] = Utils.getNoNil(x, 0);
        self.menet.minTrans[2] = Utils.getNoNil(y, 0);
        self.menet.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.menet#maxTrans"));
        self.menet.maxTrans = {};
        self.menet.maxTrans[1] = Utils.getNoNil(x, 0);
        self.menet.maxTrans[2] = Utils.getNoNil(y, 0);
        self.menet.maxTrans[3] = Utils.getNoNil(z, 0);
        self.menet.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.menet#transTime"), 2)*1000;
        self.menet.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.menet#touchTransLimit"), 10);
    end;

    local villaNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.villa#index"));
    if villaNode ~= nil then
        self.villa = {};
        self.villa.node = villaNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.villa#minTrans"));
        self.villa.minTrans = {};
        self.villa.minTrans[1] = Utils.getNoNil(x, 0);
        self.villa.minTrans[2] = Utils.getNoNil(y, 0);
        self.villa.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.villa#maxTrans"));
        self.villa.maxTrans = {};
        self.villa.maxTrans[1] = Utils.getNoNil(x, 0);
        self.villa.maxTrans[2] = Utils.getNoNil(y, 0);
        self.villa.maxTrans[3] = Utils.getNoNil(z, 0);
        self.villa.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.villa#transTime"), 2)*1000;
        self.villa.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.villa#touchTransLimit"), 10);
    end;

    local munkahengerNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.munkahenger#index"));
    if munkahengerNode ~= nil then
        self.munkahenger = {};
        self.munkahenger.node = munkahengerNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger#minTrans"));
        self.munkahenger.minTrans = {};
        self.munkahenger.minTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger.minTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.munkahenger#maxTrans"));
        self.munkahenger.maxTrans = {};
        self.munkahenger.maxTrans[1] = Utils.getNoNil(x, 0);
        self.munkahenger.maxTrans[2] = Utils.getNoNil(y, 0);
        self.munkahenger.maxTrans[3] = Utils.getNoNil(z, 0);
        self.munkahenger.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger#transTime"), 2)*1000;
        self.munkahenger.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.munkahenger#touchTransLimit"), 10);
    end;

    local kiptetNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kiptet#index"));
    if kiptetNode ~= nil then
        self.kiptet = {};
        self.kiptet.node = kiptetNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kiptet#minRot"));
        self.kiptet.minRot = {};
        self.kiptet.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kiptet.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kiptet.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kiptet#maxRot"));
        self.kiptet.maxRot = {};
        self.kiptet.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.kiptet.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.kiptet.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.kiptet.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kiptet#rotTime"), 2)*1000;
        self.kiptet.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kiptet#touchRotLimit"), 10));
    end;

    local ajtobNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ajtob#index"));
    if ajtobNode ~= nil then
        self.ajtob = {};
        self.ajtob.node = ajtobNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ajtob#minRot"));
        self.ajtob.minRot = {};
        self.ajtob.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ajtob.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ajtob.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ajtob#maxRot"));
        self.ajtob.maxRot = {};
        self.ajtob.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ajtob.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ajtob.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.ajtob.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ajtob#rotTime"), 2)*1000;
        self.ajtob.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ajtob#touchRotLimit"), 10));
    end;

    local ajtojNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ajtoj#index"));
    if ajtojNode ~= nil then
        self.ajtoj = {};
        self.ajtoj.node = ajtojNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ajtoj#minRot"));
        self.ajtoj.minRot = {};
        self.ajtoj.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ajtoj.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ajtoj.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ajtoj#maxRot"));
        self.ajtoj.maxRot = {};
        self.ajtoj.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ajtoj.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ajtoj.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.ajtoj.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ajtoj#rotTime"), 2)*1000;
        self.ajtoj.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ajtoj#touchRotLimit"), 10));
    end;

    local motortetNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.motortet#index"));
    if motortetNode ~= nil then
        self.motortet = {};
        self.motortet.node = motortetNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motortet#minRot"));
        self.motortet.minRot = {};
        self.motortet.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motortet.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motortet.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motortet#maxRot"));
        self.motortet.maxRot = {};
        self.motortet.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motortet.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motortet.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.motortet.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motortet#rotTime"), 2)*1000;
        self.motortet.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motortet#touchRotLimit"), 10));
    end;

    local ablaktNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ablakt#index"));
    if ablaktNode ~= nil then
        self.ablakt = {};
        self.ablakt.node = ablaktNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ablakt#minRot"));
        self.ablakt.minRot = {};
        self.ablakt.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ablakt.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ablakt.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ablakt#maxRot"));
        self.ablakt.maxRot = {};
        self.ablakt.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ablakt.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ablakt.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.ablakt.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ablakt#rotTime"), 2)*1000;
        self.ablakt.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ablakt#touchRotLimit"), 10));
    end;
    self.ventiNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.venti#index"));
end;

function MF1200:delete()
    Utils.deleteParticleSystem(self.exhaustParticleSystemextra1);
    Utils.deleteParticleSystem(self.exhaustParticleSystemextra);
    Utils.deleteParticleSystem(self.exhaustParticleSystem);
end;

function MF1200:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MF1200:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == self.keys.rabaTwins then 
		self.dualwheels = not self.dualwheels;
		setVisibility(self.twinVL, self.dualwheels);
		setVisibility(self.twinVR, self.dualwheels);
		setVisibility(self.twinHL, self.dualwheels);
		setVisibility(self.twinHR, self.dualwheels);		
	end;
    if isDown and sym == self.keys.rabaTwins then
    	self.drawNwheel = not self.drawNwheel;
    	setVisibility(self.Nwheels[1], self.drawNwheel);
    	setVisibility(self.Nwheels[2], self.drawNwheel);
    	setVisibility(self.Nwheels[3], self.drawNwheel);
    	setVisibility(self.Nwheels[4], self.drawNwheel);		
    end;	

    if isDown and sym == self.keys.MF_HELPPANELHelp then 
		self.help = not self.help;
    end;

	if isDown and sym == self.keys.rabafarLight then
	   if self.lighton then
			self.farLightActive = not self.farLightActive;
	   end;
	end;
	if isDown and sym == self.keys.rabaworkLightH then
		self.workLightActive = not self.workLightActive;
	end;
	
	if isDown and sym == self.keys.rabaHaube then
		self.motortetMax = not self.motortetMax;
	end;
	if isDown and sym == self.keys.rabaTuerL then
		self.ajtobMax = not self.ajtobMax;
	end;
	if isDown and sym == self.keys.rabaTuerR then
		self.ajtojMax = not self.ajtojMax;
	end;
	if isDown and sym == self.keys.rabaWischer then
		self.ablaktActive = not self.ablaktActive;
	end;

	if sym == self.keys.rabahydUp then
		self.alsokarMax = isDown;
		self.felsokarMax = isDown;
		self.orsoMax = isDown;
		self.attachMax = isDown;
		self.villaMax = isDown;
		self.munkahengerMax = isDown;
	end;
	if sym == self.keys.rabahydDown then
		self.alsokarMin = isDown;
		self.felsokarMin = isDown;
		self.orsoMin = isDown;
		self.attachMin = isDown;
		self.villaMin = isDown;
		self.munkahengerMin = isDown;
	end;

	if isDown and sym == self.keys.rabaflashLeft then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.indexjActive = false;
	end;
	if isDown and sym == self.keys.rabaflashRight then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.indexbActive = false;
	end;
	if isDown and sym == self.keys.rabaflashWarn then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.indexjActive = false;
		self.indexbActive = false;
	end;
end;

function MF1200:update(dt)

    if self.motor.lastMotorRpm > 750 and self.isEntered then

		if self.kiptet ~= nil then
        	local x, y, z = getRotation(self.kiptet.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.kiptet.maxRot, self.kiptet.minRot, 3, self.kiptet.rotTime, dt, self.isEntered);
        	setRotation(self.kiptet.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra, true)
		if self.motor.lastMotorRpm > 1300 then
			Utils.setEmittingState(self.exhaustParticleSystemextra1, true)
		else
			Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
		end;						
    elseif self.isEntered then
		self.kiptetmove = math.random(300,1300);
		if self.kiptet ~= nil then
        	local x, y, z = getRotation(self.kiptet.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, {90,0,0}, {self.kiptetmove*0.001,0,0}, 3, 60000, dt, self.isEntered);
        	setRotation(self.kiptet.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
        Utils.setEmittingState(self.exhaustParticleSystemextra, false)
        Utils.setEmittingState(self.exhaustParticleSystem, true)
    else
		if self.isAITractorActivated then
			if self.kiptet ~= nil then
        		local x, y, z = getRotation(self.kiptet.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.kiptet.maxRot, self.kiptet.minRot, 3, self.kiptet.rotTime, dt, true);
        		setRotation(self.kiptet.node, unpack(newRot));
    		end;
			Utils.setEmittingState(self.exhaustParticleSystemextra, true)
		else
			if self.kiptet ~= nil then
        		local x, y, z = getRotation(self.kiptet.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.kiptet.maxRot, self.kiptet.minRot, 3, self.kiptet.rotTime, dt, false);
        		setRotation(self.kiptet.node, unpack(newRot));
    		end;
		end;
    end;
	
    if self.isEntered then

		if self.ablaktActive then
			if self.delayWischer1 >= 0 then
				self.delayWischer1 = self.delayWischer1 -dt;
			end;
			if self.delayWischer2 >= 0 then
				self.delayWischer2 = self.delayWischer2 -dt;
			end;
			if not self.ablaktMax then
				if self.delayWischer1 < 0 then
					self.delayWischer2 = 1000;
					self.ablaktMax = true;
				end;
			end;
			if self.ablaktMax then
				if self.delayWischer2 < 0 then
					self.delayWischer1 = 1000;
					self.ablaktMax = false;
				end;
			end;
		else
			self.ablaktMax = false;
		end;
	
		if self.ventiNode ~= nil then
         	rotate(self.ventiNode, 0, 0, self.motor.lastMotorRpm);
    	end;
		if self.motortet ~= nil then
        	local x, y, z = getRotation(self.motortet.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.motortet.maxRot, self.motortet.minRot, 3, self.motortet.rotTime, dt, not self.motortetMax);
        	setRotation(self.motortet.node, unpack(newRot));
    	end;
		if self.ajtob ~= nil then
        	local x, y, z = getRotation(self.ajtob.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.ajtob.maxRot, self.ajtob.minRot, 3, self.ajtob.rotTime, dt, not self.ajtobMax);
        	setRotation(self.ajtob.node, unpack(newRot));
    	end;
		if self.ajtoj ~= nil then
        	local x, y, z = getRotation(self.ajtoj.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.ajtoj.maxRot, self.ajtoj.minRot, 3, self.ajtoj.rotTime, dt, not self.ajtojMax);
        	setRotation(self.ajtoj.node, unpack(newRot));
    	end;

		if self.ablakt ~= nil then
        	local x, y, z = getRotation(self.ablakt.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.ablakt.maxRot, self.ablakt.minRot, 3, self.ablakt.rotTime, dt, not self.ablaktMax);
        	setRotation(self.ablakt.node, unpack(newRot));
    	end;

		local doRotate = self.alsokarMax or self.alsokarMin 
		if self.alsokar ~= nil and doRotate then
        	local x, y, z = getRotation(self.alsokar.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.alsokar.maxRot, self.alsokar.minRot, 3, self.alsokar.rotTime, dt, not self.alsokarMax);
        	setRotation(self.alsokar.node, unpack(newRot));
		end;

		local doRotate = self.felsokarMax or self.felsokarMin 
		if self.felsokar ~= nil and doRotate then
			local x, y, z = getRotation(self.felsokar.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.felsokar.maxRot, self.felsokar.minRot, 3, self.felsokar.rotTime, dt, not self.felsokarMax);
			setRotation(self.felsokar.node, unpack(newRot));
		end;

		local doRotate = self.orsoMax or self.orsoMin 
		if self.orso ~= nil and doRotate then
			local x, y, z = getRotation(self.orso.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.orso.maxRot, self.orso.minRot, 3, self.orso.rotTime, dt, not self.orsoMax);
			setRotation(self.orso.node, unpack(newRot));
		end;

		local doRotate = self.attachMax or self.attachMin 
		if self.attach ~= nil and doRotate then
			local x, y, z = getRotation(self.attach.node);		
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.attach.maxRot, self.attach.minRot, 3, self.attach.rotTime, dt, not self.attachMax);
			setRotation(self.attach.node, unpack(newRot));
		end;

		local doTranslate = self.menetMax or self.menetMin 
		if self.menet ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.menet.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.menet.maxTrans, self.menet.minTrans, 3, self.menet.transTime, dt, not self.menetMax); 
			setTranslation(self.menet.node, unpack(newTrans)); 
		end;

		local doTranslate = self.villaMax or self.villaMin 
		if self.villa ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.villa.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.villa.maxTrans, self.villa.minTrans, 3, self.villa.transTime, dt, not self.villaMax); 
			setTranslation(self.villa.node, unpack(newTrans)); 
		end;

		local doTranslate = self.munkahengerMax or self.munkahengerMin 
		if self.munkahenger ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.munkahenger.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.munkahenger.maxTrans, self.munkahenger.minTrans, 3, self.munkahenger.transTime, dt, not self.munkahengerMax); 
			setTranslation(self.munkahenger.node, unpack(newTrans)); 
		end;

        if Input.isKeyPressed(self.keys.rabashowBack) and self.camIndex == 2 then
                setCamera(self.backcamera);
       	end;

        self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
		if InputBinding.isAxisZero(self.input) then
        	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;

		if self.input == 1 and self.movingDirection > 0 then
			self.brakeLightActive = true;
		elseif self.input == -1 and self.movingDirection < 0 then
				self.brakeLightActive = true;
		else
			self.brakeLightActive = false;
		end;

        if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
			if not self.farLightActive and not self.lighton then
				self.lighton = true;
			elseif not self.farLightActive and self.lighton then
				self.lighton = false;
			elseif self.farLightActive and self.lighton then
				self.lighton = false;
				self.farLightActive = false;
			end;
		end;

        if self.farLight ~= nil then
            if self.farLightActive then
            	setVisibility(self.farLight, self.farLightActive);
			else
            	setVisibility(self.farLight, self.farLightActive);
			end;
        end;

        if self.brakeLight ~= nil then
            if self.brakeLightActive then
            	setVisibility(self.brakeLight, self.brakeLightActive);
			else
            	setVisibility(self.brakeLight, self.brakeLightActive);
			end;
        end;

        if self.workLight ~= nil then
            if self.workLightActive then
            	setVisibility(self.workLight, self.workLightActive);
			else
            	setVisibility(self.workLight, self.workLightActive);
			end;
        end;

        if self.indexeb ~= nil and self.indexhb ~= nil then
            if self.indexbActive then
            	setVisibility(self.indexeb, self.indexbActive);
            	setVisibility(self.indexhb, self.indexbActive);
			else
            	setVisibility(self.indexeb, self.indexbActive);
            	setVisibility(self.indexhb, self.indexbActive);
			end;
        end;

        if self.indexej ~= nil and self.indexhj ~= nil then
            if self.indexjActive then
            	setVisibility(self.indexej, self.indexjActive);
            	setVisibility(self.indexhj, self.indexjActive);
			else
            	setVisibility(self.indexej, self.indexjActive);
            	setVisibility(self.indexhj, self.indexjActive);
			end;
        end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.indexbActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.indexbActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.indexbActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.indexbActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.indexjActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.indexjActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.indexjActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.indexjActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;
		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.indexjActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.indexjActive = true;
					self.indexbActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.indexjActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.indexbActive = false;
					self.indexjActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;
		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.indexjActive = false;
				self.indexbActive = false;
			end;
		end;
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.indexjActive = false;
			end;
		end;
		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.indexbActive = false;
			end;
		end;
		
	end;
end;


function MF1200:draw()

    if self.isEntered then
		if not self.help then
			setTextColor(1,1,1,1);
			renderText(0.825, 0.15, 0.021, "0: Info ist aus");
		else
			setTextColor(1,1,1,1);
			renderText(0.825, 0.15, 0.021, "0: Info ist an");
			if self.hudRABAOverlay ~= nil then
				self.hudRABAOverlay:render();
			end;			
		end;
		self.ora = g_currentMission.environment.dayTime/60;
    end;
end;

function MF1200:onEnter()
    self.isEntered = true;
end;

function MF1200:onLeave()

    self.isEntered = false;
    self.farLightActive = false;
    self.brakeLightActive = false;
    self.workLightActive = false;
    self.indexjActive = false;
    self.indexbActive = false;
    self.flash = false;
    self.flashRight = false;
    self.flashLeft = false;
    self.lighton = false;

    setVisibility(self.farLight, self.farLightActive);
    setVisibility(self.brakeLight, self.brakeLightActive);
    setVisibility(self.workLight, self.workLightActive);
    setVisibility(self.indexej, self.indexjActive);
    setVisibility(self.indexhj, self.indexjActive);
    setVisibility(self.indexeb, self.indexbActive);
    setVisibility(self.indexhb, self.indexbActive);

    Utils.setEmittingState(self.exhaustParticleSystemextra, false)
    Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
    Utils.setEmittingState(self.exhaustParticleSystem, false)

end;

function MF1200:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function MF1200:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local attributes, nodes;
    if MF1200LoadFromAttributesAndNodes ~= nil then
        local r = MF1200LoadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
        if r ~= BaseMission.VEHICLE_LOAD_OK then
            return r;
        end;
    end;

    if not resetVehicles then
        local uzemora = getXMLFloat(xmlFile, key.."#uzemora");
        if uzemora ~= nil then
            self.uzemora = uzemora;
        end;
    end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function MF1200:getSaveAttributesAndNodes(nodeIdent)
    local attributes, nodes;
    if MF1200GetSaveAttributesAndNodes ~= nil then
        attributes, nodes = MF1200GetSaveAttributesAndNodes(self, nodeIdent);
    end;
    local modStr = 'uzemora="'..self.uzemora..'"';
    if attributes == nil then
        attributes = modStr;
    else
        attributes = attributes .. " "..modStr;
    end;
    return attributes, nodes;
end;
