-- Baustellenbeleuchtung
-- @author: Sven777b
-- @date: 22.11.2011

Baustelle = {};

_G.Baustelle = Baustelle;
function Baustelle.onCreate(id)
	if _G.warnlichter == nil then
		_G.warnlichter = {};
	end;
	table.insert(_G.warnlichter, Warnlicht:new(id));
end;

function Baustelle:update(dt)
	if _G.warnlichter ~= nil then
		for k,v in pairs(_G.warnlichter) do
			v:update(dt);
		end;
	end;
end;

function Baustelle:delete()
end;
function Baustelle:loadMap(name)
end;
function Baustelle:deleteMap()
	if _G.warnlichter ~= nil then
		for k,v in pairs(_G.warnlichter) do
			v:delete(dt);
		end;
	end;
end;
function Baustelle:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Baustelle:keyEvent(unicode, sym, modifier, isDown)
end;
function Baustelle:draw()
end;


Warnlicht = {};
local Warnlicht_mt = Class(Warnlicht);

function Warnlicht:new(id, customMt)
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, Warnlicht_mt);
    end;

    instance.dauer = Utils.getNoNil(getUserAttribute(id, "dauer"),1) * 1000;
   
    instance.lichter = {};
	local numc = getNumOfChildren(id);
	if numc > 0 then
		for child=0,(numc-1) do
			li = getChildAt(id,child);
			if li ~= nil then
				table.insert(instance.lichter, li);
				setVisibility(li,false);
			end;
		end;
		instance.anzahl = table.getn(instance.lichter);
		instance.isEnabled = true;
	end;

    instance.timer = 0;
    instance.licht = 1;
    
    return instance;
end;

function Warnlicht:update(dt)
	if self.isEnabled then
		if self.timer > self.dauer then
			setVisibility(self.lichter[self.licht],false);
			self.licht = self.licht+1;
			if self.licht > self.anzahl then self.licht = 1; end;
			setVisibility(self.lichter[self.licht], true);
			self.timer = 0;
		else
			self.timer = self.timer + dt;
		end;
	end;
end;

function Warnlicht:delete()
end;

addModEventListener(Baustelle);
g_onCreateUtil.addOnCreateFunction("BaustelleOnCreate", Baustelle.onCreate);
