-- anitor
-- @author: Daniel (Desperados93) W. / GIANTS Software GmbH / sven777b
-- @date: 22.02.2011

-- Copyright () by Daniel "Desperados93" W.
   
  anitor = {};
  
  local anitor_mt = Class(anitor);
  
  function anitor.onCreate(id)
      g_currentMission:addUpdateable(anitor:new(id));
      --print("created tip trigger, id: ", id);
  end;
  
  function anitor:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, anitor_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.barriers = {};
      
      local num = getNumOfChildren(id);
      for i=0, num-1 do
          local childLevel1 = getChildAt(id, i);
          if childLevel1 ~= 0 and getNumOfChildren(id) >= 1 then
              local barrierId = getChildAt(childLevel1, 0);
              if barrierId ~= 0 then
                  table.insert(instance.barriers, barrierId);
              end;
          end;
      end;
  
      instance.isEnabled = true;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 18;
      self.minTrans = 0;
  
      return instance;
  end;
  
  function anitor:delete()
 
      removeTrigger(self.triggerId);
  end;
  
  function anitor:update(dt)
      
      local old = self.trans;
      if self.count > 0 then
          if self.trans < self.maxTrans then
              self.trans = self.trans + dt*0.001;    
          end;
     else
          if self.trans > self.minTrans then
              self.trans = self.trans - dt*0.001;    
          end;
      end;
      
      if old ~= self.trans then
          for i=1, table.getn(self.barriers) do
              setTranslation(self.barriers[i], self.trans, 0, 0);
          end;
      end;
      
  end;
  
  function anitor:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("anitorOnCreate", anitor.onCreate);

