--
-- Show workers on PDA-map
--
-- @author  Decker    (ls-uk.info, Decker_MMIV)
-- @date    2011-04-19
--
--
-- @history
--          v0.9(beta)  Public release, only tested in singleplayer and patch 2.3.
--
--


Hirable.circleYellow = Utils.getFilename("extras/pda_map_fade.png", g_currentModDirectory);

local oldHirableHire    = Hirable.hire;     -- I do wonder, if there isn't a better way at overloading the lua functions, than a hack like this?
local oldHirableDismiss = Hirable.dismiss;
local oldHirableUpdate  = Hirable.update;

Hirable.hire = function(self)
    if oldHirableHire ~= nil then
        oldHirableHire(self);
    end;
    if self.isHired then
        if self.workerIconOnPda == nil then
            local x,y,z = getWorldTranslation(self.components[1].node);
            --print(string.format("hire x,y,z=%f/%f/%f", x,y,z));
            self.workerIconOnPda = g_currentMission.missionPDA:createMapHotspot(
                "Worker",   -- name of hotspot
                Hirable.circleYellow,    -- "dataS2/missions/hud_pda_spot_yellow.png",  -- icon-filename
                x+g_currentMission.missionPDA.worldCenterOffsetX, z+g_currentMission.missionPDA.worldCenterOffsetZ,  -- position in map
                g_currentMission.missionPDA.pdaMapArrowSize / 4, g_currentMission.missionPDA.pdaMapArrowSize * (4 / 3) / 4, -- size of icon
                false,  -- Blinking icon.
                false,  -- Blinking icon and when outside visible map-part, place it on the map-edge.
                0       -- Unknown.
            );
        else
            self.workerIconOnPda.enabled = true;
            --self.workerIconOnPda.visible = true;
        end;
    end;
end;

Hirable.dismiss = function(self)
    if oldHirableDismiss ~= nil then
        oldHirableDismiss(self);
    end;
    if self.workerIconOnPda ~= nil then
        self.workerIconOnPda.enabled = false;
        --self.workerIconOnPda.visible = false;
    end;
end;

Hirable.update = function(self, dt)
    if oldHirableUpdate ~= nil then
        oldHirableUpdate(self, dt);
    end;
    if (self.workerIconOnPda ~= nil) and (self.workerIconOnPda.enabled) then
        local x,y,z = getWorldTranslation(self.components[1].node);
        --print(string.format("updt x,y,z=%f/%f/%f", x,y,z));
        self.workerIconOnPda.xMapPos = x+g_currentMission.missionPDA.worldCenterOffsetX;
        self.workerIconOnPda.yMapPos = z+g_currentMission.missionPDA.worldCenterOffsetZ;

        -- Sorry no "rotation". I dont do/know the UVs-math. And I doubt the hotspot supports it with a nice API-function. Though I could be wrong.
    end;
end;

print("Script loaded: ShowWorkersOnPDA.lua");
