--
-- Polanin seeder
-- author: Burner
-- date: 04.09.2011
--

Polanin = {};

function Polanin.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Polanin:load(xmlFile)
	local transportAttacherNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.transportAttacherNode#index"));
	if transportAttacherNode ~= nil then
		self.transportAttacherNode = transportAttacherNode;
	end;
	
	local workAttacherNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.workAttacherNode#index"));
	if workAttacherNode ~= nil then
		self.workAttacherNode = workAttacherNode;
	end;
	
	self.attacherJointBackup = self.attacherJoint;
	local attacherJointWork = {};
	attacherJointWork.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointWork#index"));
	if attacherJointWork.node ~= nil then
		attacherJointWork.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointWork#topReferenceNode"));
		attacherJointWork.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointWork#rootNode")), self.components[1].node);
		attacherJointWork.fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointWork#fixedRotation"), false);

		attacherJointWork.allowsJointRotLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointWork#allowsJointRotLimitMovement"), true);
		attacherJointWork.allowsJointTransLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointWork#allowsJointTransLimitMovement"), true);

		--load joint limit scales
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.attacherJointWork#rotLimitScale"));
		attacherJointWork.rotLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.attacherJointWork#transLimitScale"));
		attacherJointWork.transLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };
		
		local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJointWork#jointType")
		local jointType;

		if jointTypeStr ~= nil then
			jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
			if jointType == nil then
				print("Warning: invalid jointType " .. jointTypeStr);
			end;
		else
			print("Warning: missing jointType");
		end;
		if jointType == nil then
			local needsTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointWork#needsTrailerJoint"), false);
			local needsLowTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointWork#needsLowJoint"), false);
			if needsTrailerJoint then
				if needsLowTrailerJoint then
					jointType = Vehicle.JOINTTYPE_TRAILERLOW;
				else
					jointType = Vehicle.JOINTTYPE_TRAILER;
				end;
			else
				jointType = Vehicle.JOINTTYPE_IMPLEMENT;
			end;
		end;
		attacherJointWork.jointType = jointType;
		self.attacherJointWork = attacherJointWork;
	end;
end;

function Polanin:delete()
end;

function Polanin:readStream(streamId, connection)
end;

function Polanin:writeStream(streamId, connection)
end;

function Polanin:readUpdateStream(streamId, timestamp, connection)
end;

function Polanin:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Polanin:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Polanin:keyEvent(unicode, sym, modifier, isDown)
end;

function Polanin:update(dt)
	if self.isClient then
		if self.transportAttacherNodeInRange then
			if InputBinding.hasEvent(InputBinding.POLANIN_LOWER_ATTACHER) then
				if self.animationParts[2].clipEndTime then
					self:setAnimationTime(2, self.animationParts[2].offSet);
				else
					self:setAnimationTime(2, self.animationParts[2].animDuration);
				end;
			end;
			if self.animationParts[2].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POLANIN_LOWER_ATTACHER"), self.typeDesc), InputBinding.POLANIN_LOWER_ATTACHER);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POLANIN_LIFT_ATTACHER"), self.typeDesc), InputBinding.POLANIN_LOWER_ATTACHER);
			end;
		end;
		if self.workAttacherNodeInRange then
			if InputBinding.hasEvent(InputBinding.POLANIN_LOWER_ATTACHER) then
				if self.animationParts[3].clipEndTime then
					self:setAnimationTime(3, self.animationParts[3].offSet);
				else
					self:setAnimationTime(3, self.animationParts[3].animDuration);
				end;
			end;
			if self.animationParts[3].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POLANIN_LIFT_ATTACHER"), self.typeDesc), InputBinding.POLANIN_LOWER_ATTACHER);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POLANIN_LOWER_ATTACHER"), self.typeDesc), InputBinding.POLANIN_LOWER_ATTACHER);
			end;
		end;
	end;
	if self.animationParts[3].clipEndTime then
		self.attacherJoint = self.attacherJointWork;
	else
		self.attacherJoint = self.attacherJointBackup;
	end;
	if self:getIsActiveForInput() then
		if self.animationParts[3].clipEndTime then
			if InputBinding.hasEvent(InputBinding.POLANIN_LOWER_WHEELS) then
				if self.animationParts[1].clipEndTime then
					self:setAnimationTime(1, self.animationParts[1].offSet);
				else
					self:setAnimationTime(1, self.animationParts[1].animDuration);
				end;
			end;
		end;
	end;
end;

function Polanin:updateTick(dt)
	if self.attacherVehicle == nil and g_currentMission.player ~= nil then
		local nearestDistance = 1.5;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local sx, sy, sz = getWorldTranslation(self.transportAttacherNode); 
		local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);	
		if distance < nearestDistance then
			self.transportAttacherNodeInRange = true; 
		else
			self.transportAttacherNodeInRange = false; 
		end;
		local sx, sy, sz = getWorldTranslation(self.workAttacherNode); 
		local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);	
		if distance < nearestDistance then
			self.workAttacherNodeInRange = true; 
		else
			self.workAttacherNodeInRange = false; 
		end;
	end;
	
end;

function Polanin:draw()
	if self.isClient then
		if self.animationParts[3].clipEndTime then
			if self.animationParts[1].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POLANIN_LIFT_WHEELS"), self.typeDesc), InputBinding.POLANIN_LOWER_WHEELS);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POLANIN_LOWER_WHEELS"), self.typeDesc), InputBinding.POLANIN_LOWER_WHEELS);
			end;
		end;
	end;
end;

function Polanin:onDetach()
end;

function Polanin:onLeave()
end;

function Polanin:onDeactivate()
end;