--
-- Show workers on PDA-map
--
-- @author  Decker    (ls-uk.info, Decker_MMIV)
-- @date    2011-04-19
--
-- @history
--          v0.9(beta)  Public release, only tested in singleplayer and patch 2.3.
--          v0.91(beta) Fix for updating position too often, as it seems to have a negative impact in multiplayer.
--          v0.92(beta) Changed to use; <originalFunc>=Utils.appendedFunction(<originalFunc>,<addedFunc>)
--          v0.93(beta) Added "worker-icons" for CoursePlay v2.4 controlled vehicles
--          v0.94(beta) Fix for when CoursePlay v2.4 is loaded after this script. Now using ModEventListener and update() to make a delayed call to Utils.appendedFunction()
--

ShowWorkersOnPDA = {};
ShowWorkersOnPDA.version = 0.94;    -- Using floating-point for version-number? Not wise, but its going to do for now.
ShowWorkersOnPDA.circleYellow = Utils.getFilename("Scripts/pda_map_circle_yellow.png", g_currentModDirectory);

function ShowWorkersOnPDA.addWorkerIconOnPda(self)
    if self.workerIconOnPda == nil then
        local x,y,z = getWorldTranslation(self.components[1].node);
        --print(string.format("hire x,y,z=%f/%f/%f", x,y,z));
        self.workerIconOnPda = g_currentMission.missionPDA:createMapHotspot(
            nil,   -- name of hotspot
            ShowWorkersOnPDA.circleYellow,    -- "dataS2/missions/hud_pda_spot_yellow.png",  -- icon-filename
            x+g_currentMission.missionPDA.worldCenterOffsetX, z+g_currentMission.missionPDA.worldCenterOffsetZ,  -- position in map
            g_currentMission.missionPDA.pdaMapArrowSize / 4, g_currentMission.missionPDA.pdaMapArrowSize * (4 / 3) / 4, -- size of icon
            false,  -- Blinking icon.
            false,  -- Blinking icon and when outside visible map-part, place it on the map-edge.
            0       -- Unknown.
        );
    else
        self.workerIconOnPda.enabled = true;
    end;
end;

-- Steerable additions
function ShowWorkersOnPDA.updateSteerable(self, dt)
    if (self.workerIconOnPda ~= nil) and (self.workerIconOnPda.enabled) then
        local x,y,z = getWorldTranslation(self.components[1].node);
        --print(string.format("updt x,y,z=%f/%f/%f", x,y,z));
        x = math.floor(x+g_currentMission.missionPDA.worldCenterOffsetX); -- v0.91
        z = math.floor(z+g_currentMission.missionPDA.worldCenterOffsetZ); -- v0.91
        -- Only update position if different.
        if (self.workerIconOnPda.xMapPos ~= x or self.workerIconOnPda.yMapPos ~= z) then -- v0.91
            self.workerIconOnPda.xMapPos = x;
            self.workerIconOnPda.yMapPos = z;
        end;

        -- Sorry no "rotation". I dont do/know the UVs-math. And I doubt the hotspot supports it with a nice API-function. Though I could be wrong.
    end;
end;

Steerable.update = Utils.appendedFunction(Steerable.update, ShowWorkersOnPDA.updateSteerable);


-- Hirable additions
function ShowWorkersOnPDA.hire(self)
    if self.isHired then
        ShowWorkersOnPDA.addWorkerIconOnPda(self);
    end;
end;

function ShowWorkersOnPDA.dismiss(self)
    if self.workerIconOnPda ~= nil then
        self.workerIconOnPda.enabled = false;
    end;
end;

Hirable.hire    = Utils.appendedFunction(Hirable.hire,    ShowWorkersOnPDA.hire);
Hirable.dismiss = Utils.appendedFunction(Hirable.dismiss, ShowWorkersOnPDA.dismiss);


-- CoursePlay additions
function ShowWorkersOnPDA.cpStart(self2, self)   -- Why 'self2' and 'self'? That depends on . or :    See more on http://lua-users.org/wiki/ColonForMethodCall
    if (self.drive) then
        ShowWorkersOnPDA.addWorkerIconOnPda(self);
    end;
end;

function ShowWorkersOnPDA.cpStop(self2, self)    -- Why 'self2' and 'self'? That depends on . or :    See more on http://lua-users.org/wiki/ColonForMethodCall
    if self.workerIconOnPda ~= nil then
        self.workerIconOnPda.enabled = false;
    end;
end;

--[[
-- Try to detect if the courseplay mod is loaded by the game, by assuming that when 'courseplay' is defined it is.
if (courseplay ~= nil) then
    print("ShowWorkersOnPDA: Detected courseplay mod. Appending start/stop functions for show-workers-on-PDA.");

-- Darn. This did not work as expected.
--    -- Try to extract the version of courseplay mod.
--    local versionFound = nil;
--    local mods = Utils.getNoNil(g_currentMission.loadingScreen.mods, g_currentMission.loadingScreen.missionDynamicInfo.mods);
--    if mods ~= nil then
--        for k,v in pairs(mods) do
--            if (string.lower(v.modName) == "zzz_courseplay") then
--                versionFound = v.version;
--                break;
--            end;
--        end;
--    end;
--    if (versionFound ~= nil) then
--        print("ShowWorkersOnPDA: Warning. Unable to detect version of courseplay mod. Problems might occur.");
--    elseif (versionFound ~= "2.4") then
--        print("ShowWorkersOnPDA: Warning. May not work correctly with courseplay version '"..versionFound.."'.");
--    else
--        print("ShowWorkersOnPDA: courseplay version '"..versionFound.."'.");
--    end;

    --
    courseplay.start  = Utils.appendedFunction(courseplay.start,  ShowWorkersOnPDA.cpStart);
    courseplay.stop   = Utils.appendedFunction(courseplay.stop,   ShowWorkersOnPDA.cpStop);
end;    
]]

-- Detect if courseplay has also been loaded, so its start() and stop() functions can be appended to.
function ShowWorkersOnPDA:loadMap(name)
    ShowWorkersOnPDA.checkCourseplay = true
end;

function ShowWorkersOnPDA:deleteMap()
end;

--function ShowWorkersOnPDA:load(xmlFile)
--end;
--
--function ShowWorkersOnPDA:delete()
--end;

function ShowWorkersOnPDA:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowWorkersOnPDA:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowWorkersOnPDA:update(dt)
    if (ShowWorkersOnPDA.checkCourseplay) then
        ShowWorkersOnPDA.checkCourseplay = false;
        --
        -- Try to detect if the courseplay mod is loaded by the game, by assuming that when 'courseplay' is defined it is.
        if (courseplay ~= nil) then
            print("ShowWorkersOnPDA: Detected courseplay mod. Appending start/stop functions for show-workers-on-PDA.");
            courseplay.start  = Utils.appendedFunction(courseplay.start,  ShowWorkersOnPDA.cpStart);
            courseplay.stop   = Utils.appendedFunction(courseplay.stop,   ShowWorkersOnPDA.cpStop);
        end;
    end;
end;

function ShowWorkersOnPDA:draw()
end;

--
addModEventListener(ShowWorkersOnPDA);

--
print(string.format("Script loaded: ShowWorkersOnPDA.lua (v%.2f)", ShowWorkersOnPDA.version));
