--
-- OriginalMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

OriginalMap = {}

local OriginalMap_mt = Class(OriginalMap, Mission00);

function OriginalMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = OriginalMap_mt;
    end;
    local self = OriginalMap:superClass():new(baseDirectory, mt);
    return self;
end;

function OriginalMap:delete()
    OriginalMap:superClass().delete(self);
end;

function OriginalMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
    
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CowZone.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
	
	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Farming Shop", "dataS2/missions/hud_pda_spot_shop.png", 779, 699, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Brewery", "dataS2/missions/hud_pda_spot_brewery.png", 958, 1752, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Watermill", "dataS2/missions/hud_pda_spot_watermill.png", 1517, 1281, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Lighthouse", "dataS2/missions/hud_pda_spot_lighthouse.png", 114, 1929, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Bell", "dataS2/missions/hud_pda_spot_bell.png", 459, 718, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Bell", "dataS2/missions/hud_pda_spot_bell.png", 519, 149, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Mall", "dataS2/missions/hud_pda_spot_mall.png", 532, 665, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Mill", "dataS2/missions/hud_pda_spot_mill.png", 335, 762, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Vista", "dataS2/missions/hud_pda_spot_vista.png", 1036, 1198, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Dairy", "dataS2/missions/hud_pda_spot_dairy.png", 1401, 944, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Ruin", "dataS2/missions/hud_pda_spot_ruin.png", 736, 997, 0.055, 0.036, false, false, 0);

-- create Map Hotspots
    self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1165, 320, 0.055, 0.036, false, false, 0);
	
    OriginalMap:superClass().load(self);
end
function OriginalMap:loadFinished()
    OriginalMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function OriginalMap:mouseEvent(posX, posY, isDown, isUp, button)
    OriginalMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function OriginalMap:keyEvent(unicode, sym, modifier, isDown)
    OriginalMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function OriginalMap:update(dt)
   OriginalMap:superClass().update(self, dt);
end;

function OriginalMap:draw()
    OriginalMap:superClass().draw(self);
end;
