--
-- OrchardFarm
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

OrchardFarm = {}

local OrchardFarm_mt = Class(OrchardFarm, Mission00);

function OrchardFarm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = OrchardFarm_mt;
    end;
    local self = OrchardFarm:superClass():new(baseDirectory, mt);
    return self;
end;

function OrchardFarm:delete()
    OrchardFarm:superClass().delete(self);
end;

function OrchardFarm:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
   -- self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    --self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    OrchardFarm:superClass().load(self);
end
function OrchardFarm:loadFinished()
    OrchardFarm:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function OrchardFarm:mouseEvent(posX, posY, isDown, isUp, button)
    OrchardFarm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function OrchardFarm:keyEvent(unicode, sym, modifier, isDown)
    OrchardFarm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function OrchardFarm:update(dt)
    OrchardFarm:superClass().update(self, dt);
end;

function OrchardFarm:draw()
    OrchardFarm:superClass().draw(self);
end;
