--
-- Hilken 18000 ZMK_H
-- 
-- spring is inspired by the powerShaft from SFM 
--
--
-- @author:		fruktor (wwww.modding-society.de)
-- @version:	v0.1
-- @date:		08/12/10
-- @history:	v0.1 - inital implementation
--
--

Hilken18000ZMK = {};

function Hilken18000ZMK.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Hilken18000ZMK:load(xmlFile)

	self.spring = {};		
	self.spring.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hilken18000ZMK.spring(0)#index"));
	local x,y,z = getRotation(self.spring.node);
	
	self.spring.part = {x,y,z};
	self.spring.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hilken18000ZMK.spring(0)#part"));
	x,y,z = getTranslation(self.spring.part);
	
	self.spring.fixPoint = {x,y,z};
	self.spring.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hilken18000ZMK.spring(0)#fixPoint"));
	
	local ax, ay, az = getWorldTranslation(self.spring.part);
	local bx, by, bz = getWorldTranslation(self.spring.fixPoint);		
	self.spring.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.spring.target = {x,y,z};
	self.spring.target = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hilken18000ZMK.spring(0)#target"));

	--####
	self.seil = {};		
	self.seil.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hilken18000ZMK.seil(0)#index"));
	local x,y,z = getRotation(self.seil.node);
	
	self.seil.parts = {};
	local i=1;
	while true do
		local part = {x,y,z};
		part = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.Hilken18000ZMK.seil(0)#part%d", i)));
		if part == nil then
			break;
		end;
		x,y,z = getTranslation(part);
		self.seil.parts[i]=part;
		i=i+1;
	end;
	
	self.seil.fixPoint = {x,y,z};
	self.seil.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hilken18000ZMK.seil(0)#fixPoint"));
	
	self.seil.target = {x,y,z};
	self.seil.target = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hilken18000ZMK.seil(0)#target"));

	local ax, ay, az = getWorldTranslation(self.seil.parts[table.getn(self.seil.parts)]);
	local bx, by, bz = getWorldTranslation(self.seil.fixPoint);		
	--local bx, by, bz = getWorldTranslation(self.seil.target);		
	self.seil.distEnd = Utils.vector3Length(ax-bx, ay-by, az-bz);	
		
	ax, ay, az = getWorldTranslation(self.seil.node);
	bx, by, bz = getWorldTranslation(self.seil.parts[2]);	
	self.seil.distStart = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	
	ax, ay, az = getWorldTranslation(self.seil.node);
	bx, by, bz = getWorldTranslation(self.seil.target);	
	self.seil.dist = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.seil.dist2 = self.seil.distStart + self.seil.distEnd;
		
end;	
	

function Hilken18000ZMK:delete()
end;

function Hilken18000ZMK:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hilken18000ZMK:keyEvent(unicode, sym, modifier, isDown)
end;

function Hilken18000ZMK:update(dt)

	--if self:getIsActive() then		
		if self.spring.target ~= nil then		
			local ax, ay, az = getWorldTranslation(self.spring.node);
			local bx, by, bz = getWorldTranslation(self.spring.target);
			local x, y, z = worldDirectionToLocal(getParent(self.spring.node), bx-ax, by-ay, bz-az);
			
			local upX, upY, upZ = 0,1,0;
			if math.abs(y) > 0.99*Utils.vector3Length(x, y, z) then
				-- direction and up is parallel
				upY = 0;
				if y > 0 then
					upZ = 1;
				else
					upZ = -1;
				end;
			end;
			
			setDirection(self.spring.node, x, y, z, upX, upY, upZ);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.spring.part, 0, 0, distance-self.spring.distance);		
		end;		
	--end;
	
	
		if self.seil.target ~= nil then		
			local ax, ay, az = getWorldTranslation(self.seil.node);
			local bx, by, bz = getWorldTranslation(self.seil.target);
			local x, y, z = worldDirectionToLocal(getParent(self.seil.node), bx-ax, by-ay, bz-az);
			
			local upX, upY, upZ = 0,1,0;
			if math.abs(y) > 0.99*Utils.vector3Length(x, y, z) then
				-- direction and up is parallel
				upY = 0;
				if y > 0 then
					upZ = 1;
				else
					upZ = -1;
				end;
			end;
			
			setDirection(self.seil.node, x, y, z, upX, upY, upZ);
			
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			
			setTranslation(self.seil.parts[2], 0, 0, self.seil.distStart + (distance-self.seil.dist)/3.0);		
			setTranslation(self.seil.parts[3], 0, 0, (distance-self.seil.dist)/3.0 * self.seil.dist2/self.seil.dist);		
			setTranslation(self.seil.parts[4], 0, 0, (distance-self.seil.dist)/3.0 * (self.seil.dist2/self.seil.dist)*(self.seil.dist2/self.seil.dist));	
			
		end;		
	
end;

function Hilken18000ZMK:draw()
end;

function Hilken18000ZMK:onAttach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-65), Utils.degToRad(65));	
end;

function Hilken18000ZMK:onDetach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-8), Utils.degToRad(8));	
end;

function Hilken18000ZMK:onLeave()
end;

function Hilken18000ZMK:onDeactivate()
end;

function Hilken18000ZMK:onDeactivateSounds()
end;


