--
-- kopaczka Z609
-- author: Burner
-- date: 13.02.2012
--

Z609 = {};

function Z609.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Z609:load(xmlFile)
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.wasToFast = false;
	self.isTurnedOn = false;

	self.potatoParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.potatoParticleSystems.potatoParticleSystem(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local potatoParticleSystem = {};
			potatoParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, potatoParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.potatoParticleSystems, potatoParticleSystem);
		end;
		i = i+1;
	end;

	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
	self.soundTest = workSound;
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	
	local workAISound = getXMLString(xmlFile, "vehicle.workAISound#file");
		if workAISound ~= nil and workAISound ~= "" then
		workAISound = Utils.getFilename(workAISound, self.baseDirectory);
		self.workAISoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workAISound#pitchOffset"), 0);
		self.workAISoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workAISound#radius"), 50);
		self.workAISoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workAISound#innerRadius"), 10);
		self.workAISoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workAISound#volume"), 1);
		self.workAISound = createAudioSource("workAISound", workAISound, self.workAISoundRadius, self.workAISoundInnerRadius, self.workAISoundVolume, 0);
		link(self.components[1].node, self.workAISound);
		setVisibility(self.workAISound, false);
	end;

	self.speedRotatingParts = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.speedRotatingParts.speedRotatingPart(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		if index == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
			if entry.rotationSpeedScale == nil then
				entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
			end;
	
			table.insert(self.speedRotatingParts, entry);
		end;
		i = i+1;
	end;
	
	self.UVScrollParts = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.UVScrollParts.UVScrollPart(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.UVScrollParts, {node=node, speed=speed});
        end;
        i = i +1;
    end;
	
	self.extraRollNodes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.extraRolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#speed"));
        if rollNode ~= nil then
			local speed = {};
			speed.x = Utils.getNoNil(x, 0);
			speed.y = Utils.getNoNil(y, 0);
			speed.z = Utils.getNoNil(z, 0);
            table.insert(self.extraRollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
	
	local numDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dropAreas#count"), 0);
    self.dropAreas = {}
    for i=1, numDropAreas do
        self.dropAreas[i] = {};
        local areanamei = string.format("vehicle.dropAreas.dropArea%d", i);
        self.dropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.dropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.dropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	self.powerShaftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#rootNode"));
	
	self.supportWheelMode = 1;
	
	self.psActive = false;
end;

function Z609:readStream(streamId, connection)
    self:setIsTurnedOn(streamReadBool(streamId), true);
end;

function Z609:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isTurnedOn);
end;

function Z609:update(dt)
	if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self:setIsTurnedOn(not self.isTurnedOn);
        end;
    end;
	
	self.wasToFast = false;
	if self:getIsActive() then
		if self:isLowered(false) then
			for k,v in pairs(self.speedRotatingParts) do
				rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * -self.movingDirection * dt, 0, 0);
			end;
		end;
		if self.isTurnedOn then
			for _, rollNode in pairs(self.extraRollNodes) do
				rotate(rollNode.node, -dt*rollNode.speed.x, -dt*rollNode.speed.y, -dt*rollNode.speed.z);
			end;
			if self.isClient then
				if not self.workSoundEnabled and self:getIsActiveForSound() then
					playSample(self.workSound, 0, self.workSoundVolume, 0);
					setSamplePitch(self.workSound, self.workSoundPitchOffset);
					self.workSoundEnabled = true;
				end;
			end;
			if self:isLowered(false) then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 20;
				if not toFast then
					local area = 0;
					for k, cuttingArea in pairs(self.cuttingAreas) do
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
						Utils.updateFruitCutShortArea(FruitUtil.FRUITTYPE_POTATO, x, z, x1, z1, x2, z2, 1);									
						local area = Utils.cutFruitArea(FruitUtil.FRUITTYPE_POTATO, x, z, x1, z1, x2, z2, 1);
						if area > 0 then
							for k, dropArea in pairs(self.dropAreas) do
								local xx,yy,zz = getWorldTranslation(dropArea.start);
								local xx1,yy1,zz1 = getWorldTranslation(dropArea.width);
								local xx2,yy2,zz2 = getWorldTranslation(dropArea.height);
								Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_POTATO, xx, zz, xx1, zz1, xx2, zz2, 1, true);
							end;
							self.psActive = true;
						else
							self.psActive = false;
						end;
					end;
				else
					self.psActive = false;
				end;
				self.wasToFast = toFast;
			else
				self.psActive = false;
			end;
		else
			self.psActive = false;
			if self.isClient then
				if self.workSoundEnabled then
					stopSample(self.workSound);
					self.workSoundEnabled = false;
				end;
			end;
		end;
	end;
	for k, potatoParticleSystem in pairs(self.potatoParticleSystems) do
		Utils.setEmittingState(potatoParticleSystem.particleSystem, self.psActive);
	end;

	if self.powerShaftNode ~= nil and self.isTurnedOn then
		rotate(self.powerShaftNode, 0, 0, 0.8);
	end;
	
	if self.isTurnedOn and not self:getIsActiveForSound() then
		if self.workAISound ~= nil then
			setVisibility(self.workAISound, true);
		end;
	else
		if self.workAISound ~= nil then
			setVisibility(self.workAISound, false);
		end;		
	end;
end;

function Z609:updateTick(dt)
end;

function Z609:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z609:keyEvent(unicode, sym, modifier, isDown)
end;

function Z609:draw()
	if self.isTurnedOn then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
	end;
	if self.wasToFast then
		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
	end;
end;

function Z609:onAttach()
end; 	

function Z609:onDetach()
	self.isTurnedOn = false;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;

	for k, potatoParticleSystem in pairs(self.potatoParticleSystems) do
		Utils.setEmittingState(potatoParticleSystem.particleSystem, false);
	end;

	self.psActive = false;
    for _, part in pairs(self.UVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
end;

function Z609:onDeactivate()
    self.isTurnedOn = false;
	for k, potatoParticleSystem in pairs(self.potatoParticleSystems) do
		Utils.setEmittingState(potatoParticleSystem.particleSystem, false);
	end;
	self.psActive = false;
    for _, part in pairs(self.UVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function Z609:delete()
	if self.workSoundEnabled then
		delete(self.workSound);
		self.workSoundEnabled = false;
	end;
	for k, potatoParticleSystem in pairs(self.potatoParticleSystems) do
		Utils.deleteParticleSystem(potatoParticleSystem.particleSystem);
	end;
end;

function Z609:onLeave()
	for k, potatoParticleSystem in pairs(self.potatoParticleSystems) do
		Utils.setEmittingState(potatoParticleSystem.particleSystem, false);
	end;
	self.psActive = false;
    for _, part in pairs(self.UVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function Z609:setIsTurnedOn(turnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
    self.isTurnedOn = turnedOn;
	for _, part in pairs(self.UVScrollParts) do
		if self.isTurnedOn then
			setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
		else
			setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
    end;
end;