MountChopperEvent = {};
MountChopperEvent_mt = Class(MountChopperEvent, Event);

InitEventClass(MountChopperEvent, "MountChopperEvent");

function MountChopperEvent:emptyNew()
    local self = Event:new(MountChopperEvent_mt);
    self.className="MountChopperEvent";
    return self;
end;

function MountChopperEvent:new(vehicle, chopperMountState)
    local self = MountChopperEvent:emptyNew()
    self.vehicle = vehicle;
	self.chopperMountState = chopperMountState;
    return self;
end;

function MountChopperEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.chopperMountState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MountChopperEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.chopperMountState);
end;

function MountChopperEvent:run(connection)   
	self.vehicle:mountChopper(self.chopperMountState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MountChopperEvent:new(self.vehicle, self.chopperMountState), nil, connection, self.vehicle);
    end;
end;

function MountChopperEvent.sendEvent(vehicle, chopperMountState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MountChopperEvent:new(vehicle, chopperMountState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MountChopperEvent:new(vehicle, chopperMountState));
		end;
	end;
end;

EmptyGrainTankEvent = {};
EmptyGrainTankEvent_mt = Class(EmptyGrainTankEvent, Event);

InitEventClass(EmptyGrainTankEvent, "EmptyGrainTankEvent");

function EmptyGrainTankEvent:emptyNew()
    local self = Event:new(EmptyGrainTankEvent_mt);
    self.className="EmptyGrainTankEvent";
    return self;
end;

function EmptyGrainTankEvent:new(vehicle, emptyGrainTankState)
    local self = EmptyGrainTankEvent:emptyNew()
    self.vehicle = vehicle;
	self.emptyGrainTankState = emptyGrainTankState;
    return self;
end;

function EmptyGrainTankEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.emptyGrainTankState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function EmptyGrainTankEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.emptyGrainTankState);
end;

function EmptyGrainTankEvent:run(connection)   
	self.vehicle:emptyGrainTank(self.emptyGrainTankState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(EmptyGrainTankEvent:new(self.vehicle, self.emptyGrainTankState), nil, connection, self.vehicle);
    end;
end;

function EmptyGrainTankEvent.sendEvent(vehicle, emptyGrainTankState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(EmptyGrainTankEvent:new(vehicle, emptyGrainTankState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(EmptyGrainTankEvent:new(vehicle, emptyGrainTankState));
		end;
	end;
end;

ActivateChopperEvent = {};
ActivateChopperEvent_mt = Class(ActivateChopperEvent, Event);

InitEventClass(ActivateChopperEvent, "ActivateChopperEvent");

function ActivateChopperEvent:emptyNew()
    local self = Event:new(ActivateChopperEvent_mt);
    self.className="ActivateChopperEvent";
    return self;
end;

function ActivateChopperEvent:new(vehicle, chopperState)
    local self = ActivateChopperEvent:emptyNew()
    self.vehicle = vehicle;
	self.chopperState = chopperState;
    return self;
end;

function ActivateChopperEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.chopperState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ActivateChopperEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.chopperState);
end;

function ActivateChopperEvent:run(connection)   
	self.vehicle:activateChopper(self.chopperState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ActivateChopperEvent:new(self.vehicle, self.chopperState), nil, connection, self.vehicle);
    end;
end;

function ActivateChopperEvent.sendEvent(vehicle, chopperState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ActivateChopperEvent:new(vehicle, chopperState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ActivateChopperEvent:new(vehicle, chopperState));
		end;
	end;
end;

ActivateCutterEvent = {};
ActivateCutterEvent_mt = Class(ActivateCutterEvent, Event);

InitEventClass(ActivateCutterEvent, "ActivateCutterEvent");

function ActivateCutterEvent:emptyNew()
    local self = Event:new(ActivateCutterEvent_mt);
    self.className="ActivateCutterEvent";
    return self;
end;

function ActivateCutterEvent:new(vehicle, cutterState)
    local self = ActivateCutterEvent:emptyNew()
    self.vehicle = vehicle;
	self.cutterState = cutterState;
    return self;
end;

function ActivateCutterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.cutterState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ActivateCutterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.cutterState);
end;

function ActivateCutterEvent:run(connection)   
	self.vehicle:activateCutter(self.cutterState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ActivateCutterEvent:new(self.vehicle, self.cutterState), nil, connection, self.vehicle);
    end;
end;

function ActivateCutterEvent.sendEvent(vehicle, cutterState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ActivateCutterEvent:new(vehicle, cutterState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ActivateCutterEvent:new(vehicle, cutterState));
		end;
	end;
end;

AdjustReelSpeedEvent = {};
AdjustReelSpeedEvent_mt = Class(AdjustReelSpeedEvent, Event);

InitEventClass(AdjustReelSpeedEvent, "AdjustReelSpeedEvent");

function AdjustReelSpeedEvent:emptyNew()
    local self = Event:new(AdjustReelSpeedEvent_mt);
    self.className="AdjustReelSpeedEvent";
    return self;
end;

function AdjustReelSpeedEvent:new(vehicle, reelSpeedValue)
    local self = AdjustReelSpeedEvent:emptyNew()
    self.vehicle = vehicle;
	self.reelSpeedValue = reelSpeedValue;
    return self;
end;

function AdjustReelSpeedEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.reelSpeedValue = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function AdjustReelSpeedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.reelSpeedValue);
end;

function AdjustReelSpeedEvent:run(connection)   
	self.vehicle:adjustReelSpeed(self.reelSpeedValue, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(AdjustReelSpeedEvent:new(self.vehicle, self.reelSpeedValue), nil, connection, self.vehicle);
    end;
end;

function AdjustReelSpeedEvent.sendEvent(vehicle, reelSpeedValue, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AdjustReelSpeedEvent:new(vehicle, reelSpeedValue), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(AdjustReelSpeedEvent:new(vehicle, reelSpeedValue));
		end;
	end;
end;

LockCutterAttacherEvent = {};
LockCutterAttacherEvent_mt = Class(LockCutterAttacherEvent, Event);

InitEventClass(LockCutterAttacherEvent, "LockCutterAttacherEvent");

function LockCutterAttacherEvent:emptyNew()
    local self = Event:new(LockCutterAttacherEvent_mt);
    self.className="LockCutterAttacherEvent";
    return self;
end;

function LockCutterAttacherEvent:new(vehicle, attachCutterUpState)
    local self = LockCutterAttacherEvent:emptyNew()
    self.vehicle = vehicle;
	self.attachCutterUpState = attachCutterUpState;
    return self;
end;

function LockCutterAttacherEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.attachCutterUpState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function LockCutterAttacherEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.attachCutterUpState);
end;

function LockCutterAttacherEvent:run(connection)   
	self.vehicle:lockCutterAttacher(self.attachCutterUpState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(LockCutterAttacherEvent:new(self.vehicle, self.attachCutterUpState), nil, connection, self.vehicle);
    end;
end;

function LockCutterAttacherEvent.sendEvent(vehicle, attachCutterUpState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(LockCutterAttacherEvent:new(vehicle, attachCutterUpState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(LockCutterAttacherEvent:new(vehicle, attachCutterUpState));
		end;
	end;
end;