--
-- Zgrabiarko-przetrzsarka Z234
-- author: Burner
-- date: 04.05.2012
--
 
Z234 = {};

function Z234.prerequisitesPresent(specializations)
   return true;
end;

function Z234:load(xmlFile)
	self.setTedderActive = SpecializationUtil.callSpecializationsFunction("setTedderActive");
	self.tedderActive = false;
	
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.isTurnedOn = false;
	
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	self.accumulatedCuttingAreaValues = {};
	for i=1, numCuttingAreas do
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
		self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
		self.accumulatedCuttingAreaValues[i] = 0;
	end;
	
	local numTedderDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.tedderDropAreas#count"), 0);
	if numTedderDropAreas ~= table.getn(self.cuttingAreas) then
		print("Warning: Number of cutting areas and drop areas should be equal");
	end;
	self.tedderDropAreas = {}
	for i=1, numTedderDropAreas do
		self.tedderDropAreas[i] = {};
		local areanamei = string.format("vehicle.tedderDropAreas.tedderDropArea%d", i);
		self.tedderDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.tedderDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.tedderDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
	if numWindrowerDropAreas == 0 then
		print("Warning: No drop areas specified in '"..self.configFileName.."'");
	else
		if numWindrowerDropAreas ~= 1 and numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
			print("Warning: Number of cutting areas and drop areas should be equal in '"..self.configFileName.."'");
		end;
	end;
	self.windrowerDropAreas = {}
	for i=1, numWindrowerDropAreas do
		self.windrowerDropAreas[i] = {};
		local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
		self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	
	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
	self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
	if self.groundReferenceNode == nil then
		self.groundReferenceNode = self.components[1].node;
	end;
	
	self.wasToFast = false;
	
	self.tedderParticleSystem = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.tedderParticleSystems.tedderParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
		StaticParticleSystem.loadParticleSystem(xmlFile, self.tedderParticleSystem, namei, nodei, false, nil, self.baseDirectory);
		Utils.setEmittingState(self.tedderParticleSystem,false);
		self.particleSystemdisableTime = 0;
		i = i +1;		
    end;
	
	self.windrowerParticleSystem = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.windrowerParticleSystems.windrowerParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
		StaticParticleSystem.loadParticleSystem(xmlFile, self.windrowerParticleSystem, namei, nodei, false, nil, self.baseDirectory);
		Utils.setEmittingState(self.windrowerParticleSystem,false);
		self.particleSystemdisableTime = 0;
		i = i +1;		
    end;
	
	self.tedderPsActive = false;
	self.windrowerPsActive = false;
	
	if self.isClient then
		local tedderSound = getXMLString(xmlFile, "vehicle.tedderSound#file");
		if tedderSound ~= nil and tedderSound ~= "" then
			tedderSound = Utils.getFilename(tedderSound, self.baseDirectory);
			self.tedderSound = createSample("tedderSound");
			self.tedderSoundEnabled = false;
			loadSample(self.tedderSound, tedderSound, false);
			self.tedderSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tedderSound#pitchOffset"), 1);
			self.tedderSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tedderSound#volume"), 1.0);
		end;
	end;
end;

function Z234:readStream(streamId, connection)
	self:setTedderActive(streamReadBool(streamId), true);
	self:setIsTurnedOn(streamReadBool(streamId), true);
end;

function Z234:writeStream(streamId, connection)
	streamWriteBool(streamId, self.tedderActive);
	streamWriteBool(streamId, self.isTurnedOn);
end;

function Z234:delete()
	Utils.deleteParticleSystem(self.tedderParticleSystem);
	Utils.deleteParticleSystem(self.windrowerParticleSystem);
	if self.tedderSound ~= nil then
		delete(self.tedderSound);
	end;
end;

function Z234:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z234:keyEvent(unicode, sym, modifier, isDown)
end;

function Z234:update(dt)	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.Z234_Activate_Tedder) then
			self:setTedderActive(not self.tedderActive);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:setIsTurnedOn(not self.isTurnedOn);
		end;
	end;
	
	if self.tedderActive then
		setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
	else
		setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale/2);
	end;
	
	self.wasToFast = false;
	
	if self:getIsActive() then
		self.tedderPsActive = false;
		self.windrowerPsActive = false;
		
		local hasGroundContact = false;
		local x,y,z = getWorldTranslation(self.groundReferenceNode);
		local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
		if terrainHeight+self.groundReferenceThreshold >= y then
			hasGroundContact = true;
		end;
		if hasGroundContact then
			if self.isTurnedOn then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
				if not toFast then
					for k, cuttingArea in pairs(self.cuttingAreas) do
						local x,y,z = getWorldTranslation(cuttingArea.start);
						local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
						local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
						
						if self.tedderActive then
							local dropArea = self.tedderDropAreas[k];
							local dx,dy,dz = getWorldTranslation(dropArea.start);
							local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
							local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
								
							local ratio = g_currentMission.windrowCutLongRatio;
							local area = 0;
							area = area + Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);
							area = area + Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 0);
							area = area + Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);
							area = area + Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 0);
							if area > 0 then
								-- now that we removed the cut long and windrow, maybe there is some hidden drygrass to grow (set it to growth state 1 if there is some)
								Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
								local old, total = Utils.getFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
								area = area + old;
								local value = area / total;
								if value < 1 and value > 0.1 then
									value = 1;
								else
									value = math.floor(value + 0.6); -- round, biased to the bigger value
								end;
								value = math.min(value, g_currentMission.maxCutLongValue);
								if value >= 1 then
									-- switch all dry grass to grass, and then destroy everything that is not grass
									Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
									Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);
									-- now place the cut long, this will switch back the grass to dry grass
									Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2, value, true, false);
								end;
								self.tedderPsActive = true;
							end;
						else
							local numDropAreas = table.getn(self.windrowerDropAreas);
							local numAreas = table.getn(self.cuttingAreas);
							local sum = 0;
							local fruitType = FruitUtil.FRUITTYPE_GRASS;					
							local fruitTypeFix = false;

							local ratio = g_currentMission.windrowCutLongRatio;

							if not fruitTypeFix then
								fruitType = FruitUtil.FRUITTYPE_GRASS;
							end;

							local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
							area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*ratio;
										
							if area == 0 and not fruitTypeFix then
								fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
								area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
								area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0)*ratio;
							end;

							if area > 0 then
								fruitTypeFix = true;
								Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1);
							end;

							if numDropAreas >= numAreas then
								if area > 0 then
									local dropArea = self.windrowerDropAreas[k];
									local x,y,z = getWorldTranslation(dropArea.start);
									local x1,y1,z1 = getWorldTranslation(dropArea.width);
									local x2,y2,z2 = getWorldTranslation(dropArea.height);
									local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
									area = area + old;
									local value = area / total;
									if value < 1 and value > 0.08 then
										value = 1;
									else
										value = math.floor(value + 0.6); -- round, biased to the bigger value
									end;
									if value >= 1 then
										value = math.min(value, g_currentMission.maxWindrowValue);
										Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true, false);
									end;
									self.windrowerPsActive = true;
								end;
							else
								sum = sum + area;
							end;
							
							if sum > 0 and numDropAreas > 0 then
								local dropArea = self.windrowerDropAreas[k];
								local x,y,z = getWorldTranslation(dropArea.start);
								local x1,y1,z1 = getWorldTranslation(dropArea.width);
								local x2,y2,z2 = getWorldTranslation(dropArea.height);
								local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
								sum = sum + old;
								local value = math.floor(sum / total + 0.7); -- round, biased to the bigger value
								if value >= 1 then
									value = math.min(value, g_currentMission.maxWindrowValue);
									Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true, false);
								end;							
							end;
						end;
					end;
				end;
				self.wasToFast = toFast;
			end;
		end;
		Utils.setEmittingState(self.tedderParticleSystem, self.tedderPsActive);
		Utils.setEmittingState(self.windrowerParticleSystem, self.windrowerPsActive);
		
		if self.isClient and self.isTurnedOn then
			if not self.tedderSoundEnabled and self:getIsActiveForSound() then
				playSample(self.tedderSound, 0, self.tedderSoundVolume, 0);
				setSamplePitch(self.tedderSound, self.tedderSoundPitchOffset);
				self.tedderSoundEnabled = true;
			end;
		end;
	end;
end;

function Z234:updateTick(dt)
end;

function Z234:onDetach()
	if self.deactivateOnDetach then
		Z234.onDeactivate(self);
	else
		Z234.onDeactivateSounds(self)
	end;
end;

function Z234:onDeactivate()
	Z234.onDeactivateSounds(self)
	self.isTurnedOn = false;
	Utils.setEmittingState(self.tedderParticleSystem, false);
	Utils.setEmittingState(self.windrowerParticleSystem, false);
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
end

function Z234:onLeave()
	if self.deactivateOnLeave then
		Z234.onDeactivate(self);
	else
		Z234.onDeactivateSounds(self)
	end;
end;

function Z234:onDeactivateSounds()
	if self.tedderSoundEnabled then
		stopSample(self.tedderSound);
		self.tedderSoundEnabled = false;
	end;
end;

function Z234:draw()
	if self.isClient then
		if self.isTurnedOn then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
		end;
		if self.wasToFast then
			g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
		end;
		if self.tedderActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("Z234_Activate_Windrower"), InputBinding.Z234_Activate_Tedder);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Z234_Activate_Tedder"), InputBinding.Z234_Activate_Tedder);
		end;
	end;
end;

function Z234:setTedderActive(tedderActive, noEventSend)
	SetTedderActiveEvent.sendEvent(self, isTurnedOn, noEventSend)
	self.tedderActive = tedderActive;
end;

function Z234:setIsTurnedOn(isTurnedOn, noEventSend)
	SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend)
	self.isTurnedOn = isTurnedOn;

	if not isTurnedOn then
		if self.tedderSoundEnabled then
			stopSample(self.tedderSound);
			self.tedderSoundEnabled = false;
		end;
	end;

	if not isTurnedOn then
		if self.windrowerSoundEnabled then
			stopSample(self.windrowerSound);
			self.windrowerSoundEnabled = false;
		end;
		if self.animationEnabled then
			disableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = false;
		end;
	else
		if not self.animationEnabled then
			enableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = true;
		end;
	end;
end;

-- events
SetTedderActiveEvent = {};
SetTedderActiveEvent_mt = Class(SetTedderActiveEvent, Event);

InitEventClass(SetTedderActiveEvent, "SetTedderActiveEvent");

function SetTedderActiveEvent:emptyNew()
    local self = Event:new(SetTedderActiveEvent_mt);
    self.className="SetTedderActiveEvent";
    return self;
end;

function SetTedderActiveEvent:new(vehicle, tedderState)
    local self = SetTedderActiveEvent:emptyNew()
    self.vehicle = vehicle;
	self.tedderState = tedderState;
    return self;
end;

function SetTedderActiveEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.tedderState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTedderActiveEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.tedderState);
end;

function SetTedderActiveEvent:run(connection)   
	self.vehicle:setTedderActive(self.tedderState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTedderActiveEvent:new(self.vehicle, self.tedderState), nil, connection, self.vehicle);
    end;
end;

function SetTedderActiveEvent.sendEvent(vehicle, tedderState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTedderActiveEvent:new(vehicle, tedderState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTedderActiveEvent:new(vehicle, tedderState));
		end;
	end;
end;