--
-- fruitTypeWeed
-- This is the fruitTypeWeed
--
-- M@D Author  Headshot XXL
-- M@D date 19.06.2010
--
-- LS11: Burner
-- date: 28.11.2011
--

-- register new fruittype "weed"
FruitUtil.registerFruitType("weed", false, false, false, 1, 0.1, 0.005, 0, 0, Utils.getFilename("fruitTypeWeed.png", g_currentModDirectory));
FruitUtil.registerFruitType("weedsprayed", false, false, false, 1, 0.1, 0.005, 0, 0, Utils.getFilename("fruitTypeWeed.png", g_currentModDirectory));
print("register fruitType: weed");

-- sprayer fix
local sprayerUpdateTick = Sprayer.updateTick
Sprayer.updateTick = function(self, dt)
	sprayerUpdateTick(self, dt)
	if self.isTurnedOn then
		if self.fillLevel > 0 and self.currentFillType == Fillable.FILLTYPE_FERTILIZER then
			for i = 1, table.getn(self.cuttingAreas) do
				local x, y, z = getWorldTranslation(self.cuttingAreas[i].start)
				local x1, y1, z1 = getWorldTranslation(self.cuttingAreas[i].width)
				local x2, y2, z2 = getWorldTranslation(self.cuttingAreas[i].height)
				Utils.removeWeedArea(x, z, x1, z1, x2, z2);
			end;
		end;
	end;
end;

-- foliage utils fix
Utils.cutFruitArea = function(l_4_0, l_4_1, l_4_2, l_4_3, l_4_4, l_4_5, l_4_6)
	local ids = g_currentMission.fruits[l_4_0]
	if ids == nil or ids.id == 0 then
		return 0
	end
	local id = ids.id
	local value = 0
	local desc = FruitUtil.fruitIndexToDesc[l_4_0]
	if not desc.needsSeeding then
		value = 1
	end
	setDensityReturnValueShift(id, -1)
	setDensityMaskParams(id, "greater", desc.minHarvestingGrowthState)
	local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, l_4_1, l_4_2, l_4_3, l_4_4, l_4_5, l_4_6)
	local area = setDensityMaskedParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, id, 0, 3, value)
	setDensityReturnValueShift(id, 0)
	setDensityMaskParams(id, "greater", 0)
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local weed = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, 0, l_4_1, l_4_2, l_4_3, l_4_4, l_4_5, l_4_6)
		if weed > 0 then
			area = area * 0.8
		end;
	end;
	return area
end

Utils.updateFruitCutShortArea = function(l_5_0, l_5_1, l_5_2, l_5_3, l_5_4, l_5_5, l_5_6, l_5_7)
	local ids = g_currentMission.fruits[l_5_0]
	if ids == nil or ids.cutShortId == 0 then
		return 0
	end
	local desc = FruitUtil.fruitIndexToDesc[l_5_0]
	local cutShortId = ids.cutShortId
	local maskId = ids.id
	local numMaskChannels = 3
	if l_5_7 < 0.1 then
		maskId = cutShortId
		numMaskChannels = 1
	elseif maskId == 0 then
		return 0
	end
	setDensityMaskParams(cutShortId, "greater", desc.minHarvestingGrowthState)
	local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(cutShortId, l_5_1, l_5_2, l_5_3, l_5_4, l_5_5, l_5_6)
	setDensityMaskedParallelogram(cutShortId, x, z, widthX, widthZ, heightX, heightZ, 0, 1, maskId, 0, numMaskChannels, l_5_7)
	setDensityMaskParams(cutShortId, "greater", 0)
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local weed = Utils.getDensity(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, 0, l_5_1, l_5_2, l_5_3, l_5_4, l_5_5, l_5_6)
		if weed > 0 then
			setDensityParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, 0)
		end
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0, 1, g_currentMission.terrainDetailId, g_currentMission.sowingChannel, 1, 1)
	end;
end

Utils.removeWeedArea = function(l_6_0, l_6_1, l_6_2, l_6_3, l_6_4, l_6_5)
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, l_6_0, l_6_1, l_6_2, l_6_3, l_6_4, l_6_5)
		setDensityParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, 0)
	end;
end

local updateCultivatorArea = Utils.updateCultivatorArea;
Utils.updateCultivatorArea = function(l_7_0, l_7_1, l_7_2, l_7_3, l_7_4, l_7_5, limitToField)
	updateCultivatorArea(l_7_0, l_7_1, l_7_2, l_7_3, l_7_4, l_7_5, limitToField)
	local detailId = g_currentMission.terrainDetailId;
	local cultiId = g_currentMission.cultivatorChannel;
	local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(detailId, l_7_0, l_7_1, l_7_2, l_7_3, l_7_4, l_7_5)
	for index, entry in pairs(g_currentMission.fruits) do
		local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(entry.id, l_7_0, l_7_1, l_7_2, l_7_3, l_7_4, l_7_5)
		if entry.id ~= 0 then
			setDensityMaskedParallelogram(entry.id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.terrainDetailId, 0, 3, 0)
		end;
		if entry.windrowId ~= 0 then
			setDensityMaskedParallelogram(entry.windrowId, x, z, widthX, widthZ, heightX, heightZ, 0, 2, g_currentMission.terrainDetailId, 0, 3, 0)
		end
		if entry.cutShortId ~= 0 then
			setDensityMaskedParallelogram(entry.cutShortId, x, z, widthX, widthZ, heightX, heightZ, 0, 1, g_currentMission.terrainDetailId, 0, 3, 0)
		end
		if entry.cutLongId ~= 0 then
			setDensityMaskedParallelogram(entry.cutLongId, x, z, widthX, widthZ, heightX, heightZ, 0, 2, g_currentMission.terrainDetailId, 0, 3, 0)
		end
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0, 1, detailId, cultiId, 1, 1)
	end;
end

local updatePloughArea = Utils.updatePloughArea;
Utils.updatePloughArea = function(l_8_0, l_8_1, l_8_2, l_8_3, l_8_4, l_8_5, limitToField)
	updatePloughArea(l_8_0, l_8_1, l_8_2, l_8_3, l_8_4, l_8_5, limitToField)
	local detailId = g_currentMission.terrainDetailId;
	local ploughId = g_currentMission.ploughChannel;
	local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(detailId, l_8_0, l_8_1, l_8_2, l_8_3, l_8_4, l_8_5)
	for index, entry in pairs(g_currentMission.fruits) do
		local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(entry.id, l_8_0, l_8_1, l_8_2, l_8_3, l_8_4, l_8_5)
		if entry.id ~= 0 then
			setDensityMaskedParallelogram(entry.id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.terrainDetailId, 0, 3, 0)
		end;
		if entry.windrowId ~= 0 then
			setDensityMaskedParallelogram(entry.windrowId, x, z, widthX, widthZ, heightX, heightZ, 0, 2, g_currentMission.terrainDetailId, 0, 3, 0)
		end
		if entry.cutShortId ~= 0 then
			setDensityMaskedParallelogram(entry.cutShortId, x, z, widthX, widthZ, heightX, heightZ, 0, 1, g_currentMission.terrainDetailId, 0, 3, 0)
		end
		if entry.cutLongId ~= 0 then
			setDensityMaskedParallelogram(entry.cutLongId, x, z, widthX, widthZ, heightX, heightZ, 0, 2, g_currentMission.terrainDetailId, 0, 3, 0)
		end
	end;
	if g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED] ~= nil then
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_WEED].id, x, z, widthX, widthZ, heightX, heightZ, 0, 1, detailId, ploughId, 1, 1)
	end;
end