--
--
--


-- Register fruits
function RegisterFruits()
	local fruitList = {};

    -- Notes:
    -- "type" is not accurate. It were an attempt to group the fruits, so they may be easier selected at silos/sell-points.
    -- "fruitName" must be the same as in the FoliageSubLayers.
    table.insert(fruitList, {type="flower"  ,fruitName="luzerne"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.198 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="flower"  ,fruitName="artichoke"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.211 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="flower"  ,fruitName="aubergine"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.48 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=2.9} );
    table.insert(fruitList, {type="root"  ,fruitName="betterave"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.175 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="fruit"  ,fruitName="wirsingkohl"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.21 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="fruit"   ,fruitName="blumkohl"        ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.189 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=0.9} );
    table.insert(fruitList, {type="root"    ,fruitName="carrot"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=3 ,pricePerLiter=0.197 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="flower"  ,fruitName="cotton"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.08 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=0.5} );
    table.insert(fruitList, {type="fruit"  ,fruitName="melone"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.142 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=0.9} );
    table.insert(fruitList, {type="fruit"   ,fruitName="erbse"        ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.577 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="flower"  ,fruitName="ananas"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.15 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="root"    ,fruitName="potato"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=1 ,pricePerLiter=0.276  ,literPerQm=4 ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="fruit"  ,fruitName="kuerbis"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.29 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="root" ,fruitName="radieschen"        ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.10 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=0.9} );
    table.insert(fruitList, {type="grain"   ,fruitName="rye"            ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.971 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=3.9} );
    table.insert(fruitList, {type="flower"  ,fruitName="erdbeeren"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.12 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.9} );
    table.insert(fruitList, {type="fruit"   ,fruitName="soybean"        ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.699 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=2.9} );
    table.insert(fruitList, {type="flower"  ,fruitName="sunflower"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=1.553 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="fruit"   ,fruitName="tee"        ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.35 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=1.5} );
    table.insert(fruitList, {type="fruit"  ,fruitName="tomate"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.511 ,literPerQm=4   ,seedUsagePerQm=0.10    ,seedPricePerLiter=3.9} );

    --
    -- Can not seed or harvest! Only for transport!
    -- Make sure that 'allowsSeeding' is FALSE. If not, they would also show up in the sowing-machine!
    table.insert(fruitList, {type="none"    ,fruitName="manure"         ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="liquidManure"   ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="fertilizer"     ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="milk"           ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="water"          ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    table.insert(fruitList, {type="none"    ,fruitName="cow"          ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );


    --
    print(string.format("Registering %d extra fruits...", table.getn(fruitList)));
    for i=1, table.getn(fruitList) do
        local filename = "FruitMaps/images/".. fruitList[i].fruitName .."Hud.png";
        local hudFile = Utils.getFilename(filename, g_currentModDirectory);
        FruitUtil.registerFruitType(
             fruitList[i].fruitName                 -- string fruitName
            ,fruitList[i].needsSeeding              -- bool needsSeeding    (ARGH! I spent 3-4 days trying to find out why the new crop autogrows. Then I noticed an 's' were missing, so 'needSeeding' returned nil.)
            ,fruitList[i].allowsSeeding             -- bool allowsSeeding
            ,fruitList[i].hasStraw                  -- bool hasStraw
            ,fruitList[i].minHarvestingGrowthState  -- int minHarvestingGrowthState
            ,fruitList[i].pricePerLiter             -- float pricePerLiter
            ,fruitList[i].literPerQm                -- float literPerQm
            ,fruitList[i].seedUsagePerQm            -- float seedUsagePerQm
            ,fruitList[i].seedPricePerLiter         -- float seedPricePerLiter
            ,hudFile                                -- file hudFruitOverlayFilename
        );
    end;
end;
RegisterFruits();

--
--
--
local origSowingMachineLoad = SowingMachine.load;
SowingMachine.load = function(self, xmlFile)
    if origSowingMachineLoad ~= nil then
        origSowingMachineLoad(self, xmlFile);
    end;

    --
    local msg = "Info. Added seeds to '".. Utils.getNoNil(self.name, "SowingMachine") .."': ";
    self.seeds = {};
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        -- Check if FruitType have a FoliageSubLayer-/TerrainId.
        local terrainId = 0;
        if g_currentMission.fruits[fruitType.index] ~= nil then
            terrainId = g_currentMission.fruits[fruitType.index].id;
        end;
        -- Only add FruitType if its allowed to be seeded, AND have a FoliageSubLayer-/TerrainId.
        if fruitType.allowsSeeding and terrainId > 0 then
            table.insert(self.seeds, fruitType.index);
            msg = msg .. FruitUtil.fruitIndexToDesc[ fruitType.index ].name .." ";
        end;
    end;
    print(msg);
    -- Sort the seedable fruits by generic-name.
    table.sort(self.seeds, function(l,r) return (FruitUtil.fruitIndexToDesc[l].name < FruitUtil.fruitIndexToDesc[r].name); end);
end;
