--
-- @title	Fuel Adjustments v1.0
-- @desc	Allows adjustment of Fuel Prices and Idle Fuel Consumption
-- 
-- @author	TwistedGA
-- @date	03/17/2012
--
-- You may edit the values of "g_fuelPricePerGallon" and "g_fuelIdleUsagePercent", and release for Multiplayer. 
-- You may not edit the values found nested within any of the functions for public release without permission from myself.
-- Please contact me with any questions or concerns you may have. Thanks for downloading!
--
g_fuelPricePerGallon = 9.9221;
g_fuelIdleUsagePercent = 25; -->> 0-100 : Percent(estimated) of fuelUsage to consume for idleFuelUsage
--
fuelAdjust = {};
function fuelAdjust.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function fuelAdjust:round(val, decimal)
  if decimal then
    return math.floor((val*10^decimal)+0.5)/(10^decimal)
  else
    return math.floor(val+0.5)
  end
end
function fuelAdjust:update(dt)
	if self.doRefuel then
		self.doRefuel = false;
		self.doRefuel2 = true;
	end;
	if self.doRefuel2 then
		if self.isServer then
			local refuelSpeed = 0.01;
			local currentFillLevel = fuelAdjust:round(self.fuelFillLevel, 2);
			self:setFuelFillLevel(self.fuelFillLevel+refuelSpeed*20);
			local delta = (self.fuelFillLevel - currentFillLevel);		
			if delta <= 0.01 then
				self:stopRefuel();
				self.doRefuel2 = false;
			end;
			delta = delta * g_fuelPricePerGallon;
			g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + delta;
			g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + delta;
			g_currentMission:addSharedMoney(-delta);
		end;
	end;
	if self.isMotorStarted and self.wheelRpm == 0 then
		self.idleFuelUsage = self.fuelUsage * (g_fuelIdleUsagePercent / 1000)
		self:setFuelFillLevel(self.fuelFillLevel - self.idleFuelUsage);
		g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + self.idleFuelUsage;
		g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + self.idleFuelUsage;
	end;
end;
Motorized.update = Utils.appendedFunction(fuelAdjust.update, Motorized.update);