--
-- RunningCosts
--
-- M@D Author:  Householler
-- M@D date: 15.03.2011
--
-- > Copyright (C) Householler  < --
-- > Thanks to Heady < --
--

print("RunningCosts v1.0 loaded");

RunningCosts = {};
RunningCosts.modDir = g_currentModDirectory;

function RunningCosts:loadMap(name)
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	self.careerSaveXMLFile = dir .. "/RunningCosts.xml";
	self.settingsXMLFile = RunningCosts.modDir .. "RunningCosts.xml";
	self.priceForFarm = 0;
	self.priceForSteerable = 0;
	self.priceForAttachable = 0;
	self.priceForCow = 0;
	self.actualPrice = 0;
	self.costs = 0;
	self.lastDay = g_currentMission.environment.currentDay;
	if g_currentMission.missionStats.fuelUsageTotal == 0 then
		os.remove(self.careerSaveXMLFile);
		RunningCosts:loadSettings();
		self.firstTimeRun = false;
	else
		self.firstTimeRun = true;
	end;
end;

function RunningCosts:deleteMap()
end;

local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	RunningCosts:saveToXML();
end;

function RunningCosts:delete()
end;

function RunningCosts:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RunningCosts:keyEvent(unicode, sym, modifier, isDown)
end;

function RunningCosts:update(dt)		
	if self.firstTimeRun then
		RunningCosts:loadFromXML();
		self.firstTimeRun = false;
		self.lastDay = g_currentMission.environment.currentDay;
		RunningCosts:loadSettings();
	end;	
	local steerables = table.getn(g_currentMission.steerables);
	local attachables = table.getn(g_currentMission.attachables);
	local cows = AnimalHusbandry.getNumberOfAnimals();
	local level = g_currentMission.missionStats.difficulty;
    self.actualPrice = (self.priceForFarm + (self.priceForSteerable * steerables) + (self.priceForAttachable * attachables) + (self.priceForCow * cows)) * level;
	self.costs = self.costs - (self.actualPrice/24)*((dt*g_currentMission.environment.timeScale)/(1000*60*60)); -- 1h=1000*60*60
	if g_currentMission.environment.currentDay ~= self.lastDay then
		g_currentMission:addSharedMoney(self.costs);
		self.costs = 0;
		self.lastDay = g_currentMission.environment.currentDay;
	end;
end;

function RunningCosts:draw()
end;

function RunningCosts:saveToXML()		
	local existDir = io.open (self.careerSaveXMLFile, "w");	
	if existDir == nil then
		createXMLFile("createkosten", self.careerSaveXMLFile, "savekosten");
	end;
    local xmlFile = io.open (self.careerSaveXMLFile, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<RunningCosts>\n');
		xmlFile:write('    <costs actual="'..self.costs..'" />\n');		
		xmlFile:write("</RunningCosts>");
        xmlFile:close();
    end;	
end;

function RunningCosts:loadFromXML()	
	local existDir = io.open (self.careerSaveXMLFile, "r");
	if existDir ~= nil then
		local xmlFile = loadXMLFile("TempConfig", self.careerSaveXMLFile);
		self.costs = Utils.getNoNil(getXMLFloat(xmlFile,  "RunningCosts.costs#actual"), 0);
		delete(xmlFile);
		print("RunningCosts saves loaded");
	else
		print("Warning: ", self.careerSaveXMLFile, " can not be found, RunningCosts saves not loaded.")
	end;	
end;

function RunningCosts:loadSettings()
	local xmlFile = loadXMLFile("TempConfig", self.settingsXMLFile);
	self.priceForFarm = Utils.getNoNil(getXMLFloat(xmlFile,  "costs.farm#price"), 5000);
	self.priceForSteerable = Utils.getNoNil(getXMLFloat(xmlFile,  "costs.steerable#price"), 100);	
	self.priceForAttachable = Utils.getNoNil(getXMLFloat(xmlFile,  "costs.attachable#price"), 50);
	self.priceForCow = Utils.getNoNil(getXMLFloat(xmlFile,  "costs.cow#price"), 1500);	
	delete(xmlFile);
end;

addModEventListener(RunningCosts);