--
-- ErlanMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ErlanMap = {}

local ErlanMap_mt = Class(ErlanMap, Mission00);

function ErlanMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = ErlanMap_mt;
    end;
    local self = ErlanMap:superClass():new(baseDirectory, mt);
    return self;
end;

function ErlanMap:delete()
    ErlanMap:superClass().delete(self);
end;

function ErlanMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    bgapic = Utils.getFilename("map01/pdapics/bga.png", self.baseDirectory);
    trainpic = Utils.getFilename("map01/pdapics/train.png", self.baseDirectory);
	
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Farming Shop", "dataS2/missions/hud_pda_spot_shop.png", 779, 699, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Brewery", "dataS2/missions/hud_pda_spot_brewery.png", 958, 1752, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Watermill", "dataS2/missions/hud_pda_spot_watermill.png", 1517, 1281, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Lighthouse", "dataS2/missions/hud_pda_spot_lighthouse.png", 114, 1929, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Bell", "dataS2/missions/hud_pda_spot_bell.png", 459, 718, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Bell", "dataS2/missions/hud_pda_spot_bell.png", 519, 149, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Mall", "dataS2/missions/hud_pda_spot_mall.png", 532, 665, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("TrainStation", trainpic , 334, 1327 , 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("BiogasPlant", bgapic , 758, 1358 , 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Dairy", "dataS2/missions/hud_pda_spot_dairy.png", 1401, 944, 0.055, 0.036, false, false, 0);
	self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1208, 236, 0.055, 0.036, false, false, 0);
    
	--load Glass Containers
    self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
	--load Bottles
    self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
 

    
	ErlanMap:superClass().load(self);
end
function ErlanMap:loadFinished()
    ErlanMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function ErlanMap:mouseEvent(posX, posY, isDown, isUp, button)
    ErlanMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function ErlanMap:keyEvent(unicode, sym, modifier, isDown)
    ErlanMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function ErlanMap:update(dt)
    ErlanMap:superClass().update(self, dt);
end;

function ErlanMap:draw()
    ErlanMap:superClass().draw(self);
end;
