--
-- Hud
-- Specialization for an extra information hud in the left bottom corner of the screen
-- Information can be added from anywere within the script by using the addStats and addInfoText functions
--
-- @author  Templaer
-- @date  19/11/09
--

Hud = {};

function Hud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Hud:load(xmlFile)
	self.addInfoText = SpecializationUtil.callSpecializationsFunction("addInfoText");
	self.addStats = SpecializationUtil.callSpecializationsFunction("addStats");
	self.addTransmissionStats = SpecializationUtil.callSpecializationsFunction("addTransmissionStats");
	self.addTransmissionText = SpecializationUtil.callSpecializationsFunction("addTransmissionText");
	self.drawTransmission = SpecializationUtil.callSpecializationsFunction("drawTransmission");
	
	self.hudInfoBasePosX = 0.012;
    self.hudInfoBaseWidth = 0.425;
    self.hudInfoBasePosY = 1-0.99;
    self.hudInfoBaseHeight = 0.14;

	self.transInfoBasePosX = 0.5;
    self.transInfoBaseWidth = 0.32;
    self.transInfoBasePosY = 0.01;
    self.transInfoBaseHeight = 0.11;
	
	self.panelPath = Utils.getFilename("hud_info_base.png", self.baseDirectory);
	
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.panelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
	self.transInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.panelPath, self.transInfoBasePosX, self.transInfoBasePosY, self.transInfoBaseWidth, self.transInfoBaseHeight);
	
	self.infoButtonTexts = {};
	self.transmissionTexts = {};
	self.showHudInfoBase = true;
end;

function Hud:delete()
    if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;

function Hud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hud:keyEvent(unicode, sym, modifier, isDown)
end;

function Hud:update(dt)
    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
end;
		
function Hud:draw()
	if self.isEntered then			
		self:drawTransmission();
		if self.showHudInfoBase then
			local renderTextsLeft = {};
			local renderTextsRight = {};
							
			self:addInfoText(InputBinding.TOGGLEHUD, g_i18n:getText("ToggleHud"));
			
			for i=1, table.getn(self.infoButtonTexts) do
				local button = self.infoButtonTexts[i].button;
				if button ~= nil then
					if InputBinding.getButtonName(button) ~= nil then
						table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getKeyNamesOfDigitalAction(button).." " .. g_i18n:getText("or") .. " " .. g_i18n:getText("Button") .. " "..InputBinding.getButtonName(button)..":"));
					else	
						table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getKeyNamesOfDigitalAction(button)..":"));
					end;	
					table.insert(renderTextsRight, self.infoButtonTexts[i].text);
				else
					table.insert(renderTextsLeft, self.infoButtonTexts[i].left);
					table.insert(renderTextsRight, self.infoButtonTexts[i].right);
				end;
			end;
			self.infoButtonTexts = {};
			
			if table.getn(renderTextsLeft) >= 1 then
				self.hudInfoBaseOverlay:render();
			end;
			
			local num = math.min(7, table.getn(renderTextsLeft));
			
			for i=1, num do
				local left = renderTextsLeft[i];
				local right = renderTextsRight[i];
				renderText(0.03, (num-i)*0.0275+(1-0.97), 0.0225, left);
				renderText(0.24, (num-i)*0.0275+(1-0.97), 0.0225, right);
			end;
		end;
	end;
end;

-- Additional function(s)
function Hud:addInfoText(button, text)
	table.insert(self.infoButtonTexts, {text=text, button=button});
end;

function Hud:addStats(left, right)
	table.insert(self.infoButtonTexts, {left=left, right=right});
end;

function Hud:addTransmissionStats(left, right)
	table.insert(self.transmissionTexts, {left=left, right=right});
end;

function Hud:addTransmissionText(button, text)
	table.insert(self.transmissionTexts, {text=text, button=button});
end;

function Hud:drawTransmission()
	local renderTextsLeft = {};
	local renderTextsRight = {};
	
	for i=1, table.getn(self.transmissionTexts) do
		local button = self.transmissionTexts[i].button;
		if button ~= nil then
			if InputBinding.getButtonName(button) ~= nil then
				table.insert(renderTextsLeft, (InputBinding.getKeyNamesOfDigitalAction(button).." " .. g_i18n:getText("or") .. " " .. g_i18n:getText("Button") .. " "..InputBinding.getButtonName(button)..":"));
			else	
				table.insert(renderTextsLeft, (InputBinding.getKeyNamesOfDigitalAction(button)..":"));
			end;	
			table.insert(renderTextsRight, self.transmissionTexts[i].text);
		else
			table.insert(renderTextsLeft, self.transmissionTexts[i].left);
			table.insert(renderTextsRight, self.transmissionTexts[i].right);
		end;
	end;
	self.transmissionTexts = {};
	
	if table.getn(renderTextsLeft) >= 1 then
		self.transInfoBaseOverlay:render();
	end;
	
	local num = math.min(3, table.getn(renderTextsLeft));
	
	for i=1, num do
		local left = renderTextsLeft[i];
		local right = renderTextsRight[i];
		renderText(self.transInfoBasePosX + 0.0025,(num-i)*0.0275+(1-0.97), 0.0225, left);
		renderText(self.transInfoBasePosX + 0.175,(num-i)*0.0275+(1-0.97), 0.0225, right);
	end;
end;