--
-- ESLimiter v2.0
-- Specialization for ESLimiter
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		29/08/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 and some bugfixes
--

ESLimiter = {};

function ESLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ESLimiter:load(xmlFile)

	self.ESLimiter = {};
	self.ESLimiter.xPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posX"), 0.7543);
	self.ESLimiter.yPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posY"), 0.1715);
	self.ESLimiter.maxRPM = {};
	self.ESLimiter.percentage = {};
	for k,v in pairs(self.motor.maxRpm) do
		self.ESLimiter.maxRPM[k] = self.motor.maxRpm[3];
		local percentage = string.format("%d",(self.motor.maxRpm[k]* 100 / self.motor.maxRpm[3]));
		self.ESLimiter.percentage[k] = tonumber(percentage); -- percentage
	end;

	self.eslOverlay = Overlay:new("hudESLOverlay", Utils.getFilename("ESLimiter_hud.png", self.baseDirectory), self.ESLimiter.xPos, self.ESLimiter.yPos, 0.2371, 0.039525);
end;

function ESLimiter:delete()
end;

function ESLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ESLimiter:keyEvent(unicode, sym, modifier, isDown)
end;

function ESLimiter:update(dt)
	if self:getIsActiveForInput() then
		local currentLevel = self.motor.speedLevel;
		if self.movingDirection < 0 then
			currentLevel = 1;
		end;

		if currentLevel ~= 0 then
			local percentage = self.ESLimiter.percentage;
			local currentRPM = self.ESLimiter.maxRPM;
			if InputBinding.isPressed(InputBinding.ESLimiter_PLUS) and percentage[currentLevel] < 100 then
				percentage[currentLevel] = percentage[currentLevel] + 1;
			elseif InputBinding.isPressed(InputBinding.ESLimiter_MINUS) and percentage[currentLevel] > 10 then
				percentage[currentLevel] = percentage[currentLevel] - 1;
			end;
			if self.movingDirection > 0 then
				self.motor.maxRpm[currentLevel] = tonumber(string.format("%d",(percentage[currentLevel] * currentRPM[currentLevel] / 100)));
			else
				self.motor.maxRpm[3] = tonumber(string.format("%d",(percentage[currentLevel] * currentRPM[currentLevel] / 100)));
			end;
		else
			self.motor.maxRpm[3] = self.ESLimiter.maxRPM[3];
		end;
	end;
end;

function ESLimiter:draw()
	local currentLevel = self.motor.speedLevel;
	local text = "Disattivato";
	if self.movingDirection < 0 then
		currentLevel = 1;
	end;
	if currentLevel ~= 0 then
		local percentage = tonumber(string.format("%d", self.ESLimiter.percentage[currentLevel]));
		if percentage < 100 then
			percentage = " " .. percentage;
		end;
		text = g_i18n:getText("ESLimiter_level") .. currentLevel .. ":" .. percentage .. "% ";	
	end;
	self.eslOverlay:render();
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_LEFT);
	renderText(self.ESLimiter.xPos + 0.13, self.ESLimiter.yPos + 0.0085, 0.02, text);
	g_currentMission:addExtraPrintText();
end;


function ESLimiter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueStr = getXMLString(xmlFile, key.."#limiterValues");		
		if valueStr ~= nil then
			local found = string.find(valueStr, ";");
			local index = 1;
			while found ~= nil do
				local value = string.sub(valueStr, 0, found-1);
				valueStr = string.sub(valueStr, found+1);
				found = string.find(valueStr, ";");
				self.ESLimiter.percentage[index] = tonumber(value);
				if found == nil then
					self.ESLimiter.percentage[index+1] = tonumber(valueStr);
				end;
				index = index + 1;	
			end;
		end;
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function ESLimiter:getSaveAttributesAndNodes(nodeIdent)
	local values = "";	
	for k,v in pairs(self.ESLimiter.percentage) do
		if k ~= 1 then
			values = values .. ";";
		end;
		values = values .. string.format("%d", v);
	end;
	
    local attributes = 'limiterValues="'.. values .. '"';
    return attributes, nil;
end;