--BY Dami95 & Mlody & LenoX--

zegary = {};

function zegary.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function zegary:load(xmlFile)

--predkosc - speed
	self.speed = {};
	self.speed.index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#speed"));
	self.speed.light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#speed_light"));
	
--paliwo - fuel
	self.fuel = {};
	self.fuel.index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#fuel"));
	self.fuel.light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#fuel_light"));
	self.fuel.alert = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#fuel_alert"));
	
--ladownosc - load
	self.load = {};
	self.load.index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#load"));
	self.load.light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#load_light"));
	self.load.alert = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#load_alert"));
	
--obrot - rotation
	self.rotation = {};
	self.rotation.index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#rotation"));
	self.rotation.light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#rotation_light"));
	self.rotation.alert = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#rotation_alert"));
	
--czas - time
	self.czas = {};
	self.czas.index1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#time1"));
	self.czas.index2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#time2"));
	self.czas.light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zegary#time_light"));
end;

function zegary:delete()
end;

function zegary:mouseEvent(posX, posY, isDown, isUp, button)
end;

function zegary:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_f then
		self.podswietlenie = not self.podswietlenie;
	end;
end;

function zegary:update(dt)

--predkosc - speed
	local speed_pos = self.lastSpeed*3600*-253/70;
	setRotation(self.speed.index, 0, 0, Utils.degToRad(speed_pos));

--paliwo - fuel
	local fuel_pos = self.fuelFillLevel/self.fuelCapacity*-74.5;
	setRotation(self.fuel.index, 0, 0, Utils.degToRad(fuel_pos));
	if self.fuelFillLevel < 80 then
		setVisibility(self.fuel.alert, true);
	else
		setVisibility(self.fuel.alert, false);
	end;
	
--ladownosc - load
local f,c = self:getAttachedTrailersFillLevelAndCapacity();
if f and c ~= nil then
	local prozent = f/c*100;
	local load_pos = prozent*-202.5/100;
	setRotation(self.load.index, 0, 0, Utils.degToRad(load_pos));
	if prozent == 100 then
		setVisibility(self.load.alert, true);
	else
		setVisibility(self.load.alert, false);
	end;
else
	setRotation(self.load.index, 0, 0, 0);
	setVisibility(self.load.alert, false);
end;

--obrot - rotation
	local x,y,z = localDirectionToWorld(self.rootNode, 0, 0, 1);
	local length = Utils.vector2Length(x,z);
	local dX = x/length;
	local dZ = z/length;
	local x,y,z = getWorldTranslation(self.rootNode);
	self.aiTractorTargetX = x;
	self.aiTractorTargetZ = z;
	local TEntfernung = math.sqrt(dX * dX + dZ * dZ);
	local TRichtung = math.deg(math.atan2(dX,dZ));	
	if TRichtung < 0  then 
		TRichtung = 360 - (TRichtung * -1);
	end;
	local rotation = 360 - math.floor(TRichtung + 0.5);
	local rotation_pos = -1*rotation
	setRotation(self.rotation.index, 0, 0, Utils.degToRad(rotation_pos));
	if rotation == 90 or rotation == 0 or rotation == 360 or rotation == 180 or rotation == 270 then
		setVisibility(self.rotation.alert, true);
	else
		setVisibility(self.rotation.alert, false);
	end;
	
--czas - time
	local godzinka = tonumber(os.date("%H"));
	if godzinka > 12 then
		godzinka = godzinka - 12;
	end;
	
	local time1_pos = godzinka*-360/12;
	setRotation(self.czas.index1, 0, 0, Utils.degToRad(time1_pos));
	
	local time2_pos = os.date("%M")*-360/60;
	setRotation(self.czas.index2, 0, 0, Utils.degToRad(time2_pos));
	
--podswietlenie - light
	if self.podswietlenie then
		setVisibility(self.speed.light, true);
		setVisibility(self.fuel.light, true);
		setVisibility(self.load.light, true);
		setVisibility(self.rotation.light, true);
		setVisibility(self.czas.light, true);
	else
		setVisibility(self.speed.light, false);
		setVisibility(self.fuel.light, false);
		setVisibility(self.load.light, false);
		setVisibility(self.rotation.light, false);
		setVisibility(self.czas.light, false);
	end;

end;

function zegary:onLeave()
end;

function zegary:draw()
end;