--[[

|=================================================|
|--------Script do New Holland TC 54 BIZON--------|
|-----------------BY maciusboss1------------------|
|----------------Data: 10.10.2011-----------------|
|---------------Pomoc: Burner, asd4---------------|
|------------------www.lsmodss.pl-----------------|
|-------------------------------------------------|
|=================================================|

]]--

NH_TC54_BIZON = {};

function NH_TC54_BIZON.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function NH_TC54_BIZON:load(xmlFile)

		local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przycisk1#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;

	   local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk1#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk1#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk1#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk1#touchRotLimit"), 10));
    end;
    
   	local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przycisk2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk2#touchRotLimit"), 10));
    end;
    
    local rotationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przycisk3#index"));
    if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

	   local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk3#touchRotLimit"), 10));
    end;
    
    local rotationPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przycisk4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

	   local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przycisk4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przycisk4#touchRotLimit"), 10));
    end;


    self.rollNodes = {};

    local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
    
    self.slimakNodes = {};

    local slimakNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.slimak#index"));
    if slimakNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.slimakNodes, {node=slimakNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.slimaks.slimak(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local slimakNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if slimakNode ~= nil then
            table.insert(self.slimakNodes, {node=slimakNode, speed=speed});
        end;
        i = i + 1;
    end;

	local rotationPartNodejoystick = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.joystick#index"));
    if rotationPartNodejoystick ~= nil then
        self.rotationPartjoystick = {};
        self.rotationPartjoystick.node = rotationPartNodejoystick;

	   local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.joystick#minRot"));
        self.rotationPartjoystick.minRot = {};
        self.rotationPartjoystick.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartjoystick.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartjoystick.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.joystick#maxRot"));
        self.rotationPartjoystick.maxRot = {};
        self.rotationPartjoystick.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartjoystick.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartjoystick.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartjoystick.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.joystick#rotTime"), 2)*1000;
        self.rotationPartjoystick.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.joystick#touchRotLimit"), 10));
    end;
    
   	local rotationPartNodejoystick2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.joystick2#index"));
    if rotationPartNodejoystick2 ~= nil then
        self.rotationPartjoystick2 = {};
        self.rotationPartjoystick2.node = rotationPartNodejoystick2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.joystick2#minRot"));
        self.rotationPartjoystick2.minRot = {};
        self.rotationPartjoystick2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartjoystick2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartjoystick2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.joystick2#maxRot"));
        self.rotationPartjoystick2.maxRot = {};
        self.rotationPartjoystick2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartjoystick2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartjoystick2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartjoystick2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.joystick2#rotTime"), 2)*1000;
        self.rotationPartjoystick2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.joystick2#touchRotLimit"), 10));
    end;
	
	self.objectInRange = NH_TC54_BIZON.objectInRange;
	self.oslonaFiltra = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oslonaFiltra#index"));
	self.zamontujOsloneFiltra = SpecializationUtil.callSpecializationsFunction("zamontujOsloneFiltra");
	self.oslonaFiltraActive = false;
end;

function NH_TC54_BIZON:delete()

end;

function NH_TC54_BIZON:readStream(streamId, connection)
	self:zamontujOsloneFiltra(streamReadBool(streamId), true);
end;

function NH_TC54_BIZON:writeStream(streamId, connection)
	streamWriteBool(streamId, self.oslonaFiltraActive);
end;

function NH_TC54_BIZON:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_f then
	    self.rotationMax = not self.rotationMax;
	end;
	if isDown and sym == Input.KEY_KP_2 then
	    self.rotationMax2 = not self.rotationMax2;
	end;
	if isDown and sym == Input.KEY_7 then
	    self.rotationMax3 = not self.rotationMax3;
	end;
	if isDown and sym == Input.KEY_home then
	    self.rotationMax4 = not self.rotationMax4;
	end;
	if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
   	end;

end;

function NH_TC54_BIZON:update(dt)

    	if self.rotationPart ~= nil then
		local x, y, z = getRotation(self.rotationPart.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
		setRotation(self.rotationPart.node, unpack(newRot));
	end;
	if self.rotationPart2 ~= nil then
		local x, y, z = getRotation(self.rotationPart2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2);
		setRotation(self.rotationPart2.node, unpack(newRot));
	end;
	if self.rotationPart3 ~= nil then
		local x, y, z = getRotation(self.rotationPart3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3);
		setRotation(self.rotationPart3.node, unpack(newRot));
	end;
	if self.rotationPart4 ~= nil then
		local x, y, z = getRotation(self.rotationPart4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4);
		setRotation(self.rotationPart4.node, unpack(newRot));
	end;

	if self.rotationPartjoystick ~= nil then
		local x, y, z = getRotation(self.rotationPartjoystick.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartjoystick.maxRot, self.rotationPartjoystick.minRot, 3, self.rotationPartjoystick.rotTime, dt, not self.rotationMaxjoystick);
		setRotation(self.rotationPartjoystick.node, unpack(newRot));
	end;
	if self.rotationPartjoystick2 ~= nil then
		local x, y, z = getRotation(self.rotationPartjoystick2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartjoystick2.maxRot, self.rotationPartjoystick2.minRot, 3, self.rotationPartjoystick2.rotTime, dt, not self.rotationMaxjoystick2);
		setRotation(self.rotationPartjoystick2.node, unpack(newRot));
	end;
	if Input.isKeyPressed(Input.KEY_w) then
         self.rotationMaxjoystick = true;
	else
		 self.rotationMaxjoystick = false;
	end
	if Input.isKeyPressed(Input.KEY_s) then
         self.rotationMaxjoystick2 = true;
	else
		 self.rotationMaxjoystick2 = false;
	end
	

	if self:getIsActive() then
		if self.isThreshing then
			for _, rollNode in pairs(self.rollNodes) do
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;
	
          if self.currentPipeState == 2 then
			for _, slimakNode in pairs(self.slimakNodes) do
				rotate(slimakNode.node, -dt*slimakNode.speed, 0, 0);
			end;
          end;

	
    if self:getIsActiveForInput() then
    if InputBinding.hasEvent(InputBinding.NH_TC54_BIZON_DRZWI) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
	end;
	  if InputBinding.hasEvent(InputBinding.NH_TC54_BIZON_KLAPY) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
	end;
	 if InputBinding.hasEvent(InputBinding.NH_TC54_BIZON_DRABINA) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
	end;
	if InputBinding.isPressed(InputBinding.NH_TC54_BIZON_HYDRAULIKADOWN) then
               self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.NH_TC54_BIZON_HYDRAULIKAUP) then
               self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet+dt), false);
        end;
     end;

	 if self.isClient then
		if self:objectInRange(self.oslonaFiltra) then
			if InputBinding.hasEvent(InputBinding.NH_TC54_BIZON_OSLONA_FILTRA) then
				self:zamontujOsloneFiltra(not self.oslonaFiltraActive);
			end;
			if self.oslonaFiltraActive then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("NH_TC54_BIZON_ZDEMONTUJ_OSLONE")), InputBinding.NH_TC54_BIZON_OSLONA_FILTRA);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("NH_TC54_BIZON_ZAMONTUJ_OSLONE")), InputBinding.NH_TC54_BIZON_OSLONA_FILTRA);
			end;
		end;
	end;
  
	if self.oslonaFiltra ~= nil then
		setVisibility(self.oslonaFiltra, self.oslonaFiltraActive);
	end;
end;


function NH_TC54_BIZON:draw()

	   if self.isEntered then
		if not self.helpPanel then
			renderText(0.76, 0.22, 0.02, "Wcisnij 0: NH TC 54 Bizon");
		else
			renderText(0.76, 0.22, 0.02, "Wcisnij 0: NH TC 54 Bizon");
		end;
		if self.helpPanel then
		renderText(0.72, 0.84, 0.03, "NH TC 54 Bizon");
			renderText(0.72, 0.815, 0.02, "wcisnij NUM 1: kierunkowskaz lewy");
			renderText(0.72, 0.8, 0.02, "wcisnij NUM 2: awaryjne");
			renderText(0.72, 0.785, 0.02, "wcisnij NUM 3: kierunkowskaz prawy");
			renderText(0.72, 0.77, 0.02, "wcisnij 4: otworz/zamknij drzwi");
			renderText(0.72, 0.755, 0.02, "wcisnij 5: otworz/zamknij klapy");
			renderText(0.72, 0.74, 0.02, "wcisnij 6: obroc drabinke");
			renderText(0.72, 0.725, 0.02, "wcisnij 7: wlacz/wylacz swiatla robocze");
			renderText(0.72, 0.71, 0.02, "wcisnij Z: wlacz/wylacz sieczkarnie");
            renderText(0.72, 0.695, 0.02, "wcisnij Insert: podnies gardziel");
			renderText(0.72, 0.68, 0.02, "wcisnij Delete: opusc gardziel");
			renderText(0.72, 0.665, 0.02, "wcisnij HOME: wlacz/wylacz koguta");
			renderText(0.72, 0.65, 0.02, "aby zalozyc oslone podejdz do niej");
			renderText(0.72, 0.625, 0.03, "By maciusboss1");
		end;
	end;

end;

function NH_TC54_BIZON:validateAttacherJoint(implement, jointDesc, dt)
   return true;
end;

function NH_TC54_BIZON:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NH_TC54_BIZON:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 3;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function NH_TC54_BIZON:zamontujOsloneFiltra(oslonaFiltraActive,noEventSend)
	ZamontujOsloneFiltraEvent.sendEvent(self, oslonaFiltraActive, noEventSend);
	self.oslonaFiltraActive = oslonaFiltraActive;
end;