--[[

|=================================================|
|-----Script do Heder New Holland TC 54 BIZON-----|
|-----------------BY maciusboss1------------------|
|----------------Data: 10.10.2011-----------------|
|---------------Pomoc: Burner, asd4---------------|
|------------------www.lsmodss.pl-----------------|
|-------------------------------------------------|
|=================================================|

]]--

HEDER_NH_TC54_BIZON = {};

function HEDER_NH_TC54_BIZON.prerequisitesPresent(specializations)
    return true;
end;

function HEDER_NH_TC54_BIZON:load(xmlFile)

        self.stol = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stol#index"));
        self.stolActive = false;
        self.nagarniacz = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.nagarniacz#index"));
        self.changeTools = SpecializationUtil.callSpecializationsFunction("changeTools");
		self.objectInRange = HEDER_NH_TC54_BIZON.objectInRange;

end;

function HEDER_NH_TC54_BIZON:delete()
   
end;

function HEDER_NH_TC54_BIZON:readStream(streamId, connection)
	self:changeTools(streamReadBool(streamId), true);
end;

function HEDER_NH_TC54_BIZON:writeStream(streamId, connection)
	streamWriteBool(streamId, self.stolActive);
end;

function HEDER_NH_TC54_BIZON:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HEDER_NH_TC54_BIZON:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
   	end;

end;

function HEDER_NH_TC54_BIZON:update(dt)
	if self.stol ~= nil then
		setVisibility(self.stol, self.stolActive);
	end;
	if self.nagarniacz ~= nil then
		setVisibility(self.nagarniacz, not self.stolActive);
	end;
	
	if self.isClient then
		if self:objectInRange(self.stol) then
			if InputBinding.hasEvent(InputBinding.HEDER_NH_TC54_BIZON_STOL) then
				self:changeTools(not self.stolActive);
			end;
			if self.stolActive then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HEDER_NH_TC54_BIZON_NAGARNIACZE")), InputBinding.HEDER_NH_TC54_BIZON_STOL);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("HEDER_NH_TC54_BIZON_STOL")), InputBinding.HEDER_NH_TC54_BIZON_STOL);
			end;
		end;
	end;

	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.HEDER_NH_TC54_BIZON_MOTOWIDLAUP) then
		   self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
		   elseif InputBinding.isPressed(InputBinding.HEDER_NH_TC54_BIZON_MOTOWIDLADOWN) then
		   self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
		end;
		if InputBinding.isPressed(InputBinding.HEDER_NH_TC54_BIZON_MOTOUP) then
		   self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
		   elseif InputBinding.isPressed(InputBinding.HEDER_NH_TC54_BIZON_MOTODOWN) then
		   self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
		end;
		if InputBinding.hasEvent(InputBinding.HEDER_NH_TC54_BIZON_NAGARNIACZE) then
		   if self.animationParts[6].clipEndTime then
			  self:setAnimationTime(6, self.animationParts[6].offSet);
		   elseif self.animationParts[6].clipStartTime then
			  self:setAnimationTime(6, self.animationParts[6].animDuration);
		end;
	end;
	  
 end;
      if self.reelStarted then
         self:setAnimationTime(3, 1);
         self:setAnimationTime(4, 1);
         self:setAnimationTime(5, 1);
	  else
         self:setAnimationTime(3, 0);
         self:setAnimationTime(4, 0);
         self:setAnimationTime(5, 0);
	  end;
	  
end;

function HEDER_NH_TC54_BIZON:draw()


		if self.helpPanel then
			renderText(0.76, 0.235, 0.02, "Wcisnij 0: NH TC 54 Heder");
		else
			renderText(0.76, 0.235, 0.02, "Wcisnij 0: NH TC 54 Heder");
		end;
		if self.helpPanel then
		renderText(0.72, 0.59, 0.03, "NH TC 54 Heder");
		renderText(0.72, 0.565, 0.02, "wcisnij NUM 7: motowidla gora ");
		renderText(0.72, 0.55, 0.02, "wcisnij NUM 4: motowidla dol");
		renderText(0.72, 0.535, 0.02, "wcisnij NUM 9: motowidla wysun");
		renderText(0.72, 0.52, 0.02, "wcisnij NUM 6: motowidla wsun");
		renderText(0.72, 0.505, 0.02, "wcisnij NUM 8: rozloz/zloz nagarniacze");
		renderText(0.72, 0.49, 0.02, "aby zalozyc stol podejdz na przod hedera");
		renderText(0.72, 0.465, 0.03, "By maciusboss1");
		end;
	end;



function HEDER_NH_TC54_BIZON:onDetach()

end;

function HEDER_NH_TC54_BIZON:onLeave()

end;

function HEDER_NH_TC54_BIZON:onDeactivate()

end;

function HEDER_NH_TC54_BIZON:changeTools(stolStatus,noEventSend)
	ChangeToolsEvent.sendEvent(self, stolStatus, noEventSend);
	self.stolActive = stolStatus;
end;

function HEDER_NH_TC54_BIZON:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;