PickupEvent = {};
PickupEvent_mt = Class(PickupEvent, Event);

InitEventClass(PickupEvent, "PickupEvent");

function PickupEvent:emptyNew() 
    local self = Event:new(PickupEvent_mt );
    self.className="PickupEvent";
    return self;
end;

function PickupEvent:new(vehicle, direction) 
    self.vehicle = vehicle;
    self.direction = direction;
    return self;
end;

function PickupEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId);
    self.direction = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function PickupEvent:writeStream(streamId, connection) 
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteBool(streamId, self.direction );
end;

function PickupEvent:run(connection) 
    self.vehicle:setRotateDirection4(self.direction, true); 
	if not connection:getIsServer() then 
		g_server:broadcastEvent(PickupEvent:new(self.vehicle, self.direction), nil, connection, self.object);
	end;
end;

function PickupEvent.sendEvent(vehicle, direction, noEventSend) 
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(PickupEvent:new(vehicle, direction), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(PickupEvent:new(vehicle, direction));
		end;
	end;
end;