--
-- handThrottle
-- Specialization for hand throttle on steerables
--
-- @author  Templaer
-- @date  12/06/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

handThrottle = {};

function handThrottle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function handThrottle:load(xmlFile)
    self.backupMinRpmManual = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
	self.handThrottleEnabled = false;
	
	-- Backup maxRpm
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    self.motorMaxRpmLimit = motorMaxRpm3;
	
    -- Percentage of full throttle
    self.throttlePercentage = 0.05;
end;

function handThrottle:delete()
end;

function handThrottle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function handThrottle:keyEvent(unicode, sym, modifier, isDown)
end;

function handThrottle:update(dt)
    -- Check if hand throttle is enabled
    if self.isEntered then

        -- Local variables
	    local alpha = 1;
	    local roundPerMinute = self.lastRoundPerMinute*alpha + (1-alpha)*(self.motor.lastMotorRpm-self.motor.minRpm);
        local rpmDiff = math.abs(roundPerMinute - ((self.motorMaxRpmLimit * 0.9) * self.throttlePercentage));
	
	    -- Handle input
        if self:getIsActiveForInput() then
		    -- Raise and lower the throttle percentage
            if InputBinding.isPressed(InputBinding.MORERPM) and self.throttlePercentage < 1 then
		        self.throttlePercentage = self.throttlePercentage + 0.005; 
		    	self.handThrottleEnabled = true;
		    elseif InputBinding.isPressed(InputBinding.LESSRPM) and self.throttlePercentage > 0.05 then 
		        self.throttlePercentage = self.throttlePercentage - 0.005; 
			    self.handThrottleEnabled = true;
	        end;
		
	    	-- Disable hand throttle
		    if InputBinding.hasEvent(InputBinding.RESETRPM) then
		        self.handThrottleEnabled = false;
				self.motor.minRpm = self.backupMinRpmManual;
				self.throttlePercentage = 0.05;
		    end;
        end;
	
	    if self.handThrottleEnabled then
            -- Lower and raise minRpm with a 100 RPM margin
            if roundPerMinute < ((self.motorMaxRpmLimit * self.throttlePercentage) - 50) then
                self.motor.minRpm = self.motor.minRpm - (rpmDiff / 10);
            elseif roundPerMinute > ((self.motorMaxRpmLimit * self.throttlePercentage) + 50) then
			    if self.motor.minRpm <= (self.backupMinRpmManual - (rpmDiff/10)) then
                    self.motor.minRpm = self.motor.minRpm + (rpmDiff / 10);
		        end;
            end;
		end;
		
	end;
end;

function handThrottle:stopMotor()
    self.motor.minRpm = self.backupMinRpmManual;
end;
	
function handThrottle:onLeave()
    self.motor.minRpm = self.backupMinRpmManual;
end;

function handThrottle:draw()
        
end;

