OilTemp = {};

function OilTemp.prerequisitesPresent(specializations)
	return true;
end;

function OilTemp:load(xmlFile)

	self.temp = 5;
	self.coolingTemp = 0;
	self.warmUp = 0.020;
	self.fuelType = "Diesel";
	self.fuelTimer = 0;
	self.backUpFuelUsage = self.fuelUsage;

end;

function OilTemp:delete()
end;

function OilTemp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OilTemp:keyEvent(unicode, sym, modifier, isDown)

end;

function OilTemp:update(dt)

	if self.isMotorStarted then
		local maxRpm = self.motor:getMaxRpm();
		local lastMotorRpm = self.motor.lastMotorRpm;
		local powerDifferenz = ((100/lastMotorRpm)*maxRpm)-100;
		local sec = (dt/dt)/dt;
		if powerDifferenz > 100 then
			powerDifferenz = 100;
		elseif powerDifferenz < 0 then
			powerDifferenz = 0;
		end;
		if maxRpm < self.motor.minRpm then
			maxRpm = self.motor.minRpm;
		end;
		if self.input == 0 or self.motor.speedLevel == 0 then
			if self.temp < 95 then
				self.temp = self.temp+(4/lastMotorRpm);
			else
				self.temp = self.temp-(4/lastMotorRpm);
			end;
		end;
		if powerDifferenz > 0 then
			self.temp = self.temp+(powerDifferenz/7000);
		end;
		if self.temp > 100 then
			self.coolingOn = true;
		end;
		if self.coolingOn == true and self.temp < 90 then
			self.coolingOn = false;
		end;
		if self.coolingOn == true then
			self.temp = self.temp-(6/lastMotorRpm);
		end;
		if lastMotorRpm > self.motor.minRpm then
			self.fuelTimer = self.fuelTimer+sec;
		else
			self.fuelTimer = self.fuelTimer-sec;
		end;
		if self.fuelTimer > 20 then
			self.fuelTimer = 20;
		elseif self.fuelTimer < -10 then
			self.fuelTimer = -10;
		end;
	else
		self.temp = self.temp-(self.warmUp/10);
	end;
	if self.temp < 5 then
		self.temp = 5;
	end;
	if self.temp > 60 then
		if self.fuelTimer > 0 then
			self.fuelType = "Olej Rzepakowy";
			self.fuelUsage = (self.fuelUsage/2);
		else
			self.fuelType = "Diesel";
			self.fuelUsage = self.backUpFuelUsage;
		end;
	else
		self.fuelType = "Diesel";
	end;
end;

function OilTemp:draw()

	local red = 0.0;
	local green = 0.0;
	local blue = 0.0;
	if self.temp < 60 then
		red = 0.0;
		green = 0.0;
		blue = 1.0;
	elseif self.temp >= 60 and self.temp <= 110 then
		blue = 0.0;
		red = 0.0;
		green = 1.0;
	elseif self.temp > 110 then
		red = 1.0;
		green = 0.0;
		blue = 0.0;
	end;
		if self.showHudInfoBase and self.isEntered then
		self.hudInfoBaseOverlay:render();
	end;
	
	setTextColor(red, green, blue, 1.0);
	renderText(0.835, 0.200, 0.018, string.format("Temperatura oleju: %d'C", self.temp));
	setTextColor(1 ,1 ,1 , 1);
	renderText(0.835, 0.180, 0.018, string.format("Paliwo: %s", self.fuelType));
	
end;

function OilTemp:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	local loadTemp = getXMLFloat(xmlFile, key.."#temp");
	if loadTemp ~= nil then
		self.temp = loadTemp;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function OilTemp:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'temp="'..self.temp..'"';
    return attributes, nil;
end;