animacjakurzukol = {};

function animacjakurzukol.prerequisitesPresent(specializations)
    return true;
end;

function animacjakurzukol:load(xmlFile)

	self.animacjakurz = {};
    local psFile = getXMLString(xmlFile, "vehicle.animacjakurz#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.animacjakurz.animacjakurzz(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.animacjakurz.node = node;
            if node ~= nil then
                local animacjakurzz = {};
                animacjakurzz.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, animacjakurzz.particleSystems, "vehicle.animacjakurz", node, false, nil, self.baseDirectory);
                table.insert(self.animacjakurz, animacjakurzz);
            end;
            i = i+1;
        end;
    end;
end;

function animacjakurzukol:delete()
	for i=1, table.getn(self.animacjakurz) do
		Utils.deleteParticleSystem(self.animacjakurz[i].particleSystems);
    end;
end;

function animacjakurzukol:mouseEvent(posX, posY, isDown, isUp, button)
end;

function animacjakurzukol:keyEvent(unicode, sym, modifier, isDown)
end;

function animacjakurzukol:update(dt)
	
	local dens = 0; local dens1; local dens2; local dens3;
	local x,y,z = getWorldTranslation(self.wheels[2].repr);
	local x1,y1,z1 = getWorldTranslation(self.wheels[1].repr);
	local x2,y2,z2 = getWorldTranslation(self.wheels[4].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2+dens3;
	end;
	if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		for i=1, table.getn(self.animacjakurz) do
			Utils.setEmittingState(self.animacjakurz[i].particleSystems, self.wheels[i].hasGroundContact);
		end;
	else
		for i=1, table.getn(self.animacjakurz) do
			Utils.setEmittingState(self.animacjakurz[i].particleSystems, false);
		end;
	end;
	
end;

function animacjakurzukol:draw()
end;