-- Oryginal script by Stefan Geiger
--
-- Traktor -U-R-S-U-S- C-385A
-- dodano nowe funkcje
-- 
-- @author by landwirtschaftssimulator-2009.de 
-- @date  30/11/08 | @edit date 25/01/11
--
-- @edit by: Grzegorz056 for Ursus c385A

Uc385A = {};

function Uc385A.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Uc385A:load(xmlFile)
      
    	self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    	self.worklights = {};
    	for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    	self.brakelights = {};
    	for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
	self.kluczactive = true;
	self.kogutactive = true;
	self.paliwoactive = true;

    	self.braking = false;
	self.test = 800;
	
	local radioSound = getXMLString(xmlFile, "vehicle.radioSound#file");
    	if  radioSound ~= nil and  radioSound ~= "" then
        radioSound = Utils.getFilename( radioSound, self.baseDirectory); 
        self.radioSound = createSample(" radioSound");
        self.radioSoundPlaying = false;
        loadSample(self. radioSound, radioSound, false);
        self.radioSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.radioSound#volume"),1);
    end;

    	skretSoundFile = Utils.getFilename("dzwieki/kieruek_385A.wav", self.baseDirectory);
    	self.skretSoundId = createSample("c385A_skret_kol");
    	loadSample(self.skretSoundId, skretSoundFile, false);
    		
    	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    	self.rundumleuchtenAn = false;
    	self.rundumleuchten = {};
    	for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

	 self.podnosnik = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.podnosnik#index"));
	self.podnosnikzaczep = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.podnosnikzaczep#index"));
	self.podnosnikramie = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.podnosnikramie#index"));
	self.podnosnikramiead = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.podnosnikramiead#index"));
	self.podnosnikstart = 0;

	self.numFrontlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontlights#count"), 0);
    	self.frontlights = {};
    	for i=1, self.numFrontlights do
        local frontlightnamei = string.format("vehicle.frontlights.frontlight" .. "%d", i);
        self.frontlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, frontlightnamei .. "#index"));
        setVisibility(self.frontlights[i], false);
    end;	
 

	 self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    	self.farlights = {};
    	for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;

	local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    	if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;
	local rotationPartNodewajchahydraulika = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wajchahydraulika#index"));
    	if rotationPartNodewajchahydraulika ~= nil then
        self.rotationPartwajchahydraulika = {};
        self.rotationPartwajchahydraulika.node = rotationPartNodewajchahydraulika;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwajchahydraulika#minRot"));
        self.rotationPartwajchahydraulika.minRot = {};
        self.rotationPartwajchahydraulika.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwajchahydraulika.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwajchahydraulika.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajchahydraulika#maxRot"));
        self.rotationPartwajchahydraulika.maxRot = {};
        self.rotationPartwajchahydraulika.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwajchahydraulika.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwajchahydraulika.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwajchahydraulika.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajchahydraulika#rotTime"), 2)*1000;
        self.rotationPartwajchahydraulika.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajchahydraulika#touchRotLimit"), 10));
    end;
	local translationPartNodekluczwloz = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kluczwloz#index"));
    	if translationPartNodekluczwloz ~= nil then
        self.translationPartkluczwloz = {};
        self.translationPartkluczwloz.node = translationPartNodekluczwloz;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kluczwloz#minTrans"));
        self.translationPartkluczwloz.minTrans = {};
        self.translationPartkluczwloz.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartkluczwloz.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartkluczwloz.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kluczwloz#maxTrans"));
        self.translationPartkluczwloz.maxTrans = {};
        self.translationPartkluczwloz.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartkluczwloz.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartkluczwloz.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartkluczwloz.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kluczwloz#transTime"), 2)*1000;
        self.translationPartkluczwloz.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kluczwloz#touchTransLimit"), 10);
    end;
	local wajchapodNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wajchapod#index"));
    	if wajchapodNode ~= nil then
        self.wajchapod = {};
        self.wajchapod.node = wajchapodNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajchapod#minRot"));
        self.wajchapod.minRot = {};
        self.wajchapod.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wajchapod.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wajchapod.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajchapod#maxRot"));
        self.wajchapod.maxRot = {};
        self.wajchapod.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wajchapod.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wajchapod.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.wajchapod.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajchapod#rotTime"), 2)*1000;
        self.wajchapod.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajchapod#touchRotLimit"), 10));
    end;
	local klapaNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa#index"));
    	if klapaNode ~= nil then
        self.klapa = {};
        self.klapa.node = klapaNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klapa#minRot"));
        self.klapa.minRot = {};
        self.klapa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.klapa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.klapa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klapa#maxRot"));
        self.klapa.maxRot = {};
        self.klapa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.klapa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.klapa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.klapa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa#rotTime"), 2)*1000;
        self.klapa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa#touchRotLimit"), 10));
    end;
	local rotationPartNodeklucz = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klucz#index"));
         if rotationPartNodeklucz ~= nil then
        self.rotationPartklucz = {};
        self.rotationPartklucz.node = rotationPartNodeklucz;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklucz#minRot"));
        self.rotationPartklucz.minRot = {};
        self.rotationPartklucz.minRot[1] = Utils.degToRad(Utils.getNoNil(x, -21));
        self.rotationPartklucz.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklucz.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klucz#maxRot"));
        self.rotationPartklucz.maxRot = {};
        self.rotationPartklucz.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklucz.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklucz.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklucz.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klucz#rotTime"), 2)*1000;
        self.rotationPartklucz.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klucz#touchRotLimit"), 10));
    end;
	local rotationPartNodewycieraczka2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wycieraczka#index"));
   	if rotationPartNodewycieraczka2 ~= nil then
        self.rotationPartwycieraczka2 = {};
        self.rotationPartwycieraczka2.node = rotationPartNodewycieraczka2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwycieraczka#minRot"));
        self.rotationPartwycieraczka2.minRot = {};
        self.rotationPartwycieraczka2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwycieraczka2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwycieraczka2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wycieraczka#maxRot"));
        self.rotationPartwycieraczka2.maxRot = {};
        self.rotationPartwycieraczka2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwycieraczka2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwycieraczka2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwycieraczka2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wycieraczka#rotTime"), 2)*1000;
        self.rotationPartwycieraczka2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wycieraczka#touchRotLimit"), 10));
    end;
	local rotationPartNodeteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
   	 if rotationPartNodeteto ~= nil then
        self.rotationPartteto = {};
        self.rotationPartteto.node = rotationPartNodeteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartteto#minRot"));
        self.rotationPartteto.minRot = {};
        self.rotationPartteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.rotationPartteto.maxRot = {};
        self.rotationPartteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.rotationPartteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;
	local rotationPartNodemaska = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.maska#index"));
        if rotationPartNodemaska ~= nil then
        self.rotationPartmaska = {};
        self.rotationPartmaska.node = rotationPartNodemaska;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartmaska#minRot"));
        self.rotationPartmaska.minRot = {};
        self.rotationPartmaska.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaska.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaska.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maska#maxRot"));
        self.rotationPartmaska.maxRot = {};
        self.rotationPartmaska.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaska.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaska.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmaska.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.maska#rotTime"), 2)*1000;
        self.rotationPartmaska.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.maska#touchRotLimit"), 10));
    end;
	local rotationPartNodewaj = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.waj#index"));
    	if rotationPartNodewaj ~= nil then
        self.rotationPartwaj = {};
        self.rotationPartwaj.node = rotationPartNodewaj;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwaj#minRot"));
        self.rotationPartwaj.minRot = {};
        self.rotationPartwaj.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.waj#maxRot"));
        self.rotationPartwaj.maxRot = {};
        self.rotationPartwaj.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwaj.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj#rotTime"), 2)*1000;
        self.rotationPartwaj.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj#touchRotLimit"), 10));
    end;
	local rotationPartNodewaj4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.waj4#index"));
    	if rotationPartNodewaj4 ~= nil then
        self.rotationPartwaj4 = {};
        self.rotationPartwaj4.node = rotationPartNodewaj4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwaj4#minRot"));
        self.rotationPartwaj4.minRot = {};
        self.rotationPartwaj4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.waj4#maxRot"));
        self.rotationPartwaj4.maxRot = {};
        self.rotationPartwaj4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwaj4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj4#rotTime"), 2)*1000;
        self.rotationPartwaj4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj4#touchRotLimit"), 10));
    end;
	local rotationPartNodewaj3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.waj3#index"));
    	if rotationPartNodewaj3 ~= nil then
        self.rotationPartwaj3 = {};
        self.rotationPartwaj3.node = rotationPartNodewaj3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwaj3#minRot"));
        self.rotationPartwaj3.minRot = {};
        self.rotationPartwaj3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.waj3#maxRot"));
        self.rotationPartwaj3.maxRot = {};
        self.rotationPartwaj3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwaj3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj3#rotTime"), 2)*1000;
        self.rotationPartwaj3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj3#touchRotLimit"), 10));
    end;
	local rotationPartNodewaj2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.waj2#index"));
    	if rotationPartNodewaj2 ~= nil then
        self.rotationPartwaj2 = {};
        self.rotationPartwaj2.node = rotationPartNodewaj2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwaj2#minRot"));
        self.rotationPartwaj2.minRot = {};
        self.rotationPartwaj2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.waj2#maxRot"));
        self.rotationPartwaj2.maxRot = {};
        self.rotationPartwaj2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwaj2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwaj2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwaj2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj2#rotTime"), 2)*1000;
        self.rotationPartwaj2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.waj2#touchRotLimit"), 10));
    end;
	local rotationPartNodepedalhamulca = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pedal_hamulca#index"));
    	if rotationPartNodepedalhamulca ~= nil then
        self.rotationPartpedalhamulca = {};
        self.rotationPartpedalhamulca.node = rotationPartNodepedalhamulca;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_hamulca#minRot"));
        self.rotationPartpedalhamulca.minRot = {};
        self.rotationPartpedalhamulca.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalhamulca.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalhamulca.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_hamulca#maxRot"));
        self.rotationPartpedalhamulca.maxRot = {};
        self.rotationPartpedalhamulca.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalhamulca.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalhamulca.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpedalhamulca.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_hamulca#rotTime"), 2)*1000;
        self.rotationPartpedalhamulca.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_hamulca#touchRotLimit"), 10));
    end;
	local rotationPartNodebiegi = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.biegi#index"));
   	 if rotationPartNodebiegi ~= nil then
        self.rotationPartbiegi = {};
        self.rotationPartbiegi.node = rotationPartNodebiegi;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbiegi#minRot"));
        self.rotationPartbiegi.minRot = {};
        self.rotationPartbiegi.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegi.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegi.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.biegi#maxRot"));
        self.rotationPartbiegi.maxRot = {};
        self.rotationPartbiegi.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegi.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegi.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbiegi.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegi#rotTime"), 2)*1000;
        self.rotationPartbiegi.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegi#touchRotLimit"), 10));
    end;
	local rotationPartNodebiegir = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.biegir#index"));
   	 if rotationPartNodebiegir ~= nil then
        self.rotationPartbiegir = {};
        self.rotationPartbiegir.node = rotationPartNodebiegir;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbiegir#minRot"));
        self.rotationPartbiegir.minRot = {};
        self.rotationPartbiegir.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegir.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegir.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.biegir#maxRot"));
        self.rotationPartbiegir.maxRot = {};
        self.rotationPartbiegir.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegir.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegir.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbiegir.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegir#rotTime"), 2)*1000;
        self.rotationPartbiegir.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegir#touchRotLimit"), 10));
    end;
	local rotationPartNodebiegi3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.biegi3#index"));
   	 if rotationPartNodebiegi3 ~= nil then
        self.rotationPartbiegi3 = {};
        self.rotationPartbiegi3.node = rotationPartNodebiegi3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbiegi3#minRot"));
        self.rotationPartbiegi3.minRot = {};
        self.rotationPartbiegi3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegi3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegi3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.biegi3#maxRot"));
        self.rotationPartbiegi3.maxRot = {};
        self.rotationPartbiegi3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegi3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegi3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbiegi3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegi3#rotTime"), 2)*1000;
        self.rotationPartbiegi3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegi3#touchRotLimit"), 10));
    end;
	local rotationPartNodebiegi2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.biegi2#index"));
   	 if rotationPartNodebiegi2 ~= nil then
        self.rotationPartbiegi2 = {};
        self.rotationPartbiegi2.node = rotationPartNodebiegi2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbiegi2#minRot"));
        self.rotationPartbiegi2.minRot = {};
        self.rotationPartbiegi2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegi2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegi2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.biegi2#maxRot"));
        self.rotationPartbiegi2.maxRot = {};
        self.rotationPartbiegi2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbiegi2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbiegi2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbiegi2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegi2#rotTime"), 2)*1000;
        self.rotationPartbiegi2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.biegi2#touchRotLimit"), 10));
    end;
	local rotationPartNodekogut = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kogut#index"));
   	 if rotationPartNodekogut ~= nil then
        self.rotationPartkogut = {};
        self.rotationPartkogut.node = rotationPartNodekogut;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkogut#minRot"));
        self.rotationPartkogut.minRot = {};
        self.rotationPartkogut.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkogut.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkogut.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kogut#maxRot"));
        self.rotationPartkogut.maxRot = {};
        self.rotationPartkogut.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkogut.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkogut.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkogut.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kogut#rotTime"), 2)*1000;
        self.rotationPartkogut.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kogut#touchRotLimit"), 10));
    end;

	local rotationPartNodedach = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dach#index"));
    	if rotationPartNodedach ~= nil then
        self.rotationPartdach = {};
        self.rotationPartdach.node = rotationPartNodedach;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartdach#minRot"));
        self.rotationPartdach.minRot = {};
        self.rotationPartdach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.dach#maxRot"));
        self.rotationPartdach.maxRot = {};
        self.rotationPartdach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartdach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach#rotTime"), 2)*1000;
        self.rotationPartdach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach#touchRotLimit"), 10));
    end;
 
	local rotationPartNodepedalgazu = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pedal_gazu#index"));
   	 if rotationPartNodepedalgazu ~= nil then
        self.rotationPartpedalgazu = {};
        self.rotationPartpedalgazu.node = rotationPartNodepedalgazu;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_gazu#minRot"));
        self.rotationPartpedalgazu.minRot = {};
        self.rotationPartpedalgazu.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_gazu#maxRot"));
        self.rotationPartpedalgazu.maxRot = {};
        self.rotationPartpedalgazu.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpedalgazu.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_gazu#rotTime"), 2)*1000;
        self.rotationPartpedalgazu.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_gazu#touchRotLimit"), 10));
    end;
	
	 
	local rotationPartNodesprzeglo = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.sprzeglo#index"));
   	 if rotationPartNodesprzeglo ~= nil then
        self.rotationPartsprzeglo = {};
        self.rotationPartsprzeglo.node = rotationPartNodesprzeglo;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sprzeglo#minRot"));
        self.rotationPartsprzeglo.minRot = {};
        self.rotationPartsprzeglo.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsprzeglo.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsprzeglo.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sprzeglo#maxRot"));
        self.rotationPartsprzeglo.maxRot = {};
        self.rotationPartsprzeglo.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsprzeglo.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsprzeglo.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartsprzeglo.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.sprzeglo#rotTime"), 2)*1000;
        self.rotationPartsprzeglo.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.sprzeglo#touchRotLimit"), 10));
    end;
	local rotationPartNodesprzeglo2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.sprzeglo2#index"));
   	 if rotationPartNodesprzeglo2 ~= nil then
        self.rotationPartsprzeglo2 = {};
        self.rotationPartsprzeglo2.node = rotationPartNodesprzeglo2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sprzeglo2#minRot"));
        self.rotationPartsprzeglo2.minRot = {};
        self.rotationPartsprzeglo2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsprzeglo2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsprzeglo2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sprzeglo2#maxRot"));
        self.rotationPartsprzeglo2.maxRot = {};
        self.rotationPartsprzeglo2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsprzeglo2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsprzeglo2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartsprzeglo2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.sprzeglo2#rotTime"), 2)*1000;
        self.rotationPartsprzeglo2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.sprzeglo2#touchRotLimit"), 10));
    end;
	local rotationPartNodesprzeglo3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.sprzeglo3#index"));
   	 if rotationPartNodesprzeglo3 ~= nil then
        self.rotationPartsprzeglo3 = {};
        self.rotationPartsprzeglo3.node = rotationPartNodesprzeglo3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sprzeglo3#minRot"));
        self.rotationPartsprzeglo3.minRot = {};
        self.rotationPartsprzeglo3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsprzeglo3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsprzeglo3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sprzeglo3#maxRot"));
        self.rotationPartsprzeglo3.maxRot = {};
        self.rotationPartsprzeglo3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsprzeglo3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsprzeglo3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartsprzeglo3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.sprzeglo3#rotTime"), 2)*1000;
        self.rotationPartsprzeglo3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.sprzeglo3#touchRotLimit"), 10));
    end;
	local wajchagazNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wajcha_gaz#index"));
   	 if wajchagazNode ~= nil then
        self.wajchagaz = {};
        self.wajchagaz.node = wajchagazNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajcha_gaz#minRot"));
        self.wajchagaz.minRot = {};
        self.wajchagaz.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wajchagaz.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wajchagaz.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajcha_gaz#maxRot"));
        self.wajchagaz.maxRot = {};
        self.wajchagaz.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wajchagaz.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wajchagaz.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.wajchagaz.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajcha_gaz#rotTime"), 2)*1000;
        self.wajchagaz.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajcha_gaz#touchRotLimit"), 10));
    end;
	local lusterkoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lusterko#index"));
   	 if lusterkoNode ~= nil then
        self.lusterko = {};
        self.lusterko.node = lusterkoNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lusterko#minRot"));
        self.lusterko.minRot = {};
        self.lusterko.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lusterko.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lusterko.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lusterko#maxRot"));
        self.lusterko.maxRot = {};
        self.lusterko.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lusterko.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lusterko.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.lusterko.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.lusterko#rotTime"), 2)*1000;
        self.lusterko.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.lusterko#touchRotLimit"), 10));
    end;
	local swiatlatylNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.swiatlatyl#index"));
   	 if swiatlatylNode ~= nil then
        self.swiatlatyl = {};
        self.swiatlatyl.node = swiatlatylNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.swiatlatyl#minRot"));
        self.swiatlatyl.minRot = {};
        self.swiatlatyl.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.swiatlatyl.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.swiatlatyl.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.swiatlatyl#maxRot"));
        self.swiatlatyl.maxRot = {};
        self.swiatlatyl.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.swiatlatyl.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.swiatlatyl.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.swiatlatyl.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.swiatlatyl#rotTime"), 2)*1000;
        self.swiatlatyl.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.swiatlatyl#touchRotLimit"), 10));
    end;
	local lusterko2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lusterko2#index"));
   	 if lusterko2Node ~= nil then
        self.lusterko2 = {};
        self.lusterko2.node = lusterko2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lusterko2#minRot"));
        self.lusterko2.minRot = {};
        self.lusterko2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lusterko2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lusterko2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lusterko2#maxRot"));
        self.lusterko2.maxRot = {};
        self.lusterko2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lusterko2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lusterko2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.lusterko2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.lusterko2#rotTime"), 2)*1000;
        self.lusterko2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.lusterko2#touchRotLimit"), 10));
    end;
	
    	self.lusterka = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lusterka#index"));
    	self.lusterka5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lusterka5#index"));
    	self.lusterka2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lusterka2#index"));
    	self.lusterka3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lusterka3#index"));
    	self.lusterka4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lusterka4#index"));

    	self.lampa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lampa#index"));
    	self.lampa2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lampa2#index"));
    	self.cos = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cos#index"));
    	self.cos = false;

    	self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
    	hornSoundFile = Utils.getFilename("horn.wav", self.baseDirectory);
    	self.hornSoundId = createSample("HupenSound");
    	loadSample(self.hornSoundId, hornSoundFile, false);

	wycieraczkaSoundFile = Utils.getFilename("dzwieki/wycieraczka.wav", self.baseDirectory);
    	self.wycieraczkaSoundId = createSample("wycieraczkaSound");
	loadSample(self.wycieraczkaSoundId, wycieraczkaSoundFile, false);
	self.wycieraczkaPlaying = false;

    	self.rotateNeedle = SpecializationUtil.callSpecializationsFunction("rotateNeedle");
    	self.PI = math.pi;
    	self.PI_2 = math.pi / 2;
    
    	self.rpmNeedle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wskazowka.rpm#index"));
    	self.rpmNeedleMin = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wskazowka.rpm#min")));
    	self.rpmNeedleMax = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wskazowka.rpm#max")));
    	self.rpmLastValue = 0;
    
    	local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    	local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    	motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    	motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    	motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    	local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    	self.motorMaxRpmLimit = motorMaxRpm;

		self.exhaustParticleSystems2 = {};
    	local psName = "vehicle.exhaustParticleSystemExtra1";
    	Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems2, psName, self.rootNode, false, nil, self.baseDirectory)
	self.exhaustParticleSystems3 = {};
    	local psName = "vehicle.exhaustParticleSystemExtra2";
    	Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems3, psName, self.rootNode, false, nil, self.baseDirectory)
	self.exhaustParticleSystems4 = {};
    	local psName = "vehicle.exhaustParticleSystemExtra3";
    	Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems4, psName, self.rootNode, false, nil, self.baseDirectory)
	self.exhaustParticleSystems5 = {};
    	local psName = "vehicle.exhaustParticleSystemExtra4";
    	Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems5, psName, self.rootNode, false, nil, self.baseDirectory)
    
	turn1SoundFile = Utils.getFilename("dzwieki/turn1.wav", self.baseDirectory);
    	self.turn1 = createSample("turn1");
    	loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("dzwieki/turn2.wav", self.baseDirectory);
    	self.turn2 = createSample("turn2");
    	loadSample(self.turn2, turn2SoundFile, false);	
	
    	self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    	self.turnlights = {};
    	for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    	self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    	self.turnlights2 = {};
    	for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;

    	self.keys = {};
    	local i=0;
    	while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	self.frontlights.outs = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontlights.frontlight#src"));
	
	self.farlightsActive = false;
    	self.frontlightsActive = false;
	self.worklightsActive = false;
    	self.hornPlaying = false;
    	self.zuendungKey = false;
	self.allowedZuendung = false;
	self.odtwarzanie_dzwieku = false;
 
	self.lusterkaActive = true;
	self.lusterka5Active = false;
	self.lusterka2Active = true;
	self.lusterka3Active = false;
	self.lusterka4Active = false;

	self.lampaActive = false;
	self.lampa2Active = false;
	

    	self.hudUc385APosX = 0.705;
    	self.hudUc385AWidth = 0.27;
    	self.hudUc385APosY = 0.485;
    	self.hudUc385AHeight = 0.40;

	self.infoPanelUc385APath = Utils.getFilename("textury/HUD385A2.png", self.baseDirectory);
	self.hudUc385AOverlay = Overlay:new("hudUc385AOverlay", self.infoPanelUc385APath, self.hudUc385APosX, self.hudUc385APosY, self.hudUc385AWidth, self.hudUc385AHeight);

	self.showHudUc385A = false;

	self.hudInfoBasePosX = 0.615;
    	self.hudInfoBaseWidth = 0.34;
    	self.hudInfoBasePosY = 0.17;
    	self.hudInfoBaseHeight = 0.048;
    	self.infoPanelPath = Utils.getFilename("textury/hud2.png", self.baseDirectory);
    	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
    	self.showHudInfoBase = true;
		  
end;

function Uc385A:keyEvent(unicode, sym, modifier, isDown)

    	if isDown and sym == self.keys.rundumleuchte then
      	self.rundumleuchtenAn = not self.rundumleuchtenAn;
      	for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
   end;
	
	if isDown and sym == self.keys.rundumleuchte and not self.rotationMaxkogut == true then 
	  self.rundumleuchtenAn = not self.rundumleuchtenAn;
    end;

	if isDown and sym == Input.KEY_f3 then
		self.translationMaxkluczwloz = not self.translationMaxkluczwloz;
		self.lampaActive = not self.lampaActive;
	end;
	 if isDown and sym == Input.KEY_KP_enter and not self.translationMaxkluczwloz == true then 
		self.zuendungKey = not self.zuendungKey;
	end;
	if isDown and sym == Input.KEY_KP_5 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end;
	if isDown and sym == Input.KEY_f3 then 
		self.kluczactive = not self.kluczactive;
	end;
	if isDown and sym == Input.KEY_KP_0 then 
		self.kogutactive = not self.kogutactive;
	end;		
   
	if sym == Input.KEY_pageup then
		self.wajchapodMax = isDown;
	end;
	if sym == Input.KEY_pagedown then
		self.wajchapodMin = isDown;
	end;
    	if isDown and sym == Input.KEY_7 then
	    self.frontlightsActive = not self.frontlightsActive;
	    self.farlightsActive = false;
		self.worklightsActive = false;
	end;
	if isDown and sym == Input.KEY_8 then
		self.farlightsActive = not self.farlightsActive;
		self.frontlightsActive = false;
		self.worklightsActive = false;
	end;
    	if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
	if isDown and sym == Input.KEY_KP_8 then 
		self.wycieraczka = not self.wycieraczka;
	end;
 	if isDown and sym == Input.KEY_KP_7 then 
		self.rotationMaxdach = not self.rotationMaxdach;
	end;  
    
	if isDown and sym == Input.KEY_f then 
		self.rotationMaxwaj = not self.rotationMaxwaj;
	end;
	if isDown and sym == Input.KEY_f5 then 
		self.rotationMaxwaj2 = not self.rotationMaxwaj2;
		self.lusterka5Active = not self.lusterka5Active;
		self.farlightsActive = false;
		self.frontlightsActive = false;
	end;
	if sym == Input.KEY_KP_minus then
		self.wajchagazMax = isDown;
		end;
	if sym == Input.KEY_KP_plus then
		self.wajchagazMin = isDown;
		end;
 	if isDown and sym == Input.KEY_KP_9 then
		self.lusterkaActive = not self.lusterkaActive;
		self.lusterka2Active = not self.lusterka2Active;
	end;
	if isDown and sym == Input.KEY_f4 then
		self.lusterka3Active = not self.lusterka3Active;
	end;
 	if isDown and sym == Input.KEY_KP_0 then 
		self.rotationMaxkogut = not self.rotationMaxkogut;
	end;
	if sym == Input.KEY_z then
		self.lusterkoMax = isDown;
		self.lusterko2Max = isDown;
	end;
	if sym == Input.KEY_x then
		self.lusterkoMin = isDown;
		self.lusterko2Min = isDown;
	end;
	if sym == Input.KEY_insert then
		self.swiatlatylMax = isDown;
	end;
	if sym == Input.KEY_delete then
		self.swiatlatylMin = isDown;
	end;
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxteto = not self.rotationMaxteto;
	end;
	if isDown and sym == Input.KEY_KP_3 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
		self.rotationMaxwaj4 = not self.rotationMaxwaj4;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	if isDown and sym == Input.KEY_KP_1 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
		self.rotationMaxwaj3 = not self.rotationMaxwaj3;
	end;	

end;


function Uc385A:update(dt)

    	if self.isEntered then
	if self.wycieraczka then
		self.test = self.test - dt;
		if self.test < 0 then
				self.rotationMaxwycieraczka2 = not self.rotationMaxwycieraczka2;
				playSample(self.wycieraczkaSoundId,1,1,0);
			self.test = 1000;
		end;
	end;

		if self.podnosnikramie ~= nil and self.podnosnik ~= nil then
		local x,y,z = getRotation(self.podnosnikramie);
		if self.podnosnikstart == 0 and x ~= 0 then
			self.podnosnikstart = x;
		end;
		
		local podnosnikst = 5.62;
		local podnosnikRotation =  x * podnosnikst-self.podnosnikstart * podnosnikst;
		setRotation(self.podnosnik, podnosnikRotation, y,z);
		
		local podnosnikzaczepat = 4.41;
		local podnosnikzaczepRotation =  self.podnosnikstart * podnosnikzaczepat - x * podnosnikzaczepat;
		setRotation(self.podnosnikzaczep, podnosnikzaczepRotation, y,z);
		
	end;

	

	if self.translationPartkluczwloz ~= nil then 
		local x, y, z = getTranslation(self.translationPartkluczwloz.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartkluczwloz.maxTrans, self.translationPartkluczwloz.minTrans, 3, self.translationPartkluczwloz.transTime, dt, not self.translationMaxkluczwloz); 
		setTranslation(self.translationPartkluczwloz.node, unpack(newTrans)); 
	end;

	if self.rotationPartwajchahydraulika ~= nil then
		local x, y, z = getRotation(self.rotationPartwajchahydraulika.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwajchahydraulika.maxRot, self.rotationPartwajchahydraulika.minRot, 3, self.rotationPartwajchahydraulika.rotTime, dt, not self.rotationMaxwajchahydraulika);
		setRotation(self.rotationPartwajchahydraulika.node, unpack(newRot));
   	end;	

	if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) or InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) or InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
            self.rotationMaxwajchahydraulika = not self.rotationMaxwajchahydraulika;
        end;		
    end;
	
		if self.motor.speedLevel == 1 then
			self.rotationMaxbiegi = true;
	else
			self.rotationMaxbiegi = false;
	end;
		if self.motor.speedLevel == 2 then
			self.rotationMaxbiegi2 = true;
	else
			self.rotationMaxbiegi2 = false;
	end;
		if self.motor.speedLevel == 3 then
			self.rotationMaxbiegi3 = true;
	else
			self.rotationMaxbiegi3 = false;
	end;
		if self.motor.speedLevel == 0 then
			self.rotationMaxbiegir = true;
	else
			self.rotationMaxbiegir = false;
	end;		
	
		if self.rotationPartwycieraczka2 ~= nil then
		local x, y, z = getRotation(self.rotationPartwycieraczka2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwycieraczka2.maxRot, self.rotationPartwycieraczka2.minRot, 3, self.rotationPartwycieraczka2.rotTime, dt, not self.rotationMaxwycieraczka2);
		setRotation(self.rotationPartwycieraczka2.node, unpack(newRot));
   	end;	
		local doRotate = self.wajchapodMax or self.wajchapodMin 
		if self.wajchapod ~= nil and doRotate then
        	local x, y, z = getRotation(self.wajchapod.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.wajchapod.maxRot, self.wajchapod.minRot, 3, self.wajchapod.rotTime, dt, not self.wajchapodMax);
        	setRotation(self.wajchapod.node, unpack(newRot));
	end;	

		if self.rotationPartklucz ~= nil then
		local x, y, z = getRotation(self.rotationPartklucz.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklucz.maxRot, self.rotationPartklucz.minRot, 3, self.rotationPartklucz.rotTime, dt, not self.rotationMaxklucz);
		 setRotation(self.rotationPartklucz.node, unpack(newRot));
        end;
	    	if self.rotationPartbackwindow ~= nil then
		local x, y, z = getRotation(self.rotationPartbackwindow.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		setRotation(self.rotationPartbackwindow.node, unpack(newRot));
        end;
 		if self.rotationPartkogut ~= nil then
		local x, y, z = getRotation(self.rotationPartkogut.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkogut.maxRot, self.rotationPartkogut.minRot, 3, self.rotationPartkogut.rotTime, dt, not self.rotationMaxkogut);
		setRotation(self.rotationPartkogut.node, unpack(newRot));
        end;
		if self.rotationPartteto ~= nil then
		local x, y, z = getRotation(self.rotationPartteto.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartteto.maxRot, self.rotationPartteto.minRot, 3, self.rotationPartteto.rotTime, dt, not self.rotationMaxteto);
		setRotation(self.rotationPartteto.node, unpack(newRot));
        end;
		if self.rotationPartdach ~= nil then
		local x, y, z = getRotation(self.rotationPartdach.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartdach.maxRot, self.rotationPartdach.minRot, 3, self.rotationPartdach.rotTime, dt, not self.rotationMaxdach);
		setRotation(self.rotationPartdach.node, unpack(newRot));
        end;
		if self.rotationPartmaska ~= nil then
		local x, y, z = getRotation(self.rotationPartmaska.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmaska.maxRot, self.rotationPartmaska.minRot, 3, self.rotationPartmaska.rotTime, dt, not self.rotationMaxmaska);
		setRotation(self.rotationPartmaska.node, unpack(newRot));
        end;

		local doRotate = self.wajchagazMax or self.wajchagazMin 
		if self.wajchagaz ~= nil and doRotate then
        	local x, y, z = getRotation(self.wajchagaz.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.wajchagaz.maxRot, self.wajchagaz.minRot, 3, self.wajchagaz.rotTime, dt, not self.wajchagazMax);
        	setRotation(self.wajchagaz.node, unpack(newRot));
	end;
		local doRotate = self.lusterkoMax or self.lusterkoMin 
		if self.lusterko ~= nil and doRotate then
        	local x, y, z = getRotation(self.lusterko.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.lusterko.maxRot, self.lusterko.minRot, 3, self.lusterko.rotTime, dt, not self.lusterkoMax);
        	setRotation(self.lusterko.node, unpack(newRot));
	end;
		local doRotate = self.swiatlatylMax or self.swiatlatylMin 
		if self.swiatlatyl ~= nil and doRotate then
        	local x, y, z = getRotation(self.swiatlatyl.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.swiatlatyl.maxRot, self.swiatlatyl.minRot, 3, self.swiatlatyl.rotTime, dt, not self.swiatlatylMax);
        	setRotation(self.swiatlatyl.node, unpack(newRot));
	end;

		if self.rotationPartwaj ~= nil then
		local x, y, z = getRotation(self.rotationPartwaj.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwaj.maxRot, self.rotationPartwaj.minRot, 3, self.rotationPartwaj.rotTime, dt, not self.rotationMaxwaj);
		setRotation(self.rotationPartwaj.node, unpack(newRot));
        end;
		if self.rotationPartwaj4 ~= nil then
		local x, y, z = getRotation(self.rotationPartwaj4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwaj4.maxRot, self.rotationPartwaj4.minRot, 3, self.rotationPartwaj4.rotTime, dt, not self.rotationMaxwaj4);
		setRotation(self.rotationPartwaj4.node, unpack(newRot));
        end;
		if self.rotationPartwaj3 ~= nil then
		local x, y, z = getRotation(self.rotationPartwaj3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwaj3.maxRot, self.rotationPartwaj3.minRot, 3, self.rotationPartwaj3.rotTime, dt, not self.rotationMaxwaj3);
		setRotation(self.rotationPartwaj3.node, unpack(newRot));
        end;
		if self.rotationPartwaj2 ~= nil then
		local x, y, z = getRotation(self.rotationPartwaj2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwaj2.maxRot, self.rotationPartwaj2.minRot, 3, self.rotationPartwaj2.rotTime, dt, not self.rotationMaxwaj2);
		setRotation(self.rotationPartwaj2.node, unpack(newRot));
        end;
		local doRotate = self.lusterko2Max or self.lusterko2Min 
		if self.lusterko2 ~= nil and doRotate then
        	local x, y, z = getRotation(self.lusterko2.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.lusterko2.maxRot, self.lusterko2.minRot, 3, self.lusterko2.rotTime, dt, not self.lusterko2Max);
        	setRotation(self.lusterko2.node, unpack(newRot));
	end;
		if self.rotationPartbiegi ~= nil then
		local x, y, z = getRotation(self.rotationPartbiegi.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbiegi.maxRot, self.rotationPartbiegi.minRot, 3, self.rotationPartbiegi.rotTime, dt, not self.rotationMaxbiegi);
		setRotation(self.rotationPartbiegi.node, unpack(newRot));
        end;
		if self.rotationPartbiegir ~= nil then
		local x, y, z = getRotation(self.rotationPartbiegir.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbiegir.maxRot, self.rotationPartbiegir.minRot, 3, self.rotationPartbiegir.rotTime, dt, not self.rotationMaxbiegir);
		setRotation(self.rotationPartbiegir.node, unpack(newRot));
        end;
		if self.rotationPartbiegi3 ~= nil then
		local x, y, z = getRotation(self.rotationPartbiegi3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbiegi3.maxRot, self.rotationPartbiegi3.minRot, 3, self.rotationPartbiegi3.rotTime, dt, not self.rotationMaxbiegi3);
		setRotation(self.rotationPartbiegi3.node, unpack(newRot));
        end;
		if self.rotationPartbiegi2 ~= nil then
		local x, y, z = getRotation(self.rotationPartbiegi2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbiegi2.maxRot, self.rotationPartbiegi2.minRot, 3, self.rotationPartbiegi2.rotTime, dt, not self.rotationMaxbiegi2);
		setRotation(self.rotationPartbiegi2.node, unpack(newRot));
        end;

        
		if self.rotationPartpedalgazu ~= nil then
		local x, y, z = getRotation(self.rotationPartpedalgazu.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpedalgazu.maxRot, self.rotationPartpedalgazu.minRot, 3, self.rotationPartpedalgazu.rotTime, dt, not self.rotationMaxpedalgazu);
		setRotation(self.rotationPartpedalgazu.node, unpack(newRot));
	end;
		if self.rotationPartpedalhamulca ~= nil then
		local x, y, z = getRotation(self.rotationPartpedalhamulca.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpedalhamulca.maxRot, self.rotationPartpedalhamulca.minRot, 3, self.rotationPartpedalhamulca.rotTime, dt, not self.rotationMaxpedalhamulca);
		setRotation(self.rotationPartpedalhamulca.node, unpack(newRot));
	end;
		if self.rotationPartsprzeglo ~= nil then
		local x, y, z = getRotation(self.rotationPartsprzeglo.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartsprzeglo.maxRot, self.rotationPartsprzeglo.minRot, 3, self.rotationPartsprzeglo.rotTime, dt, not self.rotationMaxsprzeglo);
		setRotation(self.rotationPartsprzeglo.node, unpack(newRot));
	end;
		if self.rotationPartsprzeglo2 ~= nil then
		local x, y, z = getRotation(self.rotationPartsprzeglo2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartsprzeglo2.maxRot, self.rotationPartsprzeglo2.minRot, 3, self.rotationPartsprzeglo2.rotTime, dt, not self.rotationMaxsprzeglo2);
		setRotation(self.rotationPartsprzeglo2.node, unpack(newRot));
	end;
		if self.rotationPartsprzeglo3 ~= nil then
		local x, y, z = getRotation(self.rotationPartsprzeglo3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartsprzeglo3.maxRot, self.rotationPartsprzeglo3.minRot, 3, self.rotationPartsprzeglo3.rotTime, dt, not self.rotationMaxsprzeglo3);
		setRotation(self.rotationPartsprzeglo3.node, unpack(newRot));
	end;

		if self.isEntered then
			if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
				self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
    

	if self.isEntered then
		if self.isMotorStarted then
			self.rotationMaxklucz = true;
		else
			self.rotationMaxklucz = false;
		end;
	end;
		if self.isEntered then
		if Input.isKeyPressed(Input.KEY_w) then
			self.rotationMaxpedalgazu = true;
		else
			self.rotationMaxpedalgazu = false;
		end;
			if Input.isKeyPressed(Input.KEY_3) then
			self.rotationMaxsprzeglo = true;
		else
			self.rotationMaxsprzeglo = false;
		end;
		if Input.isKeyPressed(Input.KEY_2) then
			self.rotationMaxsprzeglo2 = true;
		else
			self.rotationMaxsprzeglo2 = false;
		end;
		if Input.isKeyPressed(Input.KEY_1) then
			self.rotationMaxsprzeglo3 = true;
		else
			self.rotationMaxsprzeglo3 = false;
		end;
		if Input.isKeyPressed(Input.KEY_s) then
			self.rotationMaxpedalhamulca = true;
		else
			self.rotationMaxpedalhamulca = false;
		end;
	end;
	
	    	   if self.isEntered then
        	   if self.worklightsActive then
		   for i=1, self.numWorklights do
		   local worklight = self.worklights[i];
		   setVisibility(worklight, self.worklightsActive);
		end;
	else
			for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
		end;
	end;

		setVisibility(self.lusterka, self.lusterkaActive);
		setVisibility(self.lusterka5, self.lusterka5Active);
		setVisibility(self.lusterka4, self.lusterka4Active);
		setVisibility(self.lusterka3, self.lusterka3Active);
		setVisibility(self.lusterka2, self.lusterka2Active);
		setVisibility(self.lampa, self.lampaActive);
		setVisibility(self.lampa2, self.lampa2Active);
		setVisibility(self.cos, self.cosActive);
	

	    
		   if self.isEntered then
		   if self.frontlightsActive then
		   for i=1, self.numFrontlights do
		   local frontlight = self.frontlights[i];
		   setVisibility(frontlight, self.frontlightsActive);
		end;
	else
			for i=1, self.numFrontlights do
			local frontlight = self.frontlights[i];
			setVisibility(frontlight, self.frontlightsActive, false);
			setVisibility(self.frontlights.outs, true);
				end;
			end;
		end;
	end;
	
		   if self.isEntered then
        	   if self.farlightsActive then
		   for i=1, self.numFarlights do
		   local farlight = self.farlights[i];
		   setVisibility(farlight, self.farlightsActive);
		end;
	else 
	    		if not self.farlightsActive then
			for i=1, self.numFarlights do
			local farlight = self.farlights[i];
			setVisibility(farlight, self.farlightsActive, false);
			end;
		end;
 	end;
 
        	if self.isEntered then
          	if self.frontlightsActive then
            	setVisibility(self.frontlights.outs, false);
          else
            	setVisibility(self.frontlights.outs, true);
             end;
        end;
		
         if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.hasEvent(InputBinding.RADIO2) then
               if not self.radioSoundPlaying then 
               playSample(self. radioSound, 0, self. radioSoundVolume, 0); 
               self.radioSoundPlaying = true; 
           else 
                stopSample(self. radioSound); 
                self.radioSoundPlaying = false; 
             end;  
          end;

        inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;
			
		if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
    end;
		  
		if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.HUPE) then
        	if not self.hornPlaying then
            	playSample(self.hornSoundId, 0, 1, 0);
            	self.hornPlaying = true;
        end;
    else
        	if self.hornPlaying then
                stopSample(self.hornSoundId);
                self.hornPlaying = false;
        end;
    end;

        	if self.rundumleuchtenAn then
          	for i=1, self.rundumleuchtenAnz do
                rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
        
		if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
                (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
                not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

		if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    		for k, light in pairs(self.lights) do
       		 setVisibility(light, self.lightsActive);
        end; 
    

    	if not self.isAITractorActivated then
       
        	if self:getIsActiveForInput() then
            	if InputBinding.hasEvent(InputBinding.ZUENDUNG) then
		self.zuendungKey = not self.zuendungKey;
	        self.allowedZuendung = true;
	        end;
	end;
		
	    
	    if not self.allowedZuendung and  not self.zuendungKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	
	   
	    	if not self.zuendungKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	end;
		
	    
	    	if self.allowedZuendung then
	        if  not self.zuendungKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedZuendung = false;	
		
			    
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.zuendungKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedZuendung = false;		
       	    end;
	    end;
   
    		elseif not self.zuendungKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
 		if self.motor.lastMotorRpm > 750 and self.isMotorStarted then

		if self.klapa ~= nil then
        	local x, y, z = getRotation(self.klapa.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.klapa.maxRot, self.klapa.minRot, 3, self.klapa.rotTime, dt, self.isMotorStarted);
        	setRotation(self.klapa.node, unpack(newRot));
    	end;
        	Utils.setEmittingState(self.exhaustParticleSystemextra, true)
		if self.motor.lastMotorRpm > 1300 then
		Utils.setEmittingState(self.exhaustParticleSystemextra1, true)

	else

		Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
	end;
						
    	elseif self.isMotorStarted then
	self.klapaplay = math.random(300,1300);

		if self.klapa ~= nil then
        	local x, y, z = getRotation(self.klapa.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, {90,0,0}, {self.klapaplay*0.001,0,0}, 3, 60000, dt, self.isMotorStarted);
        	setRotation(self.klapa.node, unpack(newRot));
    	end;
        	Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
        	Utils.setEmittingState(self.exhaustParticleSystemextra, false)
        	Utils.setEmittingState(self.exhaustParticleSystem, true)
    else

	if self.isAITractorActivated then
			if self.klapa ~= nil then
        		local x, y, z = getRotation(self.klapa.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.klapa.maxRot, self.klapa.minRot, 3, self.klapa.rotTime, dt, true);
        		setRotation(self.klapa.node, unpack(newRot));
    		end;
			Utils.setEmittingState(self.exhaustParticleSystemextra, true)
	else
			if self.klapa ~= nil then
        		local x, y, z = getRotation(self.klapa.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.klapa.maxRot, self.klapa.minRot, 3, self.klapa.rotTime, dt, false);
        		setRotation(self.klapa.node, unpack(newRot));
    	      		end;
	    	   end;
	       end;
	 end;
  

    	    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            		if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    		end;
		end;
	end;

        	if self.camIndex == 1 then
            
            	local rpmValue = 0;
            	if self.isMotorStarted then
                rpmValue = self.motor.lastMotorRpm;

            end;
            	if rpmValue ~= self.rpmLastValue then
                rpmPerc = rpmValue / self.motorMaxRpmLimit[3];
                self:rotateNeedle(self.rpmNeedle, rpmPerc, self.rpmNeedleMin, self.rpmNeedleMax);
                self.rpmLastValue = rpmValue;
            end;
        end; 
	    		if self.flash then
		    	if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
		    end;
		    		if not self.flashlightsRightActive then
			    	if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	    self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	    self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
			if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	if self:getIsActiveForInput() and self.isEntered then
    

		if InputBinding.hasEvent(InputBinding.U385A) then
		    self.showHudUc385A = not self.showHudUc385A;
		end;
	end;

 	if self.isEntered and (Input.isKeyPressed(Input.KEY_a) or Input.isKeyPressed(Input.KEY_d)) then
        if not self.odtwarzanie_dzwieku then
            playSample(self.skretSoundId, 0, 1, 0);
            self.odtwarzanie_dzwieku = true;
        end;

    	else

        if self.odtwarzanie_dzwieku then
            stopSample(self.skretSoundId);
            self.odtwarzanie_dzwieku = false;
        end;
    end;
	
	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		   if self.fuelFillLevel <= 19 then
          		self.lusterka4Active = true;
				else
			self.lusterka4Active = false;
      		end;
		if self.fuelFillLevel <= 18 then

          		self.paliwoactive = false;
      		end;


		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    		if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	

		if self.isEntered then
		if self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, true);
		end;

		if not self.attachedTrailer or not self.motor.speedLevel == 0 or self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, false);
		end;

		if self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, true);
		end;

		if not self.attachedTrailer or self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, false);
		end;

		if not self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, true);
		end;

		if not self.attachedTrailer and self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, false);
		end;
		
		if not self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, true);
		end;

		if not self.attachedTrailer and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, false);
		end;
	end;
		if self.isMotorStarted then
		if self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, true);
		end;
		if not self.attachedTrailer or not self.motor.speedLevel == 0 or self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, false);
		end;
		if self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, true);
		end;
		if not self.attachedTrailer or self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, false);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, false);
		end;
		
		if not self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, false);
		end;
	end;

end;

function Uc385A:draw()

    if self.isEntered then
		if not self.helpPanel then
			renderText(0.795, 0.188, 0.02, "Nacisnij 0: Pokaz Info");
		else
			renderText(0.795, 0.188, 0.02, "Nacisnij 0: Schowaj Info");
		end;
	end;
		if self.helpPanel then
			renderText(0.72, 0.84, 0.025, "- ZETOR 7211 -");
			renderText(0.72, 0.815, 0.02, "Nacisnij 4: Zapal Silnik");	
			renderText(0.72, 0.8, 0.02, "Nacisnij 5: Klakson");			
			renderText(0.72, 0.785, 0.02, "Nacisnij 6: Kogut");
			renderText(0.72, 0.77, 0.02, "Nacisnij f5: Halogeny Tylne");
			renderText(0.72, 0.755, 0.02, "Nacisnij Num 5: Tylna Szyba");			
			renderText(0.72, 0.74, 0.02, "Nacisnij Num 4: Lewe Drzwi");
			renderText(0.72, 0.725, 0.02, "Nacisnij Num 6: Prawe Drzwi");
			renderText(0.72, 0.71, 0.02, "Nacisnij T: Radio");
                        renderText(0.72, 0.695, 0.02, "Nacisnij NUM 1 - Lewy Kierunkowskaz");
			renderText(0.72, 0.68, 0.02, "Nacisnij Num 2 - Awaryjki");
			renderText(0.72, 0.665, 0.02, "Nacisnij Num 3 - Prawy Kierunkowskaz");
			renderText(0.72, 0.65, 0.02, "Nacisnij 7 - Halogeny Przednie");
			renderText(0.72, 0.635, 0.02, "Nacisnij 8 - Lampa Robocza Tylna");
			renderText(0.72, 0.62, 0.02, "Nacisnij NUM 7 - Dach");
			renderText(0.72, 0.605, 0.02, "Nacisnij f4: Oswietlenie wnetrza 385A");
			renderText(0.72, 0.59, 0.02, "Nacisnij NUM 9: Lusterka");
			renderText(0.72, 0.575, 0.02, "Nacisnij NUM 0: Rozloz Kogut");
			renderText(0.72, 0.56, 0.02, "Nacisnij Z/X: Ustaw Lusterko");
			renderText(0.72, 0.545, 0.02, "Nacisnij f3: Wloz klucz");
			renderText(0.72, 0.53, 0.02, "Nacisnij NUM 8: Wlacz Wycieraczke");
			renderText(0.755, 0.48, 0.02, "by KamilLS & RotoR And Pan An");
		end;

	if self.showHudUc385A and self.isEntered then
		self.hudUc385AOverlay:render();
	end;
	if self.showHudInfoBase and self.isEntered then
		self.hudInfoBaseOverlay:render();
	end;

	if self.kluczactive then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if Input.isKeyPressed(Input.KEY_KP_enter) then
			g_currentMission:addWarning(("Wloz kluczyk (key f3)?"), 0.05, 0.025+0.007);
		end;
	end;
	if self.kogutactive then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if Input.isKeyPressed(Input.KEY_6) then
			g_currentMission:addWarning(("Najpierw rozloz kogut(key kp 0)"), 0.05, 0.025+0.007);
		end;
	end;
	if self.paliwoactive then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if self.fuelFillLevel <= 19 then
			g_currentMission:addWarning(("Malo paliwa - Zatankuj"), 0.05, 0.025+0.007);
		end;
	end;


    	if not self.isMotorStarted and not self.automaticStart then	
        g_currentMission:addHelpButtonText(g_i18n:getText("Zndung2"), InputBinding.ZUENDUNG);
	end;

	if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Nacisnij NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
            g_currentMission:addExtraPrintText("Nacisnij NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
end;

function Uc385A:onEnter()
	if not self.zuendungKey then
	Utils.setEmittingState(self.exhaustParticleLow, false);
	self.isMotorStarted = false;
	Motorized.stopSounds(self);
	self.steeringEnabled = false;
    else
	    self.steeringEnabled = true;
	end;
    	setVisibility(self.aiMotorSound, false);
end;

function Uc385A:onLeave()
    	self.rundumleuchtenAn = false;
    	for i=1, self.rundumleuchtenAnz do
       	setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);

 	self.lusterkasActive = true;
	self.lusterka5sActive = false;
	self.lusterka4sActive = false;
	self.lusterka2sActive = true;
	self.lampasActive = false;
	self.lampa2sActive = false;
	self.cossActive = false;
	self.lusterka3sActive = false;
    end;
   	 self.worklightsActive = false;
	
	if self.radioSound ~= nil then
        stopSample(self.radioSound);
    end;
	
	if not self.deactivateOnLeave then
		Utils.setEmittingState(self.exhaustParticleSystems, true)
	    	self.allowedZuendung = false;
		self.isMotorStarted = true;
	    	self.zuendungKey = true; 
		self.steeringEnabled = true;
		setVisibility(self.aiMotorSound, true);

		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
	else
		self.allowedZuendung = false;
		self.zuendungKey = false;
		self.isMotorStarted = false;	
	end;

		Utils.setEmittingState(self.exhaustParticleSystems2, false);
		Utils.setEmittingState(self.exhaustParticleSystems3, false);
		Utils.setEmittingState(self.exhaustParticleSystems4, false);
		Utils.setEmittingState(self.exhaustParticleSystems5, false);
end;

function Uc385A:delete()

    	delete(self.hornSoundId);
	delete(self.radioSound);
	
 	if self.hudUc385AOverlay ~= nil then
		self.hudUc385AOverlay:delete();
	end;
	if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;

 	delete(self.skretSoundId);
end;

function Uc385A:rotateNeedle(object, percent, min, max) 

    angle = min + (max - min) * percent;
    setRotation(object, self.PI, angle, self.PI_2);
end;


function Uc385A:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Uc385A:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;