moveAttacherEvent = {};
moveAttacherEvent_mt = Class(moveAttacherEvent, Event);

InitEventClass(moveAttacherEvent, "moveAttacherEvent");

function moveAttacherEvent:emptyNew()
    local self = Event:new(moveAttacherEvent_mt);
    self.className="moveAttacherEvent";
    return self;
end;

function moveAttacherEvent:new(object, data)
    local self = moveAttacherEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function moveAttacherEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.data = streamReadInt8(streamId);
	self.object.yAttacher = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(moveAttacherEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function moveAttacherEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.data);
end;


function moveAttacherEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(moveAttacherEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(moveAttacherEvent:new(vehicle, data));
	end;
end;

