Pickup = {};

function Pickup.prerequisitesPresent(specializations)
    return true;
end;

function Pickup:load(xmlFile)
self.setRotateDirection4= SpecializationUtil.callSpecializationsFunction("setRotateDirection4"); 
    self.haspel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.haspel1#index"));
    self.haspel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.haspel2#index"));
    self.haspel3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.haspel3#index"));

local rotationPartNodeRotation4= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Rotation4#index"));
    if rotationPartNodeRotation4 ~= nil then
        self.Rotation4 = {};
        self.Rotation4.node = rotationPartNodeRotation4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rotation4#minRot"));
        self.Rotation4.minRot = {};
        self.Rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rotation4#maxRot"));
        self.Rotation4.maxRot = {};
        self.Rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Rotation4#rotTime"), 2)*1000;
    end; 
end;

function Pickup:delete()
end;

function Pickup:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Pickup:keyEvent(unicode, sym, modifier, isDown)

end;

function Pickup:readStream(streamId, connection) 
     self:setRotateDirection4(streamReadBool(streamId), true);  
end;

function Pickup:writeStream(streamId, connection) 
    streamWriteBool(streamId, self.currentRotationDir4);  
end;

function Pickup:update(dt)
  if self:getIsActive() then
    if InputBinding.hasEvent(InputBinding.Pickup) then
             self:setRotateDirection4(not self.currentRotationDir4); 
    end;
    if self.isTurnedOn and self.haspel1 ~= nil then
		rotate(self.haspel1, dt*0.005, 0, 0);
    end;
    if self.isTurnedOn and self.haspel2 ~= nil then
		rotate(self.haspel2, dt*0.005, 0, 0);
    end;
    if self.isTurnedOn and self.haspel3 ~= nil then
		rotate(self.haspel3, dt*0.005, 0, 0);
    end;
	if self.Rotation4 ~= nil then
		local x, y, z = getRotation(self.Rotation4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Rotation4.maxRot, self.Rotation4.minRot, 3, self.Rotation4.rotTime, dt, not self.currentRotationDir4); 
		setRotation(self.Rotation4.node, unpack(newRot));
    end;
  end;
end;

function Pickup:updateTick(dt) 
end;

function Pickup:setRotateDirection4(newDirection, noEventSend)  
    PickupEvent.sendEvent(self, newDirection, noEventSend);	
    self.currentRotationDir4 = newDirection;
end;

function Pickup:draw()
	if self.attacherVehicle ~= nil then
	if self.currentRotationDir4 then	
                g_currentMission:addHelpButtonText(g_i18n:getText("Pickup_up"), InputBinding.Pickup);
	else
                g_currentMission:addHelpButtonText(g_i18n:getText("Pickup_down"), InputBinding.Pickup);
	end;
end; 
end; 