--
-- HectarCOunter
-- Specialization for counting the operating hours of a vehicle
--
-- @author:  	Manuel Leithner
-- @date:		29/08/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 (Networksupport) and some bugfixes
--

HectarCOunter = {};

function HectarCOunter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function HectarCOunter:load(xmlFile)

	self.addHectars = SpecializationUtil.callSpecializationsFunction("addHectars");
	self.numHectars = 0;	
	self.allHectars = 0;
	
	self.hcX = 0.7543;
	self.hcY = 0.2115;
	self.yOffset = 0.0077;
	self.hcOverlay = Overlay:new("hudOHOverlay", Utils.getFilename("textures/hectar_hud.png", self.baseDirectory), self.hcX, self.hcY, 0.238, 0.039525);	
end;

function HectarCOunter:delete()
end;

function HectarCOunter:readStream(streamId, connection)
	self:addHectars(streamReadFloat32(streamId), true);
end;

function HectarCOunter:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.numHectars);
	streamWriteFloat32(streamId, self.allHectars);
end;

function HectarCOunter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HectarCOunter:keyEvent(unicode, sym, modifier, isDown)
end;
function HectarCOunter:update(dt)
end;
function HectarCOunter:updateTick(dt)
    if (self:getIsActive() or self.isHired) and self.isThreshing then 
		self:addHectars(dt);
	end;
end;

function HectarCOunter:draw()
	
	local HectarCOunter = math.floor(self.numHectars*100) / 100;
	local hours = math.floor(HectarCOunter);
	local minutes = math.floor((HectarCOunter - hours)*10);
	local seconds = math.floor((HectarCOunter - hours - minutes/10)*100);
	
	local allHectarCOunter = math.floor(self.allHectars*10) / 10;
	local allhours = math.floor(allHectarCOunter);	
	local allminutes = tostring(math.floor((allHectarCOunter - allhours)*10));	
	
	self.hcOverlay:render();
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	renderText(self.hcX+0.08, self.hcY+self.yOffset, 0.022, tostring(hours) .. ",");
	setTextColor(0.95,0,0,1);
	renderText(self.hcX+0.089, self.hcY+self.yOffset, 0.023, tostring(minutes));
	renderText(self.hcX+0.098, self.hcY+self.yOffset, 0.023, tostring(seconds));	
	setTextColor(1,1,1,1);
	renderText(self.hcX+0.118, self.hcY+self.yOffset, 0.023, "ha");	
	renderText(self.hcX+0.181, self.hcY+self.yOffset, 0.022, tostring(allhours) .. ",");
	renderText(self.hcX+0.19, self.hcY+self.yOffset, 0.022, allminutes);		
	renderText(self.hcX+0.212, self.hcY+self.yOffset, 0.023, "ha");
	setTextAlignment(RenderText.ALIGN_LEFT);
	renderText(self.hcX+0.03, self.hcY+self.yOffset, 0.023, "*1: ");		
	renderText(self.hcX+0.13, self.hcY+self.yOffset, 0.023, "*2: ");	
end;

function HectarCOunter:addHectars()

    if self.numAttachedCutters > 0 then
		for cutter,implement in pairs(self.attachedCutters) do		
			if cutter.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then			
				if cutter.cuttingAreas ~= nil then
					local multi = 1;
					for k,area in pairs(cutter.cuttingAreas) do
						if cutter:getIsAreaActive(area) then
							local x,y,z = getWorldTranslation(area.start);
							local x1,y1,z1 = getWorldTranslation(area.width);
							local x2,y2,z2 = getWorldTranslation(area.height);
							--table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
							local spray = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sprayChannel, x, z, x1, z1, x2, z2);							
							if spray > 0 then
								multi = 2;
							end;
						end;
					end;
					
					realarea = (cutter.lastArea/multi)/g_currentMission.maxFruitValue;
					

						local pixelToSqm = g_currentMission:getFruitPixelsToSqm(); -- 4096px are mapped to 2048m
						local sqm = realarea*pixelToSqm;
						local ha = sqm/10000;							
						self.numHectars = self.numHectars + ha;
						self.allHectars = self.allHectars + ha;
						if self.numHectars > (99) then
							self.numHectars = 0;
						end;
				end;
			end;			
		end;	
	end;
end;

function HectarCOunter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local allHectars = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#allHectars"), self.allHectars);
        self.allHectars = allHectars
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function HectarCOunter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'allHectars="' .. tostring((self.allHectars)) ..'"';
	return attributes, nil;
end;